# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("elisa")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 1.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Elisa example ") 
cat("\n ---------------------------")
cat("\n\n") 

# ------------------------------------------------------------
# Creation of the model -evaluation programs
lesystem(paste(.Nls2dir, "/analDer ", elisa.mod1, " > elisa.mod1.c", sep=""))
lesystem(paste(.Nls2dir, "/analDer ", elisa.mod2, " > elisa.mod2.c", sep=""))
lesystem(paste(.Nls2dir, "/crPsi ", elisa.modro, " > elisa.ro.c", sep=""))
lesystem(paste(.Nls2dir, "/crPsi ", elisa.modwald, " > elisa.wald.c", sep=""))

# ------------------------------------------------------------

cat("\n Plot of the observed responses versus the logarithm of the dilution ") 
  cat("\n\n") 
if (interactive()) {X11(); ask.pause <-T} else { postscript(file="elisa.ps"); ask.pause <-F}
par (ask=ask.pause)

pldnls2(elisa,response.name="OD",X.names="logd", ask.pause=ask.pause)
# ------------------------------------------------------------------------

cat("\n Parameters estimation \n\n") 
nomlib <- loadnls2("elisa.mod1.c")

elisa.nl1<-nls2(elisa,elisa.mod1,rep(c(2,0,1,0),2))
cat( "Estimated values of the parameters:\n ")
print( elisa.nl1$theta); cat( "\n\n")

cat("\n Plot of the observed and fitted curves \n\n") 
plfit(elisa.nl1, title="ELISA assay", ask.pause=ask.pause)


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 2.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n ELISA test example:") 
cat("\n  comparison of curves ") 
cat("\n ---------------------------\n\n")

cat("\n Parameters estimation ") 
cat("\n\n") 
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("elisa.mod1.c", psi="elisa.wald.c")

cat("\n Wald test with asymptotic level 95% \n\n") 
elisa.wald <- wald(elisa.nl1,file=elisa.modwald)
  # Print the results:
cat("SW:",elisa.wald$statistic,"\n" )
cat("X2(3):", qchisq(0.95, 3),"\n" )
SF <- (elisa.wald$statistic*(32-8))/(32*3)
cat("SF:", SF,"\n" )
cat("F(3,24):", qf(0.95, 3,24), "\n" )

cat("\n Likelihood ratio tests ") 
cat("\n\n") 

elisa.nlH <- nls2(elisa, 
	list(file=elisa.mod1, eqp.theta=c(1,2,3,4,1,2,3,5)),
	rep(c(2,0,1,0),2), control=list(freq=0))
elisa.nlb <- nls2(elisa, 
	list(file=elisa.mod1, eqp.theta=c(1,2,3,4,1,2,3,4)),
	rep(c(2,0,1,0),2), control=list(freq=0))
cat("Estimated values of the parameters for the 3 hypothesis:\n")
print(elisa.nl1$theta)
print(elisa.nlH$theta)
print(elisa.nlb$theta)
cat("Estimated sums of squares for the 3 hypothesis:\n",
	elisa.nl1$rss, "\n", elisa.nlH$rss,"\n", 
	elisa.nlb$rss,"\n")
cat("Sl:",
	32*(log(elisa.nlH$rss) - log(elisa.nl1$rss)),
	32*(log(elisa.nlb$rss) - log(elisa.nlH$rss)),"\n" )
cat("X2(0.95,1):", qchisq(0.95,1),"\n" )
cat("Estimated value of beta:",
 elisa.nlH$theta["p4_1"] -  elisa.nlH$theta["p4_2"],"\n" )

cat("\n Confidence interval for $\rho$") 
cat("\n with asymptotic level 95% ") 
cat("\n\n") 
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("elisa.mod1.c",  psi="elisa.ro.c")

elisa.ro <- confidence(elisa.nlH, file=elisa.modro)
 # Print the results:
cat("Estimated value of rho:", elisa.ro$psi,"\n" )
cat("Estimated value of S:",elisa.ro$std.error,"\n" )
cat("nu <- (0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",elisa.ro$normal.conf.int,"\n" )
cat("t <- (0.975, 27):", qt(0.975,27),"\n" )
cat("Estimated value of It:",elisa.ro$student.conf.int,"\n" )

cat("\n Confidence interval for $\rho$") 
cat("\n using bootstrap with asymptotic level 95% \n\n") 
elisa.nlH <- nls2(elisa, 
	list(file=elisa.mod1, eqp.theta=c(1,2,3,4,1,2,3,5)),
	rep(c(2,0,1,0),2), control=list(freq=0),
	renls2=T)

elisa.boot.ro <- bootstrap(elisa.nlH,method="residuals",      
               file=elisa.modro, n.loops=199)
delnls2()
cat("Estimated value of rho:",elisa.ro$psi,"\n" )
cat("Estimated value of S:", elisa.ro$std.error,"\n" )
cat("b <- (0.025):", sort(elisa.boot.ro$tStar)[5],"\n" )
cat("b <- (0.975):", sort(elisa.boot.ro$tStar)[195],"\n" )
cat("Estimated value of Ib:", elisa.boot.ro$conf.int ,"\n" )   
cat("Bootstrap standard error:", sqrt(var(elisa.boot.ro$psiStar)))

hist(elisa.boot.ro$tStar, nclass=9)
title(sub="Histogram of bootstrap estimations for T")

# -------------------------------------------------------------
# The following is not in the book
# -----------------------------------------------------------

# -------------------------------------------------
# This example illustrates how to calculate a confidence interval
# based on the log-likelihood ratio for a function of parameters
# -------------------------------------------------
# The data are the data-frame "elisa" and the regression model is described
# in the file "elisa.mod1" 
# The function to test is described in the file "elisa.ro"
# and Normal and Student confidence intervals have been calculated
# for it in the structure "elisa.ro"
# -------------------------------------------------

# It is not possible to calculate a confidence interval
# based on the log-likelihood ratio for a function of the 
# parameters. So, the regression model is written again in 
# such a way that the function is considered as a parameter:
# see file "elisa.mod2".
# (Parameter "p4_c2" is replaced by: log10(ro)+p4_c1)

# In the data-frame which contains the experimental data
# the component "curves" is replaced by an independent variable
# called "courbe".
elisa2 <- elisa
elisa2$courbe <- rep(1, dim(elisa)[1])
elisa2$courbe[elisa$curves=="j"] <- 2
elisa2$curves <- NULL

# Then function `nls2' is called on these new data and model.
cat("\n Parameters estimation ") 
cat("\n\n") 
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("elisa.mod2.c")

elisa.nl2<-nls2(elisa2,list(file=elisa.mod2,inf.theta=c(rep(NA,7),0)),
 c(2,0,1,0, 2,0,1,1), method="MLT")

# Finally, function `conflike' is applied:
elisa.conf2<-conflike(elisa.nl2, parameter="ro")

# To compar, we calculate the 2 others types of confidence intervals:

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("elisa.mod1.c", psi="elisa.ro.c")

elisa.nl1<-nls2(elisa,elisa.mod1,rep(c(2,0,1,0),2))


elisa.conf1<- confidence(elisa.nl1, file=elisa.modro)

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
