# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("insect")


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 6.7")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Insect example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation \n\n") 

y <- insect$y
n <- insect$n
insect.glm <- glm(formula  = cbind(y,n-y) ~ log(DI) + DS, family=binomial)

nomlib <- loadnls2()
ctx <- list(theta.start=c(insect.glm$coeff[1:2],0,insect.glm$coeff[3],1),
       sigma2.type="KNOWN", sigma2=1, nameN="n",
	family="binomial")
mod <- list(file=insect.m, sup.theta=c(NaN,NaN,2,NaN,NaN),inf.theta=c(NaN,NaN,NaN,NaN,0))
insect.nl1 <- nls2( insect, mod, stat.ctx=ctx, method="QLT",
	control=list(freq=0))

cat( "Result of the estimation process:\n ")
print(summary(insect.nl1))
cat( "\nValue of the log-likelihood:\n ")
print(insect.nl1$log.binomial)
cat( "\nvalue of the minimum deviance:\n ")
print(insect.nl1$deviance)
cat( "\nDeviance residuals:\n ")
print(insect.nl1$dev.residuals)
cat( "\nvalue of the X2 of Pearson:\n ")
print(insect.nl1$rss)
cat( "\nPearson residuals:\n ")
print(insect.nl1$s.residuals)

if (interactive()) {X11(); par(ask= T)}  else { postscript(file="insect.ps"); par(ask=F)  }

par(cex=1.5)
freq <- insect$y/insect$n
proba <- insect.nl1$response/insect$n
plot( proba, freq, las=1,
    xlab="observed frequency",ylab="fitted probability")
abline(0,1)
par(mfrow=c(1,2))
plot( proba, insect.nl1$dev.residuals,
    ylab="deviance residuals", xlab="fitted probability",
    type="n")
text( proba, insect.nl1$dev.residuals,
    labels=insect$DI)
plot( proba, insect.nl1$s.residuals,
    ylab="Pearson residuals", xlab="fitted probability",
    type="n")
text( proba, insect.nl1$s.residuals,
    labels=insect$DS)
title(main="(b)")


cat("\n -------------------------")
cat("\nConfidence interval ")
cat("\n -------------------------")
I <- sort(unique(DI))
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2(psi="")
Int <- matrix(0,ncol=3,nrow=length(I))
for (i in 1:length(I)) {
ConfInt.logPsi <- confidence.nls2(insect.nl1,file=oddsRatio.m,varpsi=I[i])
Int[i,1] <- ConfInt.logPsi$psi
Int[i,2:3] <- ConfInt.logPsi$normal.conf.int
}
cat("Estimated values of the log odds ratio:\n")
print(cbind(I, Int[,1]))
cat("95% Confidence Interval for the log odds ratio:\n")
print( Int[,2:3])

Int <- cbind(I,exp(Int))
dimnames(Int) <- list(NULL,c("I","Psi","Inf.Psi","Sup.Psi"))
cat("Estimated values of the odds ratio:\n")
cat("and Confidence Interval:\n")
print(Int)

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
