# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("isomer")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 1.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Isomerization example ") 
cat("\n ---------------------------\n\n")

  cat("\n Parameters estimation ") 
  cat("\n\n\n") 
lesystem(paste(.Nls2dir, "/analDer ",isomer.mod1, " > isomer.mod1.c", sep=""))
nomlib <- loadnls2("isomer.mod1.c")
isomer.nl1<-nls2(isomer, isomer.mod1,
     list(theta.start=c(10,1,1,1), max.iters=100))
cat( "Estimated values of the parameters:\n ")
print( isomer.nl1$theta); cat( "\n\n")

cat("\n Plot of the fitted values versus the observed values \n\n\n") 

if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="isomer1.ps"); (ask.pause <- F)  }
plfit(isomer.nl1, wanted=list(O.F=T), title="Isomerization example", ask.pause=ask.pause)


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 2.6")
cat("\n#------------------------------------------------------")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("isomer.mod1.c" , psi="")

cat ("Confidence intervals for each parameter with asymptotic level 95%")
isomer.conf.par <- confidence(isomer.nl1)
print(matrix(c(isomer.conf.par$psi,
	isomer.conf.par$std.error,
	isomer.conf.par$normal.conf.int[,"lower"],
	isomer.conf.par$normal.conf.int[,"upper"]),
	ncol=4,
	dimnames=list(names(isomer.conf.par$psi),
	c("parameters", "std", "lower bound", "upper bound"))))

cat("\n\n\n Confidence regions for parameters\n\n")
isomer.ell <- ellips(isomer.nl1, axis=c(1,2))
isomer.cont <- iso(isomer.nl1, axis=c(1,2), 
            bounds=matrix(c(25,50,0.03,0.11),nrow=2))
   # Graphical functions of Splus
par(mfrow=c(1,2))
# argu: labex: pour splus seulement 
if (is.R()) 
	contour(isomer.ell,levels=qchisq(c(0.90,0.95,0.99),4),
		drawlabels=F)  else
       contour(isomer.ell,levels=qchisq(c(0.90,0.95,0.99),4),labex=0)

points(x=isomer.nl1$theta[1], y=isomer.nl1$theta[2])
title("Confidence ellipses")
if (is.R()) 
	contour(isomer.cont,levels=qchisq(c(0.90,0.95,0.99),4),
		drawlabels=F)  else 
  	contour(isomer.cont,levels=qchisq(c(0.90,0.95,0.99),4),labex=0)
title("Likelihood contours")
points(x=isomer.nl1$theta[1], y=isomer.nl1$theta[2])

cat ("\n Calculation of confidence intervals using bootstrap \n\n")
options(warn=-1)
isomer.nl1 <- nls2(isomer,isomer.mod1, c(36,.07,.04,.2),
          control=list(freq=0), renls2=T)
isomer.boot <- bootstrap(isomer.nl1, 
          method="residuals", n.loops=199)
delnls2()
options(warn=0)

cat("\n\n\n Histograms of ($widehat{T}^{*,b}$, $b=1,... 199$) for each parameter\n\n")
pStar <-  isomer.boot$pStar[isomer.boot$code==0,]
var.pStar <-  isomer.boot$var.pStar[isomer.boot$code==0,]
theta<-matrix(rep(isomer.nl1$theta,isomer.boot$n.loops), 
          ncol=4, byrow=T)
TT <-(pStar - theta)/  sqrt(var.pStar)
par(mfrow=c(2,2))
for (a in 1:4)
 {
 hist(TT[,a],probability=T,main="Isomerization example")
 title(sub=paste("Histogram of bootstrap estimations for T",a),xlab="")
 qx<-seq(from=min(TT[,a]),to=max(TT[,a]),length=75)
 lines(qx,dnorm(qx))
}

cat("\n\n\n Bootstrap estimations of standard error and bias for each parameter estimator\n\n")
SE.boot <- sqrt(diag(var(pStar)))
bias.boot <-  apply(pStar,2,mean)-isomer.nl1$theta
Pbias.boot <- 100*bias.boot/isomer.nl1$theta
b0.025.boot <- apply(TT,2,quantile,probs=0.025)
b0.975.boot <- apply(TT,2,quantile,probs=0.975)
binf.boot <- isomer.nl1$theta - 
         b0.975.boot*coef(isomer.nl1)$std.error
bsup.boot <- isomer.nl1$theta - 
         b0.025.boot*coef(isomer.nl1)$std.error 
  # Print the results:
print(matrix(c(SE.boot, bias.boot,Pbias.boot, 
                b0.025.boot,b0.975.boot,
                binf.boot, bsup.boot), ncol=7,
       dimnames=list(names(isomer.nl1$theta),
               c("S","BIAS","% of BIAS","b0.025","b0.975",
                  "lower bound","upper bound" ))))

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ",isomer.mod2, " > isomer.mod2.c", sep=""))
nomlib <- loadnls2("isomer.mod2.c", psi="")

isomer.nl2<-nls2(isomer,isomer.mod2,rep(1,4))
isomer.conf.par2 <- confidence(isomer.nl2)
print(matrix(c(isomer.conf.par2$psi,
                 isomer.conf.par2$std.error,
                 isomer.conf.par2$normal.conf.int[,"lower"],
                 isomer.conf.par2$normal.conf.int[,"upper"]),
        ncol=4,
        dimnames=list(names(isomer.conf.par2$psi),
                c("parameters","S",
                   "lower bound","upper bound" ))))

cat("\n\n Confidence regions with the new parametrization\n\n")
isomer.ell2 <- ellips(isomer.nl2, axis=c(1,2))
isomer.iso2 <- iso(isomer.nl2, axis=c(1,2))
   # Graphical functions of Splus
par(mfrow=c(1,2))
plot(x=c(-5,7),y=c(0.03,.07),type="n",xlab="b1",ylab="b2")
if (is.R())  
	contour(isomer.ell2,levels=qchisq(c(0.90,0.95,0.99),4),
         add=T, drawlabels=F) else
	contour(isomer.ell2,levels=qchisq(c(0.90,0.95,0.99),4),
         add=T, labex=0)

points(x=isomer.nl2$theta[1], y=isomer.nl2$theta[2])
title("Confidence ellipses")
plot(x=c(-5,7),y=c(0.03,.07),type="n",xlab="b1",ylab="b2")
if (is.R())  
	contour(isomer.iso2,levels=qchisq(c(0.90,0.95,0.99),4),
         add=T, drawlabels=F) else
	contour(isomer.iso2,levels=qchisq(c(0.90,0.95,0.99),4),
         add=T, labex=0)
title("Likelihood contours")


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")

cat("\n ----------------------------------------------------")
cat("\n Isomerization example: graphics for diagnostic ")
cat("\n ----------------------------------------------------\n\n")

cat("\n Plotting the fitted values of the response against its observed values ") 
cat("\n\n") 
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="isomer2.ps"); (ask.pause <- F)  }

plfit(isomer.nl1, smooth=T, wanted=list(O.F=T),
    title="Isomerization example", ask.pause=ask.pause,
    ask.modify=ask.pause)
abline(0,1)

cat("\n Plotting the residuals \n\n") 

plres(isomer.nl1,     wanted=list(F.R=T, R.R=T, I.R=T),
    absolute=T, ask.pause=ask.pause,
     title="Isomerization example")


if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++

