# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data
data("miners")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 7.1.8")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Miners example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation \n\n") 

nomlib <- loadnls2()
# Exemple mineurs

ctx <- list(theta.start=rep(0,4), 
              sigma2.type="KNOWN", sigma2=1,
	family="multinomial", nameN="n")
miners.nl1 <- nls2(miners, miners.m, stat.ctx=ctx, method="QLT",
	control=list(freq=0))

cat( "Result of the estimation process:\n ")
print(summary(miners.nl1))

cat( "Minimum deviance:", miners.nl1$deviance, 
     "X2(0.95,12)", qchisq(0.95,12), "\n\n" )

print(miners.nl1$dev.residuals)

if (interactive()) {X11(); par(ask= T)} else { postscript(file="miners.ps"); par(ask= F)  }
plres(miners.nl1, wanted=list(X.R=T), st=T)
# ---------------------------------------------------

cat("\n ---------------------------")
cat("\n Confidence intervals \n\n") 


if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2(psi="")
lp.conf <- confidence(miners.nl1,
                        file=miners.log.proba.m,
                        varpsi=as.matrix(miners[,c(1,4)]))
IN <- lp.conf$normal.conf.int
exp.IN <- exp(IN)
result <- cbind(lp.conf$psi, lp.conf$std.error, IN,
                exp(lp.conf$psi), exp.IN)
dimnames(result) <- list(NULL,c("log.p","Std.log.p","lower.IN","upper.IN","p","lower.exp.IN","upper.exp.IN"))
cat("Confidence intervals:","\n")
print(signif(result,digits=3))

p <- miners.nl1$response/miners$n
freq <- miners.d[,2:4]/apply(miners.d[,2:4],1,sum)
title <- c("normal", "mild", "severe")
time <- miners.d[,1]



par(mfrow=c(1,3))
for (l in 1:3) {
  plot(range(time),
       range(c(freq[,l],p[(l-1)*8+(1:8)],exp.IN[(l-1)*8+(1:8),])),
       type="n", xlab="", ylab="")
  points(time, freq[,l], pch=rep(14+l,8))
  lines( time,  p[(l-1)*8+(1:8)], lty=l)
  title(main=title[l])
  segments(time, exp.IN[(l-1)*8+(1:8),1],
           time, exp.IN[(l-1)*8+(1:8),2])
}

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
