# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("nasturnium")


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 5.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Nasturtium assay example ") 
cat("\n ---------------------------")

cat("\n Plot of the observed weights versus the log-concentration \n\n") 


if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="nasturnium.ps"); (ask.pause <- F)  }

log.nas<-c(rep(-5,6),log(nasturnium$x[7:42]))
plot(log.nas,nasturnium$y,
      xlab="log-concentration",ylab="response",
      main="Nasturtium example",sub="Observed response")

cat("\n Parameters estimation \n\n") 
lesystem(paste(.Nls2dir, "/analDer ", nas.mod, " > nas.mod.c", sep=""))
lesystem(paste(.Nls2dir, "/crInv ", nas.finv, " > nas.finv.c", sep=""))
lesystem(paste(.Nls2dir, "/crPsi ", nas.psi, " > nas.psi.c", sep=""))

nomlib <- loadnls2("nas.mod.c",
         inv="nas.finv.c",
         psi="nas.psi.c")

nas.nl<-nls2(nasturnium,nas.mod,c(900,-.5,1), renls2=T)
plot(log.nas,nasturnium$y,
     xlab="log-concentration",ylab="response",
     main="Nasturnium example",
     sub="Observed and adjusted response")
lines(unique(log.nas), nas.nl$response)

# ---------------------------------------------------------
cat("\n Likelihood-ratio-type calibration interval for $x <- {0}$") 
cat("\n with asymptotic level 95% \n\n") 

nas.calib<-calib(nas.nl, file = nas.finv,
     ord=c(309, 296, 419))
   # Print the results
cat("Estimated value of x0:",  nas.calib$x,"\n" )
cat("Jr:", nas.calib$R.conf.int,"\n" )
cat("Jn:", nas.calib$S.conf.int,"\n" )

  # Plot the results:
#plot.calibnls2(nas.calib, ask.pause=ask.pause)

# ---------------------------------------------------------
cat("\n Bootstrap calibration interval for $x <- {0}$ \n\n") 

nas.boot<-bootstrap(nas.nl,method="calib",
                           file=nas.psi,
                  n.loops=50,
                  ord=c(309, 296, 419),
                  pbispsi=nas.calib$x)
b0.025<-nas.boot$conf.bounds[1]
b0.975<-nas.boot$conf.bounds[2]
boot.calib<-calib(nas.nl,
                  file=nas.finv,
                  ord=c(309, 296, 419),
         conf.bounds=c(as.numeric(b0.025),as.numeric(b0.975)))
cat("Estimated value of x0:", boot.calib$x,"\n" )
cat("b <- 0.025, b <- 0.975:",nas.boot$conf.bounds ,"\n" )
cat("Estimated value of Jb:",boot.calib$S.conf.int,"\n" )

# --------------------------------------------------------------

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
