# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("ovo")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 1.6")
cat("\n#------------------------------------------------------")

cat(" ---------------------------\n")
cat(" Ovocytes example \n") 
cat(" ---------------------------\n\n")

lesystem(paste(.Nls2dir, "/analDer ", ovo.mod1, " > ovo.mod1.c", sep=""))
nomlib <- loadnls2("ovo.mod1.c")
cat(" Parameters estimation \n\n") 

ovo.int<-   # The list that describes the integration context
   list(start=0, nb.theta.odes=3,
   cond.start=matrix(c(1.35660e-6, 0, 1.49226e-06, 0), ncol=2))
ovo.nl1<-nls2(ovo, list(file=ovo.mod1,
     gamf=c(76.09, 1.04, 1.62, 18,1,1.596e-6,6.604e-4,0.29,0.29,1),
     eq.theta=c(NaN, NaN,  0.15,  NaN, NaN,  0.065)),
               c(0.1, 0.01,  0.15, 0.1, 0.01, 0.065),
               integ.ctx=ovo.int)
cat( "Estimated values of the parameters:\n ")
cat( ovo.nl1$theta); cat( "\n\n")

cat(" Plot of the results \n\n") 
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="ovo.ps"); (ask.pause <- F)  }
plfit(ovo.nl1, title="Ovocytes example", ask.pause=ask.pause)


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 2.6")
cat("\n#------------------------------------------------------")

cat("\n Confidence ellipsoids and likelihood contours ") 
cat("\n for the parameters $(P <- {w}, P <- {s})$ \n\n") 
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("ovo.mod1.c", psi="")
ovo.ell1 <- ellips(ovo.nl1, axis=c("Pw_c1","Ps_c1"))
ovo.ell2 <- ellips(ovo.nl1, axis=c("Pw_c2","Ps_c2"))
ovo.iso1 <- iso(ovo.nl1, axis=c("Pw_c1","Ps_c1"))
ovo.iso2 <- iso(ovo.nl1, axis=c("Pw_c2","Ps_c2"))

if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="inference.ovo.ps"); (ask.pause <- F)  }

par(mfrow=c(1,2))
plot(x=c(.06,.13),y=c(0.0008,.0017),type="n",xlab="Pw",ylab="Ps")
if (is.R()) {
 contour(ovo.ell1,levels=qchisq(0.95,2),add=T,drawlabels=F)
 contour(ovo.ell2,levels=qchisq(0.95,2),add=T,drawlabels=F)
	} else {
 contour(ovo.ell1,levels=qchisq(0.95,2),add=T,labex=0)
 contour(ovo.ell2,levels=qchisq(0.95,2),add=T,labex=0)
}

text(0.1,0.0015,"mature ovocytes") 
text(0.08,0.001,"immature ovocytes")
title("Confidence ellipses")
plot(x=c(.06,.13),y=c(0.0008,.0017),type="n",xlab="Pw",ylab="Ps")
if (is.R()) {
	 contour(ovo.iso1,levels=qchisq(0.95,2),add=T,drawlabels=F)
	 contour(ovo.iso2,levels=qchisq(0.95,2),add=T,drawlabels=F)
	} else {
	 contour(ovo.iso1,levels=qchisq(0.95,2),add=T,labex=0)
	 contour(ovo.iso2,levels=qchisq(0.95,2),add=T,labex=0)
	}
text(0.095,0.0015,"mature ovocytes") 
text(0.08,0.001,"immature ovocytes")
title("Likelihood contours")


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")
cat("\n ---------------------------")
cat("\n Ovocytes example:") 
cat("\n graphic and misspecification tests using replications ") 
cat("\n ---------------------------\n")

cat("\n Plotting the residuals and the variances ") 
cat("\n\n") 


if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="plres.ovo.ps"); (ask.pause <- F)  }


plres(ovo.nl1, wanted=list(F.R=T), absolute=T, ask.pause=ask.pause,
     title="Ovocytes example")

 # Plot the variances
plvar(ovo.nl1,wanted=list(Y.S2=T),smooth=T,ask.pause=ask.pause,
     title="Ovocytes example")

cat("\n Test ") 
cat("\n\n") 

n <- sum(ovo.nl1$replications) # total number of replications
k <- length(ovo.nl1$replications) # number of observations
Sl <- n*log(ovo.nl1$sigma2) - 
      sum(ovo.nl1$replications*log(ovo.nl1$data.stat$S2))
cat( "Sl:", Sl,
"\nX2(0.95,53):",qchisq(0.95, 2*k - 5),"\n\n"  )


if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
