# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("pg")

# ---------------------------------------------------------------
# Example PG:
# example with curves and numerical equality constraints.
#  Variance modelised.
# Function called:
# "nls2" , plotting and extracting functions
# ---------------------------------------------------------------

# Context creation:
  theta0 <- c(0.2048066, 60.97191, 1, 0.6859843, 49.76278, 0.2511902, 0.2370021,
 49.50538, 1,0.2052278, 43.92261, 1)
 pg.stat.ctx <- list(theta.start=theta0, beta.start=rep(0,4), max.iters=100)

# Control creation:
  pg.control <-list(freq=1,it.steps=1, it.estim=T,
                  fitted=F,estim=F,num.res=F)

# Model creation:
  pg.model <- list(file=pg.mod,
                eq.theta=c(NaN,NaN,1,
                          NaN,NaN,NaN,
                          NaN,NaN,1,
                          NaN,NaN,1))

# ---------------------------------------------------------------
lesystem(paste(.Nls2dir, "/analDer ", pg.mod, " > pg.mod.c", sep=""))
nomlib <- loadnls2("pg.mod.c")
# ---------------------------------------------------------------

# ---------------------------------------------------------------
# nls2
# ---------------------------------------------------------------
	
  pg.nl  <- nls2(pg, pg.model, pg.stat.ctx, control = pg.control)
  print(pg.nl)

# ---------------------------------------------------------------
# calls to the plotting functions
# ---------------------------------------------------------------
# PLDNLS2:
# --------
cat("\n Plots asked by the function pldnls2\n")
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="pg.ps"); (ask.pause <- F)  }
# if(device =="latex")
#  latex(width=450, height=500, file="fig.pldnls2.tex")
m <- matrix(c(0,0.8, 0.3,1), nrow=1)
pldnls2(pg,"y","x", title="pg:pldnls2", figs=m, ask.pause=ask.pause )

# PLRES: 
# -----
cat("\n Plots asked by the function plres\n")
plres.nls2(pg.nl,absolute=T,st=T, ask.pause=ask.pause)

# PLIT:
# ----
cat("\n Plots asked by the function plit\n")
plit(pg.nl, wanted=list(num.res=F, estim=T), ask.pause=ask.pause)

# PLFIT:
# -----
cat("\n Plots asked by the function plfit\n")
# if(device =="latex")
#  latex(width=450, height=500, file="fig.plfit.tex")
plfit(pg.nl, ask.pause=ask.pause)

# ----------------------------------------------------
# extracting functions
# ---------------------------------------------------

  # execution of the extracting functions:
  cat("\n--------- Function coef on example pg --------- \n")
  coef.out <- coef(pg.nl)
  print(coef.out)
#  cat("\n--------- Function fitted on example pg --------- \n")
#  fitted.out <- fitted(pg.nl)
#  print(fitted.out)
  cat("\n--------- Function summary on example pg --------- \n")
  summary.out <- summary(pg.nl)
  print(summary.out)
#  cat("\n--------- Function resid on example pg --------- \n")
#  resid.out <- resid(pg.nl)
#  print(resid.out)



if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
