# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("volterra")


# ---------------------------------------------------------------
# Example VOLTERRA:
# example of a model described by a differential equations system.
# Functions called:
# "nls2", "calcmodnls2"
# ---------------------------------------------------------------

# Context creation:
# it is described only by the component
# which is always required, i.e the
# initial values of the Theta
  volterra.stat.ctx<-c(40.0, 30.0,  1.0,  0.1,  1.0,  2.5)

# Creation of the integration context:
# it is described only by the component
# which is always required, i.e the
# the initial times.
  volterra.integ.ctx<-list(start=0, nb.theta.odes=4)
	
# ---------------------------------------------------------------------
lesystem(paste(.Nls2dir, "/analDer ", volterra.mod, " > volterra.mod.c", sep=""))
nomlib <- loadnls2("volterra.mod.c")
# ---------------------------------------------------------------------

# ---------------------------------------------------------------------
# calcmodnls2
# ---------------------------------------------------------------------

  # Direct calculation of the model for the initial values:

#  Example of evaluation of phi:
# -----------------------------
# call to nls2 to calculate FOdes and d.FOdes for the initial values:
# remark: model is reduced to the name of the description file
# and stat.ctx to the initial values of theta
   no  <- nls2(volterra,volterra.mod,
          list(theta.start=volterra.stat.ctx,max.iters=0),
          integ.ctx=volterra.integ.ctx, control=list(freq=0))

  volterra.phi  <- calcmodnls2(volterra, volterra.mod,
                   theta=volterra.stat.ctx, integ.ctx=volterra.integ.ctx,
                   FOdes=no$FOdes, d.FOdes=no$d.FOdes,
                   func="phi")
# volterra.phi$response should be equal to no$response:
  if (all(volterra.phi$response==no$response))
    cat("Correct calculation of response\n")  else
    cat("Incorrect calculation of response\n")
# volterra.phi$d.resp should be equal to no$d.resp:
  if (all(volterra.phi$d.resp==no$d.resp))
    cat("Correct calculation of d.resp\n")  else
    cat("Incorrect calculation of d.resp\n")


#  Example of evaluation of the odes:
# -----------------------------
  volterra.odes  <- calcmodnls2(volterra,volterra.mod, 
     theta=volterra.stat.ctx, integ.ctx=volterra.integ.ctx,func="odes")
# volterra.odes$response should be equal to no$response:
  if (all(volterra.odes$response==no$response))
    cat("Correct calculation of response\n")  else
    cat("Incorrect calculation of response\n")
# volterra.odes$d.resp should be equal to no$d.resp:
  if (all(volterra.odes$d.resp==no$d.resp))
    cat("Correct calculation of d.resp\n")  else
    cat("Incorrect calculation of d.resp\n")
  if (all(volterra.odes$FOdes==no$FOdes))
    cat("Correct calculation of FOdes\n")  else
    cat("Incorrect calculation of FOdes\n")
  if (all(volterra.odes$d.FOdes==no$d.FOdes))
    cat("Correct calculation of d.FOdes\n")  else
    cat("Incorrect calculation of d.FOdes\n")


	
# ---------------------------------------------------------------------
# nls2
# ---------------------------------------------------------------------

  volterra.nls2  <- nls2(volterra,volterra.mod,volterra.stat.ctx, 
           integ.ctx=volterra.integ.ctx, control=list(freq=0))
  print(volterra.nls2)
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
