#ifndef TYPESH
#define TYPESH

/*-------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : nltypes.sh/ES0/e1/i45     |
| Date                 : 16Oct91 / 15:45:44        |
| Concepteur           : A. Bouvier                |
| Role                 : definition des types      |
| Reference conception : Normes de programmation   |
|                          (Annexe)                |
| Lecteur              :                           |
--------------------------------------------------*/

/* pour finite */
#include <ieee754.h>

/*--------------- INCLUDES ----------------------- */
#include <stdio.h>
#include "nlchoix.h"
/* on met nlchoix.h car on a besoin de MAXETAP */

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */
/* ........ DEFINITIONS DE TYPES DE BASE................................... */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */

/* ............ TYPES SCALAIRES ..........................................  */
/* ......... caractere  ..................................................  */
typedef char TChar;

/* ........ les entiers de type TLogic devront etre compris entre 0 et 1 : . */
typedef /* signed */ short int TLogic ;

/* ........ TBin : entier sur 32 bits avec des 0 ou des 1 .................. */
typedef unsigned long int TBin ;

/* ........ TShortInt: entier sur 16 bits .................................  */
typedef /* signed */ short int TShortInt ;

/* ........ TLongInt: entier sur 32 bits ................................... */
typedef /* signed */ long int TLongInt ;

/* ........ TFuncInt: entier  pour l'interface avec S ou R ................ */
typedef int TFuncInt ;

/* ........ TFloat   : reel simple precision ............................... */
typedef float TFloat ;

/* ........ TDouble  : reel double precision ............................... */
typedef double TDouble ;

/* ........ TChaine  : chaine de caracteres ............................... */
typedef TChar *TChaine ;


/* .........TYPES STRUCTURE ............................................... */
/* mettre un nom de structure apres le mot "struct", 
   pour que certains compilateurs
   ne signalent pas d'anomalie */

/* ........ TMat:  matrice double precision ............................... */
typedef struct SMat
  {
  TShortInt nbcol ; /* nombre de colonnes */ 
  TShortInt nblig ; /*  nombre de lignes  */
  TDouble **donnees; /* les valeurs en DP  */
  } TMat;



/* ........ TMatShort:  matrice entiere court.................................... */
typedef struct SMatShort
  {
  TShortInt nbcol ; /* nombre de colonnes */ 
  TShortInt nblig ; /*  nombre de lignes  */
  TShortInt **donnees; /* les valeurs en entier court */
  } TMatShort;

/* ........ TVect:  vecteur double precision ............................... */
typedef struct SVect 
  {
  TShortInt nbele ; /* nombre d'elements */
  TDouble *donnees; /* les valeurs en DP  */
  } TVect;


/* ........ TVectShort: vecteur entier court................................ */
typedef struct SVectShort
  {
  TShortInt nbele ; /* nombre d'elements */
  TShortInt *donnees; /* les valeurs en entier court */
  } TVectShort;

/* ........ TVectLong: vecteur entier long................................ */
typedef struct SVectLong
  {
  TShortInt nbele ; /* nombre d'elements */
  TLongInt *donnees; /* les valeurs en entier long  */
  } TVectLong;

/* ........ TVectStr: vecteur caractere .................................... */
typedef struct SVectStr
  {
  TShortInt nbele ; /* nombre d'elements */
  TChar **donnees; /* les valeurs en char  */

  } TVectStr;



/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */
/* ........ DEFINITIONS DES TYPES SPECIFIQUES A NL......................... */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */

/* .............. TCOO: sous-type du contexte d'integration ............... */
typedef struct TCOO 
  {
  int ligne;
  int col;
  struct TCOO *suivant;
  } Tcoo;

/* ------------------------------------------------------------------------- */
/* ........ TCtxInteg: contexte d'integration............................... */
/*  Une structure globale                                                    */
/* ------------------------------------------------------------------------- */

typedef struct SCtxInteg
  {
  TVect atol; /*  controle de la tolerance en absolu 
              (voir la  notice d'appel a LSODA d'ODEPACK 
               vecteur de longueur 1 ou  neq[1], double pr\'ecision
               valeur >0,defaut : DEFATOL */
  TLogic ImpInteg; /* indique si on a des impressions intermediaires */
  TLogic IndicCi; /* indique si les conditions initiales sont des parametres */
  TVectShort IndicTj; /* indique si Tj est un sous-ensemble de XObs
                       longueur 1 ou J */
  TLogic IndicX; /* indique si XObs intervient dans les equations du SEDO */
  int iopt; /* precise si il y a des options demandees  dans 
                rwork et iwork (voir notice ODEPACK)
                valeur : NON (pas d'option) OUI (options) */
  int itol; /* indicateur pour le type de controle de la tolerance
                   voir la  notice d'appel a LSODA d'ODEPACK */
  TVectLong iwork; /* vecteur de travail utilise pour les entree et sortie d'options
                   (voir notice ODEPACK)
                    longueur liw */
  TShortInt NbJ; /*  le  nombre de valeurs temps pour lesquelles  on integre */
  int jt; /* precise la methode pour le calcul du jacobien.
                  (voir notice ODEPACK) */
  int liw; /* taille de iwork
                 (voir notice ODEPACK)*/
  int lrw; /* taille de rwork
                  (voir notice ODEPACK)*/
  TShortInt NbEq; /* nombre d'equations du SEDO decrit dans le fichier formel
                    = nombre de parametres theta qui sont conditions initiales                   quand IndicCi est VRAI */
  TShortInt NbThetaSedo; /* Nombre de parametres intervenant dans le SEDO */
  TVect rtol; /* controle de la tolerance en relatif 
              (voir notice ODEPACK)
              longueur 1 ou  neq[1]
              valeur: >= 0 et <1 */
  TVect rwork; /* vecteur de travail, utilise pour les entree et sortie d'options
               (voir notice ODEPACK), dimension : lrw */
  TShortInt LongSys; /* longueur du systeme complet */
  TShortInt T0Egal;
  TVect T0T; /* pour lire T0 */
  TVect *T0; /* temps initial
            dimension: 1 ou NbObs */
  TMat *Tj; /* temps pour lesquels on veut les valeurs des integrations.
            NbCourbe matrices de dimension : [1],[J] ou [NbObs][J] */
  TVect *TjBis; /* vecteurs contenant les temps ordonnes
              dimension :  [JBis] */
  TVect T0Bis; /* minimum des T0 quand on integre sur TjBis pour chaque courbe */

  Tcoo  **TjDes; /* structure  contenant les coordonnees.
		   dimension :  [NbObs][J]  */
  TVectShort *TjBisNb; /* nb pour chaque valeur */
  TVect *VectCi; /* contient les conditions initiales pour chaque courbes 
		    quand elles sont connues dimension : NbEq */
  int proiwork[9]; /* tableau de lecture des options de LSODA */
  double prorwork[7]; /* tableau de lecture des options de LSODA */
  } TCtxInteg;

/* ------------------------------------------------------------------------- */
/* ........ TCtxNum: contexte numerique .................................... */
/*  Autant de structures que d'etapes                                        */
/* ------------------------------------------------------------------------- */
typedef struct SCtxNum
  {
  TLogic    Effic;   /* efficacite de l'estimateur: OUI si efficace */
  TShortInt Estim ; /* estimateur choisi */
  TShortInt NbZ ;   /* dimension des stat exhaustives */
  TShortInt (*PCDirec)(); /*  pointeur sur la fonction de calcul 
                               de la direction de descente */
  struct
    {
    TShortInt (*PCValB)(); /*  pointeur sur la fonction de calcul de B
                              le retour etant le code d'erreur */
    TShortInt (*PCValD)(); /*  pointeur sur la fonction de calcul de D */
    TShortInt (*PCValEta)(); /*  pointeur sur la fonction de calcul de Eta */
    } PCEquN ;    /* noms des programmes de calcul des equ normales  */
  TShortInt (*PCValZ)(); /*  pointeur sur la fonction de calcul de Z */
  TShortInt (*PCVarZ)(); /*  pointeur sur la fonction de calcul de VarZ
                              le retour etant le code d'erreur */
  TShortInt Symm ;  /* forme de la mat a inverser */
  TShortInt TypeCritStat ; /* type du critere de minimisation */
  } TCtxNum;

/* ------------------------------------------------------------------------- */
/* ........ TCtxPuss: contexte pour le processus d'estimation .............. */
/* ------------------------------------------------------------------------- */
typedef struct SCtxPuss
  {
  TShortInt Algo ;        /* l'algorithme */
  TVect     Beta0 ;       /* valeurs initiales  de Beta - dim: NbCourbe*NbBeta */
  TDouble   DirecC;       /* valeur de correction de la direction (defaut 0.5) */
  TDouble   Lambda0 ;     /* valeur du parametre de Gauss-Marquardt */
  TDouble   LambdaC1;     /* valeur de correction de Lambda0  a chaque iteration*/
  TDouble   LambdaC2;     /* valeur de correction de Lambda0  
                                quand recherche du pas optimal */
  TDouble   MaxCritArret ;     /* borne du critere d'arret */
  TLongInt  MaxDeb ;     /* nbre max de fois ou on peut successivement repartir du debut d'un intervalle */
  TLongInt  MaxErr ;      /* nbre de reprises en cas d'erreur dans le calcul du modele */
  TLongInt  MaxIter ;     /* nbre max d'iter: 0 si on ne veut pas d'estimation */
  TDouble   MaxLambda;    /* borne de Lambda */
  TVect     Mu3 ;         /* valeurs des moments d'ordre 3 si connus, dim: NbObs,
                             vecteur a 0 elements sinon */
  TVect     Mu4 ;         /* valeurs des moments d'ordre 4 si connus
                             dim: NbObs, vecteur a 0 elements sinon */
  TShortInt NbEtapes ;    /* nbre d'etapes */
  TDouble OmegaPas;       /* correction du pas */
  TDouble   Sigma ;       /* valeur de sigma: 
                           une entree si connu, 1 sinon */
  TVect     Theta0 ;      /* valeurs initiales  de Theta - dim: NbCourbe*NbTheta */
  TShortInt Famille ;      /* la famille, gaussien, poisson, etc.. du ctx */
  TShortInt TypeMu ;      /* comment on calcule les moments */
  TShortInt TypeSigma ;   /* comment on calcule sigma */
  } TCtxPuss;

/* ------------------------------------------------------------------------- */
/* ........ TCtrole: le controle ........................................... */
/* ------------------------------------------------------------------------- */
typedef struct SCtrole
  {
/* AVerif indique les verifications a faire:
   Vrai si la structure correspondant a l'element est 
   a verifier et initialiser */
  struct
    {
    TLogic    VCrole ;
    TLogic    VCtxInteg ;
    TLogic    VCtxNum ; 
    TLogic    VCtxPuss ;
    TLogic    VDon ; 
    TLogic    VMod ;    
    } AVerif; 
  TLogic EtapeIt[MAXETAP]; /* VRAI si on veut garder les resultats
                        de chaque iteration imprimee pour l'etape*/
  TLogic    FinTrait ;  /* vrai s'il faut arreter par exit en cas d'erreur */
  TLongInt FreqIp ;    /* frequence des impressions : 
                       <0 si initiale et finale,
                       =0 si pas d'impression,
                       >0 initiale et finale et toutes les FreqIp iterations */
  TShortInt LgTrace ; /* nombre de noms dans la trace */
  TShortInt NbWAnaly ;  /* nbre max de warnings pour l'analyseur-derivateur */
  TShortInt NbWInteg ;  /* nbre max de warnings pour l'integrateur */
  TShortInt NbWMethe ;  /* nbre max de warnings de type methodologique */
  TShortInt NbWNumer ;  /* nbre max de warnings de type numerique */
  TShortInt NbWTotal ;  /* nbre max de warnings tous types */
  TShortInt CWarAna ;  /* nbre de warnings pour l'analyseur-derivateur */
  TShortInt CWarInt ;  /* nbre de warnings pour l'integrateur */
  TShortInt CWarMet ;  /* nbre de warnings de type methodologique */
  TShortInt CWarNum ;  /* nbre de warnings de type numerique */
  TShortInt CWarTot ;  /* nbre de warnings tous types */
  FILE      *SortImp ;   /* unites d'impression */
  FILE      *SortTrace ; /* unites d'impression de la trace */
  FILE      *SortWE ;    /* unites d'impression des warnings et erreurs */
    FILE      *SortSv ;    /* unite de sauvegarde des resultats */
  TLogic    TypeLgMess ; /* type de la longueur des messages, COURT ou LONG */
  struct
    {
    TLogic Ajustes ;         
    TLogic AsVar ;           /* variance asymptotique */
    TLogic BVarZBP ;         /* matrice (B*VarZ*B)/NbObsT (\Sigma) */
    TLogic Corr  ;           /* Correlation des parametres */
      TLogic Data ;            /* les data.stat et NbRepet */
    TLogic EquN ;     
    TLogic Estim  ;
    TLogic FctSensib ;       
    TLogic Mu    ;           /* les moments */
    TLogic Residus ;         /* residus */
    TLogic ResNum ;   
    TLogic Sedo;
    TLogic ValW ;            /* Matrice W */
    TLogic Z ;  
    }       Voulu ;       /* resultats desires */
  struct
    {
    TLogic Ajustes ;         
    TLogic EquN ;     
    TLogic Estim  ;
    TLogic FctSensib ;       
    TLogic NbIter ;   
    TLogic ResNum ;   
    TLogic Sedo;
    }       VouluIp ;   /* impressions intermediaires desirees */
  struct
    {
    TLogic Ajustes ;         
    TLogic EquN ;     
    TLogic Estim  ;
    TLogic FctSensib ;       
    TLogic NbIter ;
    TLogic ResNum ;   
    TLogic Sedo;
    }       VouluIt ;   /* sauvegardes des resultats par iteration desirees */


  } TCtrole;


/* ------------------------------------------------------------------------- */
/* ........ TStatDon: les statistiques sur les donnees  .................... */
/* ------------------------------------------------------------------------- */
typedef struct SStatDon
  {
  TVect     Y1    ; /* moyenne - dimension NbObs - */
  TVect     Y2    ; /* moyenne au carre - dimension NbObs - */
  TVect     S2    ; /* somme des carres - dimension NbObs - */
  } TStatDon;

/* ------------------------------------------------------------------------- */
/* ........ TDonnees : les donnees ......................................... */
/* ------------------------------------------------------------------------- */
typedef struct SDonnees
  {
  TShortInt  NbCourbe ; /* nombre de courbes */
  TLongInt   NbObs ;     /* nombre d'observations */
  TVectLong  NbObsC ;    /* nombre d'observations de chaque courbe - dim: NbCourbe */
  TLongInt   NbObsT ;    /* nombre de valeurs de la reponse de poids non nul */
  TVectLong  NbRepet ;   /* nombre de repetitions - dim: NbObs */
  TShortInt  NbX ;       /* nombre de variables explicatives */
  TVectStr   NomC ;      /* nom de la courbe de chaque observation - dim: NbObs */
  TVectStr   NomCT ;     /* nom de la courbe de chaque observation 
                           - dim: NbObsT+nbre de poids nuls                     */
  TShortInt IndiceN;     /* indice de NomN,  partir de 1, 
                          parmi les va. explicatives NomX
                         si la famille est binomiale, poisson ou multinomiale */

  TVectStr   NomObs ;    /* nom de chaque observation - dim: NbObs */
  TVectStr   NomObsT ;   /* nom de chaque repetition - 
                         dim: NbObsT + nombre de poids nuls  */
  TVectStr   NomX ;      /* noms des variables explicatives */
  TChaine    NomY ;      /* nom de la reponse */
  TVect      Poids ;     /* poids - dim: NbObs ou 0 si pas de poids */
  TVect      PoidsT ;    /* poids - dim: NbObsT+nbre de poids nuls  ou 0
                          si pas de poids */
  TStatDon   StatDon;    /* les statistiques sur les donnees */
  TVect      ValY ;      /* valeurs de la reponse - dim: NbObsT+nbre de poids nuls */
  TMat       XObs ;      /* valeurs des va explicatives - dim: NbObs,NbX */
  TMat       XObsT ;     /* valeurs des va explicatives 
                            - dim: (NbObsT+nbre de poids nuls),NbX */
} TDonnees;


/* ------------------------------------------------------------------------- 
 ........ TContr:  les contraintes sur les parametres du modele .......... 
 Les structures de ce type sont:
    pour les contraintes  sur les parametres du modele:
          celles fournies par l'utilisateur dans Modele:
               CTheta0, CBeta0,
          celles retournees en sortie:
          CTheta, CBeta: tableaux de NbEtapes structures de ce type
   pour les contraintes en dimension differents,  celles de travail
          CThetaE, CBetaE: tableaux de NbEtapes structures de ce type
          dont on utilise que BINf, BSup et EgalN          
 ------------------------------------------------------------------------- */
typedef struct SContr
  {
  TVect    BInf    ; /* valeurs de l'inegalite borne inf */
  TVect    BSup    ; /* valeurs de l'inegalite borne sup */
  TVect    EgalN   ; /* valeurs de l'egalite numerique */
  TVectShort  EgalP ; /* indices des parametres egaux,
                        indices demarrant a 1 */
   /* dimension de ces vecteurs: NbCourbe*nombre de parametres du modele */
  TLogic Ctr ; /* VRAI s'il y a des contraintes */
  } TContr;


/* ------------------------------------------------------------------------- */
/* ........ TModele: le modele statistique ................................. */
/* ------------------------------------------------------------------------- */
typedef struct SModele
  {
  TLogic    CasSedo ; /* Vrai si cas sedo */
  TContr    CBeta0, CTheta0 ; /* contraintes fixees par l'utilisateur
                                 dimension des vecteurs NbBeta*NbCourbe
                                                et      NbTheta*NbCourbe */
  TVect    GamF, GamV ;  /* valeurs des parametres de 2ieme niveau */
  TVectStr  NomTheta, NomBeta, NomGamF, NomGamV ; /* noms des parametres */
  TChaine  NomFichier; /* nom du fichier contenant les arbres de calcul
                           du modele */
  TChaine NomV; /* nom de la fonction v */
  TShortInt Vari ;   /* indications sur la variance */
  TLogic YaCalcV;    /* indique si il y a un programme de calcul de v */
  } TModele;

/* ------------------------------------------------------------------------- */
/* ........ TParam: les parametres ......................................... */
/* Il y a 2*NbEtapes structures de ce type: 
      Theta et Beta: tableaux de NbEtapes structures de ce type
  Dans ces structures, Estim est une sortie, le reste sert pour le travail   */
/* ------------------------------------------------------------------------- */
typedef struct SParam
  {
  TVectStr  Noms ;    /* noms -  pointeur sur Modele.NomTheta ou 
                                  Modele.NomBeta 
                          dimension: nombre de parametres du modele */
  TVect     Init ;     /* valeurs initiales 
                           - pointeur sur CtxPuss.Theta0 (ou Beta0)
                           a l'etape 1 et sur Estim de l'element precedent
                            sinon 
                 dimension: NbCourbe*  nombre de parametres du modele */
  TVect      Eff ;      /* parametres differents - dim: NbThetaE ou NbBetaE */
  TVect      Act ;      /* parametres actifs - dim: NbThetaA ou NbBetaA */
  TVect      Estim ;    /* parametres estimes -
                 dimension: NbCourbe*  nombre de parametres du modele */
  TMatShort  Pass  ;     /* matrice de passage de la dim 
                            NbCourbe*(NbTheta ou NbBeta)
                            a la dim NbBThetaE  ou  NbBetaE 
                            dimension :(NbCourbe*NbTheta, NbThetaE )
                             ou        (NbCourbe*NbBeta, NbBetaE) */
  } TParam;


/* ------------------------------------------------------------------------- 
 sous-structure de ResNum                                                  
 TInfoModErr: structure pour contenir ce qu'il faut sortir en cas d'erreur
             dans le calcul du modele                                        
   En cas d'erreur, on sort ceci  , en plus des derniers resultats ou le
   calcul a ete possible
 ------------------------------------------------------------------------- */
typedef struct SInfoModErr
  {
  TShortInt CodeErr; /* Code de l'erreur */
  TShortInt LieuErr; /* precise si erreur dans le calcul de f,v, df,dv */
  TVect XErr ; /* ligne de la matrice des observations ou s'est produite
                  l'erreur- dimension XObs.nbcol */
  TChaine NomXErr ; /* nom de l'observation ou s'est produite
                  l'erreur */
  } TInfoModErr;

/* ------------------------------------------------------------------------- */
/* ......... TResNum: les resultats de type numerique ...................... */
/*              Autant de structures que d'etapes                            
                tableau ResNum de NbEtapes structures de ce type             */
/* ------------------------------------------------------------------------- */
typedef struct SResNum
  {
  TShortInt CodePuss; /* code indiqunat la facon dont PussIter s'est termine */
  TDouble   CritArret; /* critere d'arret */
  TDouble   CritStat ;   
  /* CritStat contient l'une des informations suivantes, selon les cas: 
     -2 Log(Vrais) ,Norme des equN, SCR, SCR2: c'est TypeCritStat qui l'indique
  */
  TInfoModErr InfoModErr; /* info en cas d'erreur */
  TDouble   Lambda;  /* valeur de Lambda en fin d'etape */
  TDouble   Log; /* -2log(vrais)/n */   
  TDouble   LogFamille; /* log(vrais) */ 
  TDouble   Deviance;
  TLongInt  NbIter ;/* nombre d'iterations effectuees */
  TDouble   Norme;  /* norme des equations normales */
  TDouble   Scr ; /* somme des carres residuelle */
  TDouble   ScrNP ; /* somme des carres residuelle non ponderee */
  TDouble   Sigma ;       /* valeur de sigma */
    TVect ResidusDev ;
  } TResNum;

/* ------------------------------------------------------------------------- */
/*  TAjustes: les ajustes                                                    */
/* ------------------------------------------------------------------------- */

typedef  struct SAjustes
    {
    TVect Valf ;    /*  dim NbObs */
    TVect VarY ; /* =v eventuellement multiplie par Sigma et pondere 
                    par les poids       - dim NbObs ,
                    vecteur de 1 si YaCalcV FAUX */
    } TAjustes;


/* ------------------------------------------------------------------------- */
/*  TFctSensib: les derivees  de f et v par rapport aux parametres du modele */
/* ------------------------------------------------------------------------- */
typedef  struct  SFctSensib
    {
    TMat DValf ;      /* derivees de Valf par rapport a theta
              NbObs, NbTheta */
    TMat DVarYTheta ;   /* derivees de VarY par rapport a theta
              NbObs, NbTheta  existe meme si YaCalcV=FAUX (=0) */
    TMat DVarYBeta ;   /* derivees de VarY  par rapport a beta
              NbObs, NbBeta existe s'il y a des beta  */
    } TFctSensib;

/* ------------------------------------------------------------------------- */
/*  TEquN: les equations normales                                            */
/* ------------------------------------------------------------------------- */

typedef  struct SEquN
    {
    TMat  ValB ;   /* dim: (NbZ*NbObs), (nbre total de parametres actifs) */
    TVect ValEta ; /* dim: NbZ*NbObs */
    TMat  ValD ;   /* dim: (NbZ*NbObs), (nbre total de parametres actifs) */
    } TEquN;


/* ------------------------------------------------------------------------- */
/*  TSedo: les valeurs ajustees du Sedo                                       */
/* ------------------------------------------------------------------------- */

typedef  struct SSedo
    {
    TDouble ***FSedo ;    /*  dim: NbObs, NbJ, NbEq */
    TDouble ***DFSedo ;   /*  dim: NbObs, NbJ, 
                                   (NbEq*NbThetaSedo) ou NbEq *(NbThetaSedo+NbEq) */
    } TSedo;


/* ------------------------------------------------------------------------- */
/* ........ TResStat: resultats statistiques des etapes.................... */
/*              Autant de structures que d'etapes:
                tableau ResStat de NbEtapes structures de ce type           */
/* ------------------------------------------------------------------------- */
typedef struct SResStat
  {
  TAjustes      Ajustes; /* Valf, VarY */
  TMat          AsVar; /* dimension:  multot*multot */
  TMat          BVarZBP ; /* (B*VarZ*B)/NbObsT (\Sigma) 
                          dimension: nbre total de param actifs */
  TMat          Corr; /* correlation des parametres 
                        dimension: multot*multot =
			(NbTheta + NbBeta)*NbCourbe */
  TEquN         EquN; /* Equ Normales */
  TFctSensib    FctSensib; /* df, dVarYTheta, DVarYBeta */
  TVect         Mu3 ;         /* valeurs des moments d'ordre 3 dim: NbObs */
  TVect         Mu4 ;         /* valeurs des moments d'ordre 4 dim: NbObs */
  TVect         Residus ;     /* ATTENTION: ne pas faire apparaitre les
                                 residus correspond a des poids nuls 
                                 dim: NbObsT */
  TVect         ResidusR ;    /* residus reduits */
  TSedo         Sedo;  /* valeurs de FSedo et DFSedo */
  TMat          ValW ;   /* dimension: nbre total de param actifs, nbre total de param actifs */
  TVect         ValZ ;    /* dim NbObs*NbZ */
  } TResStat;


/* ------------------------------------------------------------------------- */
/* ......... TTrace : type de chaque element de la trace ................... */
/* ------------------------------------------------------------------------- */
typedef struct TTRACE 
  {
        TChar Nom[15];             /* valeur du composant de la trace */
        struct TTRACE *Suivant; /* pointeur sur l'element suivant */
  } TTrace ;

#endif
