# : ### FICHIER analFilenls2.s ###
analFilenls2 <-  function(ficmod)
{

# Decoder le fichier formel du model
# appele par nls2
# -----------------------------------------------------------
# initialisation des arguments de sortie du programme "nbListnls2":
NbTheta <- as.integer(0)
NbBeta <- as.integer(0)
NbGamF <- as.integer(0)
NbGamV <- as.integer(0)
NbX  <- as.integer(0)
NbJ <- as.integer(0)
NbEq <- as.integer(0)
NbDF <- as.integer(0)
YaCalcV  <- as.integer(0)
CasSedo  <- as.integer(0)
IndicCi  <- as.integer(0)
YaSubr <- as.integer(0)
Code <- as.integer(0)

Ret <- .C("nbListnls2", as.character(ficmod),
              NbTheta=as.integer(NbTheta),
              NbBeta=as.integer(NbBeta),
              NbGamF=as.integer(NbGamF),
              NbGamV=as.integer(NbGamV),
              NbX=as.integer(NbX),
              NbJ=as.integer(NbJ),
              NbEq=as.integer(NbEq),
              NbDF=as.integer(NbDF),
              YaCalcV=as.integer(YaCalcV),
              CasSedo=as.integer(CasSedo),
              IndicCi=as.integer(IndicCi),
              YaSubr=as.integer(YaSubr),
              Code=as.integer(Code))


if (Ret$Code !=0)
  stop("\nError in the program 'analFilenls2'\n")

# allocation des vecteurs des noms  en sortie de "nomlistenls2"
# initialisation des vecteurs des noms
# c'est necessaire pour le cas ou les noms ont plus
# d'1 caractere: on les initialise a la longueur maxi
# fixee pour les noms, en l'occurrence,
# on fixe cette limite a 15
NomTheta <- rep("              ", Ret$NbTheta)
NomBeta  <- rep("              ", Ret$NbBeta)
NomGamF <-  rep("              ", Ret$NbGamF)
NomGamV  <- rep("              ", Ret$NbGamV)
NomX     <- rep("              ", Ret$NbX)
NomValInt     <- rep("              ", Ret$NbJ)
NomLesF     <- rep("              ", Ret$NbEq)
NomLesDF     <- rep("              ", Ret$NbDF)
NomY     <-     "              ";


noms <- .C("nameListnls2", as.character(ficmod),
              NbTheta=as.integer(Ret$NbTheta),
              NbBeta=as.integer(Ret$NbBeta),
              NbGamF=as.integer(Ret$NbGamF),
              NbGamV=as.integer(Ret$NbGamV),
              NbX=as.integer(Ret$NbX),
              NbJ=as.integer(Ret$NbJ),
              NbEq=as.integer(Ret$NbEq),
              NbDF=as.integer(Ret$NbDF),
              NomTheta=as.character(NomTheta),
              NomBeta=as.character(NomBeta),
              NomGamF=as.character(NomGamF),
              NomGamV=as.character(NomGamV),
              NomX=as.character(NomX),
              NomY=as.character(NomY),
              NomValInt=as.character(NomValInt),
              NomLesF=as.character(NomLesF),
              NomLesDF=as.character(NomLesDF),
               Code=as.integer(Code))

if (noms$Code !=0)
  stop("\nError in the program 'analFilenls2' noms\n")

# Rajout de IndicX dans la liste retournee
Ret$IndicX <-0
if (Ret$CasSedo==1)
  {
  lvar <-  pmatch(noms$NomValInt, noms$NomX)
  if (!any(is.na(lvar)))
    Ret$IndicX <- 1
  }

# Rajout des noms dans la liste retournee:
Ret$NomTheta<-noms$NomTheta
Ret$NomBeta<-noms$NomBeta
Ret$NomGamF<-noms$NomGamF
Ret$NomGamV<-noms$NomGamV
Ret$NomX<-noms$NomX
Ret$NomY<-noms$NomY
Ret$NomValInt<-noms$NomValInt
Ret$NomLesF<-noms$NomLesF
Ret$NomLesDF<-noms$NomLesDF
return(Ret)

}
# ----------- FIN FONCTION analFilenls2 ---------------------------


# ----------------------------------------------------------------
# FUNCTION verifNamePnls2
# verifie le nom des parametres:
# Il faut que, si le vecteur param est labelle, ses noms soient
# inclus dans NomParam. Si param contient des elements en plus, on les enleve
# On verifie ensuite, et dans tous les cas, que sa longueur est NbNom
# NbNom peut etre nul: on verifie alors que param est NULL
# en sortie, param est labelle par NomParam
# Function appelee par calcpsinls2 et calcinvnls2
# ---------------------------------------------------------------
verifNamePnls2 <- function(param, NomParam, NbNom, libelle)
{
if (NbNom>0)
  {
  if (is.null(param))
    {	
    warning(paste("You must provide an argument", libelle,"\n"))
    return(NULL)
    }		
  if (!is.numeric(param))
    {	
    warning(paste("Argument", libelle, "not numeric\n"))
    return(NULL)
    }	

  namp <-  names(param)
  if (!is.null(namp) && (length(namp)!=0)) 
    {
    lvar <- pmatch(NomParam, namp)
    if (any(is.na(lvar)))
      {
      # namp non inclus dans les noms sur le fichier:erreur
      warning(paste("\n The names of the parameters are:\n",
        paste(namp,collapse=" "),
        "\n They must match the declaration of the description-file:\n",
         paste(NomParam,collapse=" "), "\n"))
      return(NULL)	
      }
    param <- as.vector(param[lvar])
    }
  nbparam <- length(param)
  
  if (nbparam != NbNom)
    {	
    warning(paste("\n The length of the", libelle,"argument:", nbparam,
       "\n is not equal to the number of the parameters in the description-file:", 
        NbNom,"\n"))
    return(NULL)
    }		
  names(param) <- NomParam

  } # fin de (NbNom>0)
else
  param <- NULL

return(list(Param=param))
}
# --------------------------end verifNamePnls2 -----------------------------------
