# : ### FICHIER bootstrap.nls2.s ###
bootstrap<- function(x, ...)
  UseMethod("bootstrap")

bootstrap.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

# ----------------------------------------------------------------
# CalcSStarnls2
# Calcul de S quand method=calib
# ----------------------------------------------------------------
CalcSStarnls2 <- function(n,m, produit,sigma2Star, ZmoyStar, fxoStar, resStar)
  {					
  # Calcul du denominateur D de S:
  # -----------------------------
  # produit=variance des psi
  # D= sqrt(SchapeauStar) * sqrt( 1/m + (produit/sigma2Star))
  # Les nombres dont on prend les sqrt sont  toujours >0
  # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Schapeau  <-  sum(resStar*resStar)	
  E <-   produit / sigma2Star
  D <-  sqrt(Schapeau) * sqrt( 1/m + E)
  
  # calcul du terme constant dans l'expression de S:
  # -----------------------------------------------
  A <-  sqrt(n + m)/D
  SStar <-  A * (ZmoyStar - fxoStar)	
  return(SStar)
  }
# ----------fin de CalcSStarnls2 -------------------------------------
	
	
# ----------------------------------------------------------------	
# AutVerifcnls2
# Quand method= calib, il faut les data disponibles, qu'une seule courbe
# et une seule va explicative et vari-type=constante
# ----------------------------------------------------------------
AutVerifcnls2 <- function(nls2.object)
{
# Rechercher les data:

  data <- plsplitoutnls2(nls2.object)
#S'il y a des courbes, erreur:
if (!is.null(data$curves)) 
  {
  stop("For method 'calib', the nls2.object must not include curves\n")
  }
if (length(nls2.object$X.names) !=1)
  stop("For method 'calib', there must be only one independent variable\n")
if (nls2.object$model$vari.type !="CST")
  stop("For method 'calib', the variance (nls2.object$model$vari.type) must be constant\n")
return(data)
}
# ------------------ fin de 	AutVerifcnls2 -----------------------
        
						
# ----------------------------------------------------------------
# exambootnls2: 
# Role: renvoyer les theta, beta et asvar actifs de la derniere etape
# ainsi que  response, variance, residuals, s.residuals, sigma2
# ------------------------------------------------------------------
exambootnls2 <- function(nls2.object)
{
residus  <-  s.residus  <-  NULL
theta <- coef.nls2(nls2.object)$theta
beta <- coef.nls2(nls2.object)$beta
sigma2 <- coef.nls2(nls2.object)$sigma2
as.var <- coef.nls2(nls2.object)$as.var
response <- fitted.nls2(nls2.object)$response
variance <- fitted.nls2(nls2.object)$variance
residus <- residuals.nls2(nls2.object)$residuals
s.residus <- residuals.nls2(nls2.object)$s.residuals

if (is.null(theta))
  stop("The nls2.object should contain the estimated values of the parameters")
if (is.null(sigma2))
  stop("The nls2.object should contain the estimated value of sigma2")
# On teste la response par rapport a numeric car si null
# considre response.name
if (!is.numeric(response))
  stop("The nls2.object should contain the fitted values ")

if (is.null(as.var) || all(is.na(as.var)))
  stop("The nls2.object does not include a valid as.var")
	
# DETERMINER LES PARAM ACTIFS:
# On ote LES PARAM EGAUX ENTRE EUX:
theta.m <- theta # car on veut sortir aussi les theta origines	
if(!is.null(nls2.object$model$eqp.theta))
  theta.m <-  theta[duplicated(nls2.object$model$eqp.theta) !=T]
if(!is.null(nls2.object$model$eqp.beta))
  beta <-  beta[duplicated(nls2.object$model$eqp.beta) !=T]
# On ote LES PARAM AVEC CONTRAINTES D'EGALITE NUM:
actifs <- dimnames(as.var)[[1]][!is.na(diag(as.var))]
namet <- match(actifs, names(theta.m),0)
theta.act <-  theta.m[namet]
if (!is.null(beta) && !all(is.na(beta)) )
  {
  nameb <- match(actifs, names(beta),0)
  beta.act <-  beta[nameb]
  }
else
  {
  beta.act <- NULL
  nameb <- NULL
  }
pact <- c(theta.act,beta.act)
namesp <- names(pact)
as.var <- as.var[namesp, namesp]

# Pas de variance signifie: variance=constante=1:
if (is.null(variance))
  variance <-rep(1, length(response))
return(list(theta=theta,
       pact=pact, as.var=as.var, response=response, sigma2=sigma2,
       variance=variance, residuals=residus, s.residuals=s.residus))

}
# ----- end  function exambootnls2 ---------------------------------

# ------------------------------------------------------------------
# deccodenls2:			
# DETERMINER LE 1IER CODE NON NUL
# ---------------------------------------------------------------------
deccodenls2 <- function(nls2.object)
{			
code <- 0
message <- "OK"	

for (compstep in c("step3", "step2", "step1"))
  {
    if (!is.null(nls2.object[[compstep]]))
        {
          if (nls2.object[[compstep]]$code == 0)
            {
              code  <-  nls2.object[[compstep]]$code
              message <- nls2.object[[compstep]]$message
              return(list(code=code, message=message))
            } # fin (nls2.object[[compstep]]$code == 0)
        } # fin (!is.null(nls2.object[[compstep]])
  } # fin for (compstep
code  <-  nls2.object$code
message <- nls2.object$message
return(list( code=code, message=message))
}
# ---------- end deccodenls2 ---------------------------------------------
	
# ------------------------------------------------------------------------
# generbootnls2:
# function that generates pseudo-observations according to
# the string argument 'method'
# Arguments:
#  method: a character string specifying the method required
#  n:      the total number of observations (replications included)
# m :	 quand calib, nbre de repet sup	
#  response, variance, residuals, s.residuals: the last fitted values 
#   of the response, variance, residuals, s.residuals of the 'nls2.object'
#   Vectors of length n
# Value:
#   the pseudo-observations (vectors of length n)
# ------------------------------------------------------------------------
generbootnls2 <- function(method,n, m, response,variance, residuals, s.residuals)
{
switch(method,
  param =
    {
    # generer k pseudo-erreurs dans le vecteur epsilon:
    epsilon <-  rnorm(n) * sqrt(variance)
    },
  residuals =
    {
    epsilon <- sample(residuals-mean(residuals))
    },
  s.residuals =
    {
    epsilon <- sample(s.residuals-mean(s.residuals)) * sqrt(variance)
    },
  wild.1 =
    {
    z1 <-  rnorm(n)
    z2 <-  rnorm(n)
    epsilon <- residuals * (z1/sqrt(2) + ( ((z2*z2)-1)/2))
    },
  wild.2 =
    { 
    a <- (5+sqrt(5))/10
    rbi <- rbinom(n, 1, a)
    epsilon <- vector(length=n)
    a1 <-  (1-sqrt(5))/2
    a2 <-  (1+sqrt(5))/2
    epsilon[rbi==1] <-  residuals[rbi==1] * a1
    epsilon[rbi==0] <-  residuals[rbi==0] * a2
    },
  calib =
    {	
    epsilon <- sample(residuals-mean(residuals), size=m)
    },
  stop(paste("\nInvalid argument 'method'.",
" Valid values are: 'residuals, s.residuals, wild.1, wild.2, calib' \n "))
	)
yStar <-  response +  epsilon
return(yStar)
}

# ----- end  function generbootnls2 ---------------------------------
	
			
# ------------------------------------------------------------------------
# initbootcnls2:	
# initialisation en cas de method calib
#  faire le 1ier appel a nls2 avec les n+m donnees	
# --------------------------------------------------------------------------
initbootcnls2 <- function(n,m, cc, ord, Zmoy, Valf,VarY, data, pbispsi,
                       wanted.sv, nls2.object)
{
	
# generer n pseudo-observations avec method=residuals:
yStar <- generbootnls2(method="residuals",n, m,   Valf,VarY, cc$residuals, cc$s.residuals)
# generer les ZStar parmi ZMoy+epsilon:	
ZStar <-  generbootnls2(method="calib", n, m, Zmoy,VarY, cc$residuals, cc$s.residuals) 
	
	
# Creer les nouvelles data:
# xchapeau est le dernier des pbispsi:		
xval <- pbispsi[length(pbispsi)]
if (xval == data[[nls2.object$X.names]][n])
  {
  # Modif de xval pour que ca soit pas une repet
  xval <-  xval+ .Machine$single.eps	
  }
	
x <- c(data[[nls2.object$X.names]],  rep(xval,m))

data2 <- data.frame(matrix(c(
    x , # la variable explicative
   data[[nls2.object$response.name]],ZStar),         # la reponse          
 ncol=2, 
 dimnames=list(NULL,c(nls2.object$X.names, nls2.object$response.name))))
# S'il y a des poids, on rajoute des poids=1 aux nouveaux points:
if (!is.null(data$weights)) data2$weights <- c(data$weights, rep(1,m))

# On refait l'estimation a partir des theta estimes dans le nls2.object:
nls2.object$stat.ctx$theta.start <- cc$theta
if (nls2.object$stat.ctx$sigma2.type=="KNOWN")
	nls2.object$stat.ctx$sigma2  <-  nls2.object$sigma2
if (nls2.object$stat.ctx$mu.type=="KNOWN")
	{
	# on fixe les mu du point rajoute a 0
	nls2.object$stat.ctx$mu3  <-  c(nls2.object$mu3,0)
	nls2.object$stat.ctx$mu4  <-  c(nls2.object$mu4,0)
	}

# Appel de nls2 sur les n+m observations avec renls2=T:
# Les cas d'erreurs qui bloquent sont gerees par nls2

Ret <-       nls2(data2, nls2.object$model, nls2.object$stat.ctx,
      method=nls2.object$method,
       control=list(freq=0,
         sv.steps=nls2.object$nb.steps,
         sv.estim=wanted.sv$estim,
         sv.as.var=wanted.sv$as.var,
         sv.num.res=wanted.sv$num.res,
         sv.fitted=wanted.sv$fitted,
         sv.data=wanted.sv$data,
         sv.residuals=wanted.sv$residuals ),
               renls2=T)

return( list(nls2.object=Ret))
}	

# --------------- fin de initbootcnls2 ---------------------------------------------
	
								
	
# ------------------------------------------------------------------------
# onebootrenls2:
# fonction qui gere une boucle renls2
# ------------------------------------------------------------------------
onebootrenls2 <- function(nloop, method,n,m, Valf,VarY, residuals, s.residuals,
	             Zmoy,
                     nls2.object,  wanted, wanted.sv) 
{
Ret <- list()
# generer n pseudo-observations:
if (method=="calib")
  {
  yStar <- generbootnls2(method="residuals", n, m, Valf,VarY, residuals, s.residuals)
  # Generation de m repet sup:
  ZStar <-  generbootnls2(method="calib", n, m,  Zmoy,VarY, residuals, s.residuals)	
  Ret$ZmoyStar <- mean(ZStar)
  yStar <- c(yStar,ZStar)
  if (wanted$YStar) Ret$YStar <- yStar
  }
else
  {			
  yStar <- generbootnls2(method,n, m, Valf,VarY, residuals, s.residuals)
  }

# estimation sur les yStar:
Retre <- renls2(nls2.object, response=yStar,
                      sv.steps=nls2.object$nb.steps,
                      sv.estim=wanted.sv$estim,
         sv.as.var=wanted.sv$as.var,
         sv.num.res=wanted.sv$num.res,
         sv.fitted=wanted.sv$fitted,
         sv.data=wanted.sv$data,
         sv.residuals=wanted.sv$residuals )


if (is.null(Retre))
  {
  warning(paste("no result at iteration", nloop, "\n"))
  if (wanted$var.pStar || wanted$psiStar || wanted$var.psiStar || wanted$tStar || wanted$conf.int)
      Ret$var.pStar <- NA
  Ret$pStar <-  NA
  Ret$code <- NA	
  Ret$message <- NA	
  return(Ret)
  }

# determiner les param actifs et as.var et sigma2 et residuals
#	et code retour de la derniere etape
	cc <-  exambootnls2(Retre)

# Determiner le 1ier code d'erreur non nul	
ccode  <-  deccodenls2(Retre)

if ( (method=="calib") || 
	wanted$var.pStar ||  
	wanted$psiStar || wanted$var.psiStar || wanted$tStar || wanted$conf.int)
  {	
  Ret$var.pStar <- cc$as.var
  Ret$resStar  <-  cc$residuals	
  }

# fx0Star sert pour la calib
Ret$fx0Star <-  cc$response[length(cc$response)]
Ret$pStar <-  cc$pact
Ret$sigma2Star <-  cc$sigma2
Ret$code <-  ccode$code
Ret$message  <-  ccode$message	
return(Ret)
}

# ----- end  function onebootrenls2 ---------------------------------


psibootnls2 <- function(nloop, file, ppsi, varpsi=NULL,pbispsi=NULL)
{
# -------------------------------------------------------------------------
# psibootnls2= function calcpsinls2: 
# call the program calcpsi <-  that evaluates a function psi
# but does not deallocate the created structures and returns in addition: 
#  NbPpsi: number of parameters that occur in the functions psi
#  NbPbispsi:  number of parameter bis that occur in the functions
#  nbl: length of the psi
# nbc: 0 or number of Varpsi
# RetVerif: return of function verifPsinls2
# -------------------------------------------------------------------------
# Input arguments:
# nloop:	 index of the loop	
# file: name of the formal description file of the psi functions
#  ppsi: values of the parameters 
#  varpsi: the variables 'varpsi'
#  pbispsi: values of the second level parameters 
# -------------------------------------------------------------------------

# Initialisation de GNLControle en ce qui concerne les messages
# -------------------------------------------------------------
 check <-  options()$check
 warn <-  options()$warn
 .C("initcrolenls2",  as.integer(check), as.integer(warn))
# Ne pas ter 
			
	
# Verification 
# -------------
RetVerif <- verifPsinls2(file=file, ppsi=ppsi, varpsi=varpsi, pbispsi=pbispsi)
if (is.null(RetVerif)) return(NULL)
	
# Creation des valeurs de varpsi:
# ------------------------------
	if (!is.null(varpsi))
  {
  nbl <-  nrow(RetVerif$Varpsi)
  nbc <- ncol(RetVerif$Varpsi)
  if (!is.null(dimnames(varpsi)))
    labelrow <- dimnames(varpsi)[[1]]
  else
    labelrow <- NULL
  # on met les varpsi dans Donnees.XObsT:
  .C("crVarPsinls2", as.double(RetVerif$Varpsi),
              n=as.integer(nbl),
              m=as.integer(nbc))
  }
else
  {
  labelrow <- RetVerif$NomPsi
  nbl <-  RetVerif$NbPsi
  nbc <- 0
  }

# Creation de la trace 
# ---------------------------------
.C("crTracenls2")

# APPEL DU CALCUL
# ------------
le <- 0
ie <- 0
NbPpsi <- length(RetVerif$Ppsi)
NbPbispsi <- length(RetVerif$Pbispsi)
psi <- vector(mode="double", length=nbl)
dpsi <- vector(mode="double", length=(nbl * NbPpsi))
Ret <- .C("calcpsinls2", 
   pact=as.integer(NbPpsi),
   NbPbispsi=as.integer(NbPbispsi),
   nbl=as.integer(nbl), nbc=as.integer(nbc),
   Ppsi=as.double(RetVerif$Ppsi),
   Pbispsi=as.double(RetVerif$Pbispsi),
   psi=as.double(psi), dpsi=as.double(dpsi),
   le=as.integer(le), ie=as.integer(ie))


if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function psi", 
   "the function v",
   "the derivatives of psi",
   "the derivatives of v against the ppsi parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the ppsi parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")

  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"
  warning(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value at loop", nloop, "\n"))
  return(NULL)	
  }


# Transform dpsi into a matrix
# --------------------------

if(all(Ret$dpsi ==0)) Ret$dpsi  <- NA
else Ret$dpsi <- matrix(Ret$dpsi, ncol=NbPpsi, byrow=T,
          dimnames=list(labelrow, names(RetVerif$Ppsi)))

if(all(Ret$psi==0)) Ret$psi  <- NA
else names(Ret$psi) <- labelrow

return(list(NbPpsi=NbPpsi, NbPbispsi=NbPbispsi, nbl=nbl, nbc=nbc, labelrow=labelrow, 
   Pbispsi=RetVerif$Pbispsi, psi=Ret$psi, d.psi=Ret$dpsi))
}
# ----------- end function psibootnls2 ----------
# ----------------------------------------


# ------------------------------------------------------------------------
# onebootpsinls2:
# fonction qui gere une boucle calcpsi
# ------------------------------------------------------------------------
onebootpsinls2 <- function(
                     cc, file,
	             n,m,  method,
                     psi1,  wanted, 
                     namepsi, labelrow,
                     NbPpsi,NbPbispsi, nbl, nbc,  Pbispsi)
{
Ret <- list()

# APPEL DU CALCUL
# ------------
if (any(is.na(cc$pStar)))
  {
  if (wanted$psiStar)
    Ret$psiStar <-  NA
  if (wanted$var.psiStar)
    Ret$var.psiStar <-  NA
  if (wanted$tStar || wanted$conf.int)
    Ret$tStar <-  NA
  return(Ret)
  }



le <- 0
ie <- 0
psi <- vector(mode="double", length=nbl)
dpsi <- vector(mode="double", length=(nbl * NbPpsi))

RetPsi <- .C("calcpsinls2", 
   pact=as.integer(NbPpsi),
   NbPbispsi=as.integer(NbPbispsi),
   nbl=as.integer(nbl), nbc=as.integer(nbc),
   Ppsi=as.double(cc$pStar[namepsi]),
   Pbispsi=as.double(Pbispsi),
   psi=as.double(psi), dpsi=as.double(dpsi),
   le=as.integer(le), ie=as.integer(ie))

if(RetPsi$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function psi", 
   "the function v",
   "the derivatives of psi",
   "the derivatives of v against the ppsi parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the ppsi parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")

  if (RetPsi$le <= length(coderr))
    lieuerr <- coderr[RetPsi$le]
  else
    lieuerr <- "the model"
  warning(paste("\nError when calculating \n",
              lieuerr,"\n on observation",RetPsi$ie,
              "\n No valid returned value for psi calculation at one iteration\n"))


  if (wanted$psiStar)
    Ret$psiStar <-  NA
  if (wanted$var.psiStar)
    Ret$var.psiStar <-  NA
  if (wanted$tStar || wanted$conf.int)
    Ret$tStar <-  NA
  return(Ret)
  }


# Transform dpsi into a matrix
# --------------------------

if(all(RetPsi$dpsi ==0)) RetPsi$dpsi  <- NA
else RetPsi$dpsi <- matrix(RetPsi$dpsi, ncol=NbPpsi, byrow=T,
          dimnames=list(labelrow, namepsi))

if(all(RetPsi$psi==0)) RetPsi$psi  <- NA
else names(RetPsi$psi) <- labelrow


if (!is.null(cc$var.pStar))
  {		
  # as.var des psiStar: 
  # on ne garde, parmi les parametres actifs du modele,
  # que ceux qui interviennent dans les psi:
  as.var <- as.matrix(cc$var.pStar[namepsi, namepsi])
  produit  <-  RetPsi$dpsi %*% as.var %*% t(RetPsi$dpsi)
  if (wanted$tStar || wanted$conf.int)
    tStar <-  (RetPsi$psi - psi1) / (sqrt(diag(produit)))
  # Si calib, calculer SStar:	
  if (method =="calib")
    {
    Ret$SStar <-  CalcSStarnls2 (n,m, produit, 
              cc$sigma2Star, cc$ZmoyStar, cc$fx0Star, cc$resStar)
    }
  } # fin de 	!is.null(cc$var.pStar)

if (wanted$psiStar)
  Ret$psiStar <-  RetPsi$psi
if (wanted$var.psiStar)
  Ret$var.psiStar <-  produit
if (wanted$tStar || wanted$conf.int)
  Ret$tStar <-  tStar
return(Ret)
}
# ----- end  function onebootpsinls2 ---------------------------------

# -------------------------------------------------------------------------
# bootstrap.nls2:
# fonction qui fait du bootstrap
# Constraints:
#  nls2 previously called with option renls2 except for "calib"
#  only, one function of parameters at most, and one varpsi value
# Remark:
# la valeur par defaut de n.loops, permet, etant la valeur par defaut
# de conf.level, d'avoir autant de tStar a gauche de tStar[ba1]
# que a droite de tStart[ba2] (ici, on choisit 2 tStar a gauche de tStar[ba1]
# et 2 a droite de tStart[ba2]), tout en ayant un saut entre 2 valeurs
#  de tStar minimum ce qui donne un intervalle plus precis
# -------------------------------------------------------------------------
bootstrap.nls2 <- function(nls2.object,
                    method="param", 
                    wanted=list(pStar=T, 
	var.pStar=T, sigma2Star=T, 
	psiStar=T, var.psiStar=T, tStar=T, conf.int=T,
	YStar=F, SStar=F),
                    n.loops=119,
                    conf.level=0.95,
                    file=NULL,
                    pbispsi= c(nls2.object$model$gamf,nls2.object$model$gamv),
                    varpsi=NULL, ord=NULL)
{
# Verifications:
if (!is.numeric(conf.level) || (length(conf.level) >1) ||
     (conf.level <=0) || (conf.level >=1))
  stop("The argument 'conf.level' must be a value between 0 and 1\n")

if (!is.character(method) || (length(method) >1))
  stop("The argument 'method' should be a character string\n")

if(!is.list(wanted))
  stop("The argument 'wanted' should be a list structure\n")

if (!is.numeric(n.loops) || (length(n.loops) >1) || (n.loops <1))
  stop("The argument 'n.loops' must be a positive integer\n")

# Verification quand method=calib:	
if (method=="calib")
  {
  if (missing(file))
    stop("For method 'calib', argument 'file' is required\n")
  if (missing(ord))	
    stop("For method 'calib', argument 'ord' is required\n")
  if (missing(pbispsi) || (length(pbispsi) != length(nls2.object$model$gamf)+1))
    stop(paste("\nFor method 'calib',argument 'pbispsi' must exist:",
"the value of its first elements must be the same as in 'nls2.object'",
"and the value of its last element must be the unknown abscissa.\n"))
  data <-  AutVerifcnls2(nls2.object)	
  } # fin verif calib	
	
if (is.null(nls2.object$replications))
  stop("The nls2.object should contain the vector of replications")

# Determiner les resultats de la derniere etape
cc <-  exambootnls2(nls2.object)
# Verifier qu'on a tous les lments de calcul dans le nls2.object:
if ( (method != "param") && is.null(cc$residuals))
  stop("The nls2.object should contain 'residuals'")
if ( ((method == "s.residuals") || (method == "calib")) &&
    is.null(cc$s.residuals))
  stop("The nls2.object should contain 's.residuals'")

# Determiner les lments ncessaires aux calculs :
wanted.sv  <-  list(estim=T, as.var=T, num.res=T, fitted=T, data=T, residuals=F)
if (method != "param")
  wanted.sv$residuals  <- T

# initialisations
namep <- names(cc$pact)
namepsi <- NULL
RetPsi <- NULL

# Si wanted est donne, tous les composants non fournis
# sont affectes a leur valeur par defaut:
if (method != "calib")
  {
  if (is.null(file))
    {		
    if (is.null(wanted$pStar)) wanted$pStar <- T
    if (is.null(wanted$var.pStar)) wanted$var.pStar <- T
    if (is.null(wanted$sigma2Star)) wanted$sigma2Star <- T
    if (is.null(wanted$psiStar)) wanted$psiStar <- T
    if (is.null(wanted$var.psiStar)) wanted$var.psiStar <- T
    if (is.null(wanted$tStar)) wanted$tStar <- T
    if (is.null(wanted$conf.int)) wanted$conf.int <- T
    } # fin de 	method != "calib" et is.null(file)
  else
    {
    if (missing(wanted))
      wanted <- list(pStar=F, 
	 var.pStar=F, sigma2Star=F,
	  psiStar=T, var.psiStar=T, tStar=T, conf.int=T)
    else
      {		
      if (is.null(wanted$pStar)) wanted$pStar <- F
      if (is.null(wanted$var.pStar)) wanted$var.pStar <- F
      if (is.null(wanted$sigma2Star)) wanted$sigma2Star <- F
      if (is.null(wanted$psiStar)) wanted$psiStar <- T
      if (is.null(wanted$var.psiStar)) wanted$var.psiStar <- T
      if (is.null(wanted$tStar)) wanted$tStar <- T
      if (is.null(wanted$conf.int)) wanted$conf.int <- T
      }	
    } # fin de 	method != "calib" et !is.null(file)
  }
else
  {
  if (missing(wanted))
    wanted <- list(pStar=F, 
	var.pStar=F, sigma2Star=F,
	psiStar=F, var.psiStar=F, tStar=F, conf.int=F, YStar=F,
	SStar=F)
  else
    {		
    if (is.null(wanted$pStar)) wanted$pStar <- F
    if (is.null(wanted$var.pStar)) wanted$var.pStar <- F
    if (is.null(wanted$sigma2Star)) wanted$sigma2Star <- F
    if (is.null(wanted$psiStar)) wanted$psiStar <- F
    if (is.null(wanted$var.psiStar)) wanted$var.psiStar <- F
    if (is.null(wanted$tStar)) wanted$tStar <- F
    if (is.null(wanted$conf.int)) wanted$conf.int <- F
    if (is.null(wanted$YStar)) wanted$YStar <- F
    if (is.null(wanted$SStar)) wanted$SStar <- F
    }
  } # fin du cas calib		
	
if (is.null(file))
  {
  # si pas de fichier pour les psi: on ne peut demander que pStar et/ou var.pStar
   if (!missing(wanted))
     { 
     if (wanted$psiStar)
        {
        warning(
         "Argument 'wanted$psiStar' ignored because no function of parameters is provided\n")
        wanted$psiStar <- F
        }
     if (wanted$var.psiStar)
        {
        warning(
         "Argument 'wanted$var.psiStar' ignored because no function of parameters is provided\n")
        wanted$var.psiStar <- F
        }
     if (wanted$tStar)
        {
        warning(
         "Argument 'wanted$tStar' ignored because no function of parameters is provided\n")
        wanted$tStar <- F
        }
     if (wanted$conf.int)
        {
        warning(
         "Argument 'wanted$conf.int' ignored because no function of parameters is provided\n")
        wanted$conf.int <- F
        }
    } # end of !missing(wanted))
  else
    # valeur par defaut quand pas de functions:
    wanted <- list(pStar=T, var.pStar=T, sigma2Star=T,
	         psiStar=F, var.psiStar=F, tStar=F, conf.int=F)
  } # fin du cas pas de fichier

if ( (method != "calib") &&
   (wanted$pStar!=T)  && (wanted$var.pStar!=T) && (wanted$sigma2Star!=T)
	   && (wanted$psiStar!=T) && (wanted$var.psiStar!=T)
    && (wanted$tStar!=T) && (wanted$conf.int!=T))
   stop(paste("The argument 'wanted' is not correct:",
"\n you must require something among 'pStar var.pStar sigma2Star psiStar var.psiStar tStar conf.int'\n"))

#  mettre en dimension n Valf,VarY
Valf <- rep(cc$response, nls2.object$replications)
VarY <- rep(cc$variance, nls2.object$replications)
n <- length(Valf)
if (!is.null(ord)) {
	m <- length(ord)
	Zmoy <- mean(ord)
	}
else
	{
	m <- 0
	Zmoy <- 0
	}

# Initialisation quand method=calib, parce que il faut faire
# un 1ier appel a nls2 avec les n+m donnees
if (method=="calib")
  {
  Retinitc <- 	initbootcnls2(n, m, cc, ord, Zmoy, Valf,VarY, data, pbispsi,
                              wanted.sv, nls2.object)
  nls2.object <-  Retinitc$nls2.object
  }
		

# Boucle d'estimation du modele de f:
mloops <- matrix(1:n.loops, ncol=1)
cat("\nLoop for estimation with the f-model\n")
Retrenls2 <- apply(mloops, 1, "onebootrenls2", method,n,m, Valf, VarY,
  cc$residuals, cc$s.residuals, Zmoy, nls2.object, wanted, wanted.sv)
	
# Initialisation de la structure retournee:
# -----------------------------------------
# Initialiser a Null les composants permet qu'ils soient ranges
# dans cet ordre dans la structure renvoyee:			
retour <- list(call=match.call(), code=NULL, message=NULL,
   n.loops=NULL)
	
# Mettre sous forme de matrice les resultats

namel <- paste("loop",1:n.loops,sep="")
retour$code <-  rep(0, n.loops)
retour$message <-  rep("OK", n.loops)
names(retour$code) <-  names(retour$message) <- namel
	
if (wanted$sigma2Star)
  {	
  retour$sigma2Star <-  rep(0, n.loops)
  names(retour$sigma2Star) <-  namel
  }
			
	
if (wanted$pStar)
  # que les parametres actifs du modele:
  retour$pStar <- matrix(nrow=n.loops, ncol=length(namep),
  dimnames=list(namel, namep))
	
	
# var.pStar: pour chaque loop, la diagonale de l'as.var 
# reduite aux parametres actifs du modele
if (wanted$var.pStar)
  retour$var.pStar <- matrix(nrow=n.loops, ncol=length(namep),
  dimnames=list(namel, namep))


if ((method=="calib") && wanted$YStar)
  retour$YStar  <-  matrix(nrow=n.loops, ncol=(n+m), 
	  	dimnames=list(namel,NULL))

for (i in seq(1,n.loops))
  {
  retour$code[i] <-  Retrenls2[[i]]$code
  retour$message[i] <-  Retrenls2[[i]]$message
  if (wanted$sigma2Star)
    retour$sigma2Star[i] <-  Retrenls2[[i]]$sigma2Star
  if (wanted$pStar)
    retour$pStar[i,] <-  Retrenls2[[i]]$pStar
  if ((method=="calib") && wanted$YStar)
    retour$YStar[i,] <- 	Retrenls2[[i]]$YStar
	
  if (wanted$var.pStar) 
    {
    if (all(!is.na(Retrenls2[[i]]$var.pStar)))
	{
	if (!is.null(dim(Retrenls2[[i]]$var.pStar)))
	      retour$var.pStar[i,] <-  diag(Retrenls2[[i]]$var.pStar)
	else
		retour$var.pStar[i,] <-  Retrenls2[[i]]$var.pStar
	}
    else
      retour$var.pStar[i,] <- NA
    }
  }

# n.loops= nbre de boucles de codes nuls	
zcode <-  (retour$code==0)
retour$n.loops <- length(zcode[zcode==T])
			
# Calcul des psi:
# --------------
if ( method=="calib" ||
     wanted$psiStar || wanted$var.psiStar || wanted$tStar || wanted$conf.int)
  {
  # 1ier appel a calcpsi sur les parametres originaux:	
  RetPsi <- psibootnls2(1, file, ppsi=cc$pact, varpsi=varpsi, pbispsi=pbispsi)
  if (is.null(RetPsi)) return(retour)
	
  # une seule fonction:
  if (length(RetPsi$psi) >1)
    {
    warning("\n Function of parameters can have only one value\n")
    return(retour)
    }

# On ne garde dans as.var, qui est deja reduite aux parametres actifs du modele,
# que ceux qui interviennent dans les psi:
  namepsi <-  dimnames(RetPsi$d.psi)[[2]]
  as.var <- as.matrix(cc$as.var[namepsi, namepsi])
  produit  <-  RetPsi$d.psi %*% as.var %*% t(RetPsi$d.psi)
	
# boucle sur calcpsi
  Retpsinls2 <- lapply(Retrenls2, "onebootpsinls2", file,
	             n,m,  method,
                     RetPsi$psi,  wanted, 
                     namepsi, RetPsi$labelrow,
                     RetPsi$NbPpsi,RetPsi$NbPbispsi, RetPsi$nbl, RetPsi$nbc,  
                     RetPsi$Pbispsi)

  }

	
# Desallouer les structures C creees:
# ----------------------------------
# nov 94:	j'ote cette destruction car ca empeche
# d'appeler bootstrap plusieurs fois de suite		
#if (!is.null(varpsi))
#  .C("delPsinls2")
#.C("DetruTrace")

# Completer la structure retournee:
# --------------------------------
if (wanted$psiStar)
  {
  retour$psiStar <- vector(length=n.loops)
  names(retour$psiStar) <- namel
  }
if (wanted$var.psiStar)
  {
  retour$var.psiStar <- vector(length=n.loops)
  names(retour$var.psiStar) <- namel
  }

if (wanted$tStar || wanted$conf.int) 
  {
  retour$tStar <- vector(length=n.loops)
  names(retour$tStar) <- namel
  }

if (method=="calib")
  {
  retour$SStar   <- vector(length=n.loops)
  names(retour$SStar) <- namel
  }				

for (i in seq(1,n.loops))
  {
  if (wanted$psiStar)
    retour$psiStar[i] <- Retpsinls2[[i]]$psiStar
  if (wanted$var.psiStar)
    retour$var.psiStar[i] <- Retpsinls2[[i]]$var.psiStar
  if (wanted$tStar || wanted$conf.int)
    retour$tStar[i] <- Retpsinls2[[i]]$tStar
  if (method =="calib")
    retour$SStar[i] <- Retpsinls2[[i]]$SStar	
  }

if( wanted$conf.int || (method=="calib"))
  {
  # on ne garde que les boucles pour lesquelles nls2 a converge	
  if (retour$n.loops ==0)
    {
    warning("No confidence interval or bounds returned because there is no correct convergence \n")
    if (wanted$conf.int) retour$conf.int <- NULL
    if (method=="calib") retour$conf.bounds <- NULL
    }
  else
    {
    a <-  (1 - conf.level)/2
    ba2 <-  ceiling( retour$n.loops * a)
    a <-  1-a
    ba1  <-  ceiling(retour$n.loops * a)
	
    if ( wanted$conf.int)
      {	
      ftStar <-  retour$tStar[zcode]
      tStar <- sort(ftStar)
      produit <- sqrt(produit)
      retour$conf.int <- c( (RetPsi$psi- produit*tStar[ba1]),
                (RetPsi$psi- produit*tStar[ba2]))
      names(retour$conf.int) <- c("lower","upper")
      if (wanted$tStar==F)
        retour$tStar <- NULL
      } # fin de wanted$conf.int
    if (method=="calib")
      {	
      ftStar <-  retour$SStar[zcode]
      tStar <- sort(ftStar)
      retour$conf.bounds <- c(tStar[ba2], tStar[ba1])
      names(retour$conf.bounds) <- c("lower","upper")
      if (wanted$SStar==F)
        retour$SStar <- NULL		
      } # fin de method=="calib"
    } # fin du else
	
  } # fin de ( wanted$conf.int || (method=="calib")
			
# Ne retourner tous les codes d'erreur que s'il y a une erreur:
# -------------------------------------------------------------
if (all(zcode))
  {
  retour$code <- 0
  retour$message <- "OK"
  }
			
return(retour)
}


# ----- end  function bootstrap.nls2 ---------------------------------
