# : ### FICHIER calcinvnls2.s ###

# ----------------------------------------------------------------
# FUNCTION verifInvnls2
# verifie le type des arguments
# appelle :
# - analInvnls2 pour savoir la dimension des noms de parametres, etc..
# - crInvnls2 pour creer l'arbre de calcul de la fonction
# ----------------------------------------------------------------

verifInvnls2 <- function(file,ord,theta,gamf, gamv)
{
if (!is.numeric(ord))
  stop("\nThe argument 'ord' not numeric\n")
# le reste sera verifie dans verifNameP

# Verification that the model description corresponds:
# ----------------------------------------------------
if (!is.character(file))
    stop("\nThe 'file' argument must be the name of the description-file\n")
RetModel <-  analInvnls2(file)


# si le vecteur des parametres est labelle, on ne garde que les elements dont les
# labels correspondent a ceux du fichier formel:
Ret <- 	verifNamePnls2(theta, RetModel$NomParact, RetModel$NbParact, "theta")
if (is.null(Ret)) return(NULL)	
theta <- Ret$Param
# idem pour les pbis:
Ret <- 	verifNamePnls2(gamf, RetModel$NomPbisabs, RetModel$NbPbisabs, "gamf")
if (is.null(Ret)) return(NULL)
gamf <-  Ret$Param
Ret <-   verifNamePnls2(gamv, RetModel$NomPbisvar, RetModel$NbPbisvar, "gamv")
if (is.null(Ret)) return(NULL)	
gamv <- Ret$Param 

# GENERATION DE L'ARBRE DE CALCUL DU MODELE
# ------------------------------------------
# Appel de crInv si pas de programme fourni
#  verifier que calcinvf <-  est loade
pload <-  as.integer(0)

if (.C("invloadnls2",pload=pload)$pload==0)
  { #modele non charge: evaluation par arbre
  if (RetModel$YaSubr==0)
    {	
    warning("\nThe model description file doesn't include expressions: you must provide the 'calcinv' program\n")
    return(NULL)
    }		
  crInvnls2(file) # creation de l'arbre
  }

Ret <- list(Paract= theta, Pbisabs=gamf, Pbisvar=gamv)
return(Ret)

}
# --------------- End of verifInvnls2 ---------------------------------------


# ----------------------------------------------------------
#  FUNCTION analInvnls2
# ----------------------------------------------------------
analInvnls2 <-  function(ficmod)
{
# Decoder le fichier formel du model de inv
# -----------------------------------------------------------
NbParact <- as.integer(0)
NbPbisabs <- as.integer(0)
NbPbisvar <- as.integer(0)
YaSubr <- as.integer(0)
Code <- as.integer(0)

Ret <- .C("nbInvnls2", as.character(ficmod),
              NbParact=as.integer(NbParact),
              NbPbisabs=as.integer(NbPbisabs),
              NbPbisvar=as.integer(NbPbisvar),
              YaSubr=as.integer(YaSubr),
              Code=as.integer(Code))

if (Ret$Code !=0)
  stop("\nError in the program 'analInvnls2'\n")

# allocation des vecteurs des noms  
# initialisation des vecteurs des noms
# c'est necessaire pour le cas ou les noms ont plus
# d'1 caractere: on les initialise a la longueur maxi
# fixee pour les noms, en l'occurrence,
# on fixe cette limite a 15
NomParact <- rep("              ", Ret$NbParact)
NomPbisabs <- rep("              ", Ret$NbPbisabs)
NomPbisvar <- rep("              ", Ret$NbPbisvar)

noms <- .C("nameInvnls2", as.character(ficmod),
              NbParact=as.integer(Ret$NbParact),
              NbPbisabs=as.integer(Ret$NbPbisabs),
              NbPbisvar=as.integer(Ret$NbPbisvar),
              NomParact=as.character(NomParact),
              NomPbisabs=as.character(NomPbisabs),
              NomPbisvar=as.character(NomPbisvar),
               Code=as.integer(Code))
 
if (noms$Code !=0)
  stop("\nError in the program 'nameInvnls2'\n")

# Rajout des noms dans la liste retournee:
Ret$NomParact<-noms$NomParact
Ret$NomPbisabs<-noms$NomPbisabs
Ret$NomPbisvar<-noms$NomPbisvar
return(Ret)

}
# ----------- end of analInvnls2 ---------------------------


# ------------------------------------------------
#  FUNCTION crInvnls2
# ------------------------------------------------
crInvnls2 <-  function(ficmod)
{
# Initialisation des variables globales de crInv
# au cas ou il y a deja eu un appel  dans la session
# Creation de l'arbre de calcul
# --------------------------------------------------
.C("initglobinv")
Code <- as.integer(0)
Ret <- .C("crInvnls2", as.character(ficmod),
              Code=as.integer(Code))

if (Ret$Code !=0)
  stop("\nError in the description file of the inverse regression function\n")

invisible()
}
# ----------- end of crInvnls2 ---------------------------


calcinvnls2 <- function( file, ord, theta ,gamf=NULL, gamv=NULL)
{
# -------------------------------------------------------------------------
# calcinvnls2: call the program calcinv <-  that evaluates a function inverse of f
# (returns the values of the x="abs") on given values of the y ("ord")
# and the parameters "theta" and, possibly on pbis
# -------------------------------------------------------------------------
# Input arguments:
# file: name of the formal description file of the inverse function
# ord: values of y
#  theta: values of the parameters 
#  gamf: values of the second level parameters of expression of x
#  gamv: values of the second level parameters of variance of y

# Return object:
# a list that contains the components:
# - inv: the values of the inverse function
# - d.inv.p: the values of the derivatives of the inverse function with
# respect to the parameters
# - d.inv.o: the values of the derivatives of the inverse function with
# respect to y
# - variance: the values of the variance
#
# Constraint:
# a previous call to loadnls2(inv!=NA) is required
# x: univariate
# 
# SE:
# initialise GNLControle 
# cree la trace puis la detruit
# stop si erreur de calcul
# cree l'arbre de calcul si necessaire
# -------------------------------------------------------------------------

# Initialisation de GNLControle et de la trace
# ---------------------------------------------
check <-  options()$check
warn <-  options()$warn
.C("initcrolenls2",  as.integer(check), as.integer(warn))
.C("crTracenls2")


# Verification 
# -------------
RetVerif <- verifInvnls2(file=file,ord=ord,theta=theta,gamf=gamf, gamv=gamv)
if (is.null(RetVerif)) return(NULL)
	
# appel du calcul
# ---------------
nbl <- length(ord)
nbtheta <- length(RetVerif$Paract)
nbgamf <- length(RetVerif$Pbisabs)
nbgamv <- length(RetVerif$Pbisvar)

# les sorties de calcinv:
abs <- vector(mode="double", length=nbl)
dabsdp <- vector(mode="double", length=(nbl * nbtheta))
dabsdo <- vector(mode="double", length=nbl) # derivees de l'abs par rapport a l'ord 
varord <- vector(mode="double", length=nbl) # variance de l'ordonnee
le <- 0
ie <- 0

Ret <- .C("calcinvnls2", 
   nbp=as.integer(nbtheta),
   nbga=as.integer(nbgamf),
   nbl=as.integer(nbl),
   nbgv <- as.integer(nbgamv),
   p=as.double(RetVerif$Paract),
   ga=as.double(RetVerif$Pbisabs),
   ord=as.double(ord),
   gv=as.double(RetVerif$Pbisvar),
   abs=as.double(abs),
   dabsdp=as.double(dabsdp),
   dabsdo=as.double(dabsdo),
   varord=as.double(varord),
   le=as.integer(le), ie=as.integer(ie))

# Desallouer les structures C creees:
# ----------------------------------
.C("DetruTrace")

if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function inverse", 
   "the function v",
   "the derivatives of the inverse",
   "the derivatives of v with respect to the theta parameters",
   "the derivatives of v with respect to the beta parameters",
   "auxiliary variables",
   "the derivatives of the auxiliary variables with respect to the theta parameters",
   "the derivatives of the auxiliary variables with respect to the beta parameters",
   "auxiliary variables the model inverse",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the inverse model"
  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }


# Transform dinv into a matrix
# --------------------------
labelrow <- names(ord)

if(is.null(Ret$dabsdp) || all(is.na(Ret$dabsdp)) || all(Ret$dabsdp ==0)) Ret$dabsdp  <- NA
else Ret$dabsdp <- matrix(Ret$dabsdp, ncol=nbtheta, byrow=T,
          dimnames=list(labelrow, names(RetVerif$Paract)))

if(is.null(Ret$abs) || all(is.na(Ret$abs)) || all(Ret$abs==0)) Ret$abs  <- NA
else names(Ret$abs) <- labelrow

if(is.null(Ret$dabsdo) || all(is.na(Ret$dabsdo)) || all(Ret$dabsdo==0)) Ret$dabsdo  <- NA
else names(Ret$dabsdo) <- labelrow

if(is.null(Ret$varord) || all(is.na(Ret$varord)) || all(Ret$varord==0)) Ret$varord  <- NA
else names(Ret$varord) <- labelrow

return(list(inv=Ret$abs, d.inv.p=Ret$dabsdp, d.inv.o=Ret$dabsdo, variance=Ret$varord))
}
# ----------------------------------------
# ----------- end function calcinvnls2 ----------
# ----------------------------------------

