# : ### FICHIER calcpsinls2.s ###

# ----------------------------------------------------------------
# FUNCTION verifPsinls2
# verifie le type des arguments
# appelle :
# - analPsinls2 pour savoir la dimension des noms de parametres, etc..
# - crPsinls2 pour creer l'arbre de calcul de la fonction
# ----------------------------------------------------------------

verifPsinls2 <- function(file, ppsi, varpsi=NULL,  pbispsi=NULL)
{
# Verification that the model description corresponds:
# ----------------------------------------------------
if (!is.character(file))
    stop("\nThe 'file' argument must be the name of the description-file\n")
RetModel <-  analPsinls2(file)
if (is.null(RetModel)) return(NULL)
	
# si le vecteur est labelle, on ne garde que les elements dont les
# labels correspondent a ceux du fichier formel:
Ret <- 	verifNamePnls2(ppsi, RetModel$NomPpsi, RetModel$NbPpsi,"ppsi")
if(is.null(Ret)) return(NULL)	
ppsi <- Ret$Param
# idem pour les pbis:
Ret <- 	verifNamePnls2(pbispsi, RetModel$NomPbispsi, RetModel$NbPbispsi,"pbispsi")
if(is.null(Ret)) return(NULL)
pbispsi <- Ret$Param
if (!is.null(varpsi))
  {
    if (length(RetModel$NomVarPsi)==0) {
      stop("No 'varpsi' in the formal description file")
    }
    if (is.vector(varpsi)) {
      varpsi <- matrix(varpsi, ncol=1, dimnames=list(NULL, RetModel$NomVarPsi))
    }
    
  # transformation en vecteur de la 1iere ligne de varpsi pour pouvoir utiliser verifNamePnls2:
  varvect <- as.vector(varpsi[1,])
  names(varvect) <- dimnames(varpsi)[[2]]
  Ret <- 	verifNamePnls2(varvect, RetModel$NomVarPsi, RetModel$NbVarPsi,"varpsi")
  if(is.null(Ret)) return(NULL)	
  varvect <- Ret$Param
  varpsi <- as.matrix(varpsi[,names(varvect)])
  dimnames(varpsi) <- list(dimnames(varpsi)[[1]], names(varvect))
  nbc <-  ncol(varpsi)
  nbl <- nrow(varpsi)
  }

# GENERATION DE L'ARBRE DE CALCUL DU MODELE
# ------------------------------------------
# Appel de crPsi si pas de programme fourni
#  verifier que calcpsi est loade
pload <-  as.integer(0)
if (.C("psiloadnls2",pload=pload)$pload==0)
  { #modele non charge: evaluation par arbre
  if (RetModel$YaSubr==0)
    {	
    warning("\nThe model description file doesn't include expressions: you must provide the 'calcpsi' program\n")
    return(NULL)
    }		
  if (crPsinls2(file) !=0) return(NULL)
  }

Ret <- list(Varpsi=varpsi, Ppsi= ppsi, Pbispsi=pbispsi, NbPsi=RetModel$NbPsi, NomPsi=RetModel$NomPsi)
return(Ret)

}
# --------------- End of verifPsinls2 ---------------------------------------


# ----------------------------------------------------------
#  FUNCTION analPsinls2
# ----------------------------------------------------------
analPsinls2 <-  function(ficmod)
{
# Decoder le fichier formel du model de psi
# -----------------------------------------------------------
NbPpsi <- as.integer(0)
NbPbispsi <- as.integer(0)
NbPsi <- as.integer(0)
NbVarPsi <- as.integer(0)
YaSubr <- as.integer(0)
Code <- as.integer(0)

Ret <- .C("nbPsinls2", as.character(ficmod),
              NbPpsi=as.integer(NbPpsi),
              NbPbispsi=as.integer(NbPbispsi),
              NbPsi=as.integer(NbPsi),
              NbVarPsi=as.integer(NbVarPsi),
              YaSubr=as.integer(YaSubr),
              Code=as.integer(Code))
if ((Ret$NbPpsi==0) || (Ret$NbPsi==0))
  {
  warning("\nError in the formal description of the functions: key-words 'psi' and 'ppsi' required\n")
  return(NULL)
  }


if (Ret$Code !=0)
  {	
  warning("\nError in the program 'analPsinls2'\n")
  return(NULL)
  }		

# allocation des vecteurs des noms  
# initialisation des vecteurs des noms
# c'est necessaire pour le cas ou les noms ont plus
# d'1 caractere: on les initialise a la longueur maxi
# fixee pour les noms, en l'occurrence,
# on fixe cette limite a 15
NomPpsi <- rep("              ", Ret$NbPpsi)
NomPbispsi <- rep("              ", Ret$NbPbispsi)
NomPsi     <- rep("              ", Ret$NbPsi)
NomVarPsi     <- rep("              ", Ret$NbVarPsi)

noms <- .C("namePsinls2", as.character(ficmod),
              NbPpsi=as.integer(Ret$NbPpsi),
              NbPbispsi=as.integer(Ret$NbPbispsi),
              NbPsi=as.integer(Ret$NbPsi),
              NbVarPsi=as.integer(Ret$NbVarPsi),
              NomPpsi=as.character(NomPpsi),
              NomPbispsi=as.character(NomPbispsi),
              NomPsi=as.character(NomPsi),
              NomVarPsi=as.character(NomVarPsi),
               Code=as.integer(Code))
 
if (noms$Code !=0)
  {	
  warning("\nError in the program 'namePsinls2'\n")
  return(NULL)
  }		

# Rajout des noms dans la liste retournee:
Ret$NomPpsi<-noms$NomPpsi
Ret$NomPbispsi<-noms$NomPbispsi
Ret$NomPsi<-noms$NomPsi
Ret$NomVarPsi<-noms$NomVarPsi
return(Ret)

}
# ----------- end of analPsinls2 ---------------------------


# ------------------------------------------------
#  FUNCTION crPsinls2
# ------------------------------------------------
crPsinls2 <-  function(ficmod)
{
# Initialisation des variables globales de crPsi
# au cas ou il y a deja eu un appel  dans la session
# --------------------------------------------------
.C("initglobpsi")
Code <- as.integer(0)
Ret <- .C("crPsinls2", as.character(ficmod),
              Code=as.integer(Code))

if (Ret$Code !=0)
  warning("\nError in the description file of the functions of the parameters\n")
  
return(Ret$Code)
}
# ----------- end of crPsinls2 ---------------------------


calcpsinls2 <- function( file, ppsi, varpsi=NULL,pbispsi=NULL)
{
# -------------------------------------------------------------------------
# calcpsinls2: call the program calcpsi <-  that evaluates a function psi
# or several functions psi on given values of the parameters;
# when there is only a function psi, this can be a function of variables 'varpsi'
# -------------------------------------------------------------------------
# Input arguments:
# file: name of the formal description file of the psi functions
#  ppsi: values of the parameters 
#  varpsi: the variables 'varpsi'
#  pbispsi: values of the second level parameters 

# Return object:
# a list that contains the components:
# - psi: the values of the psi functions or, if only one function psi
# and variables 'varpsi', values of this function on the 'varpsi'
# - d.psi: the values of the derivatives of the psi functions.
#
# Constraint:
# a previous call to loadnls2(psi="model.o") is required
# and the model should be explicitly defined (no odes)
# -------------------------------------------------------------------------

# Initialisation de GNLControle en ce qui concerne les messages
# -------------------------------------------------------------
check <-  options()$check
warn <-  options()$warn
.C("initcrolenls2",  as.integer(check), as.integer(warn))

# Verification 
# -------------
RetVerif <- verifPsinls2(file=file, ppsi=ppsi, varpsi=varpsi, pbispsi=pbispsi)
if (is.null(RetVerif)) return(NULL)
	
# Creation des valeurs de varpsi:
# ------------------------------
if (!is.null(varpsi))
  {
  nbl <-  nrow(RetVerif$Varpsi)
  nbc <- ncol(RetVerif$Varpsi)
  if (!is.null(dimnames(varpsi)))
    labelrow <- dimnames(varpsi)[[1]]
  else
    labelrow <- NULL
  # on met les varpsi dans Donnees.XObsT:
  .C("crVarPsinls2", as.double(RetVerif$Varpsi),
              n=as.integer(nbl),
              m=as.integer(nbc))
  }
else
  {
  labelrow <- RetVerif$NomPsi
  nbl <-  RetVerif$NbPsi
  nbc <- 0
  }

# Creation de la trace 
# ---------------------------------
.C("crTracenls2")

# APPEL DU CALCUL
# ------------
le <- 0
ie <- 0
NbPpsi <- length(RetVerif$Ppsi)
NbPbispsi <- length(RetVerif$Pbispsi)
psi <- vector(mode="double", length=nbl)
dpsi <- vector(mode="double", length=(nbl * NbPpsi))

Ret <- .C("calcpsinls2", 
   pact=as.integer(NbPpsi),
   NbPbispsi=as.integer(NbPbispsi),
   nbl=as.integer(nbl), nbc=as.integer(nbc),
   Ppsi=as.double(RetVerif$Ppsi),
   Pbispsi=as.double(RetVerif$Pbispsi),
   psi=as.double(psi), dpsi=as.double(dpsi),
   le=as.integer(le), ie=as.integer(ie))

# Desallouer les structures C creees:
# ----------------------------------
if (!is.null(varpsi))
  .C("delPsinls2")
.C("DetruTrace")


if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function psi", 
   "the function v",
   "the derivatives of psi",
   "the derivatives of v against the ppsi parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the ppsi parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")

  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"
  warning(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  return(NULL)	
  }


# Transform dpsi into a matrix
# --------------------------

if(all(Ret$dpsi ==0)) Ret$dpsi  <- NA
else Ret$dpsi <- matrix(Ret$dpsi, ncol=NbPpsi, byrow=T,
          dimnames=list(labelrow, names(RetVerif$Ppsi)))

if(all(Ret$psi==0)) Ret$psi  <- NA
else names(Ret$psi) <- labelrow

return(list(psi=Ret$psi, d.psi=Ret$dpsi))
}
# ----------------------------------------
# ----------- end function calcpsinls2 ----------
# ----------------------------------------

