# : ### FICHIER coef.nls2.s ###
coef.nls2<-
function(nls2.object)
{
# ------------------------------------------
# extraire les valeurs estimees des Theta et eventuellement des Beta
# et le std.error de la derniere etape disponible
# d'un nls2.object
# On renvoie aussi, mais sans que print.coef l'ecrive :
# le code, le message, l'as.var et sigma2 
# ------------------------------------------
coef.object  <-  list(call=match.call())
class(coef.object) <- "coef.nls2"

if (!is.null(nls2.object$step3))
  {
  coef.object$theta <- nls2.object$step3$theta
  coef.object$beta <- nls2.object$step3$beta
  coef.object$sigma2 <- nls2.object$step3$sigma2
  coef.object$code <- nls2.object$step3$code
  coef.object$message <- nls2.object$step3$message

# on remplace les elements de as.var correspondant a Beta
# par leur valeur calculee a la precedente etape
# car, sinon, std.error est NA
if (!is.null(nls2.object$step3$as.var) &&
 !all(is.na(nls2.object$step3$as.var)) &&
    !all(is.na(nls2.object$step2$as.var)))
    {
    coef.object$as.var  <-  nls2.object$step3$as.var
    diago <- diag(nls2.object$step3$as.var)
    which <-  (1:length(diago))[is.na(diago)]
    diag2  <-  diag(nls2.object$step2$as.var)
    diago  <-  replace(diago, which, diag2[which])
    for (i in nrow(coef.object$as.var))
      coef.object$as.var[i,i]  <-  diago[i]
    coef.object$std.error <-sqrt(diago)
    names(coef.object$std.error) <-  dimnames(nls2.object$step2$as.var)[[1]]
    }
    
} # fin step3  
else
  {
    # step3 null
if (!is.null(nls2.object$step2))
  {
    # step3 nul et step 2 non null
  coef.object$theta <- nls2.object$step2$theta
  coef.object$beta <- nls2.object$step2$beta
  coef.object$sigma2 <- nls2.object$step2$sigma2
  coef.object$code <- nls2.object$step2$code
  coef.object$message <- nls2.object$step2$message

# on remplace les elements de as.var correspondant a Theta
# par leur valeur calculee a la precedente etape
# car, sinon, std.error est NA
  if (!is.null(nls2.object$step2$as.var) &&
      !all(is.na(nls2.object$step2$as.var)) &&
      !all(is.na(nls2.object$step1$as.var)))
    {
    coef.object$as.var  <-  nls2.object$step2$as.var
    diago <- diag(nls2.object$step2$as.var)
    which <-  (1:length(diago))[is.na(diago)]
    diag1  <-  diag(nls2.object$step1$as.var)
    diago  <-  replace(diago, which, diag1[which])
    for (i in nrow(coef.object$as.var))
      coef.object$as.var[i,i]  <-  diago[i]
    coef.object$std.error <-sqrt(diago)
    names(coef.object$std.error) <-  dimnames(nls2.object$step1$as.var)[[1]]
    }
} # step3 nul et step 2 non null
else
  {
   # step3 nul et step 2 null
    if (!is.null(nls2.object$step1$theta))
      {
       # step3 nul et step 2 null et step 1 non null
coef.object$theta <- nls2.object$step1$theta
coef.object$beta <- nls2.object$step1$beta
coef.object$sigma2 <- nls2.object$step1$sigma2
coef.object$code <- nls2.object$step1$code
coef.object$message <- nls2.object$step1$message
if (!is.null(nls2.object$step1$as.var) &&
   !all(is.na(nls2.object$step1$as.var)))
  {
    coef.object$as.var  <-  nls2.object$step1$as.var
  coef.object$std.error<-sqrt(diag(nls2.object$step1$as.var))
  names(coef.object$std.error) <-  dimnames(nls2.object$step1$as.var)[[1]]
  }
} # fin step3 nul et step 2 null et step 1 non null
    else
      {
        # step3 nul et step 2 null et step 1 null
  coef.object$theta <- nls2.object$theta
  coef.object$sigma2 <- nls2.object$sigma2
  coef.object$code <- nls2.object$code
  coef.object$message <- nls2.object$message
  if (!is.null(nls2.object$beta) && !all(is.na(nls2.object$beta)))
    {
    coef.object$beta <- nls2.object$beta
    }
  
  if (!is.null(nls2.object$as.var) &&
      !all(is.na(nls2.object$as.var)))
    {
    coef.object$as.var  <-  nls2.object$as.var
    coef.object$std.error <-sqrt(diag(nls2.object$as.var))
    names(coef.object$std.error) <-  dimnames(nls2.object$as.var)[[1]]
    }
  }
}
}
return(coef.object)

}
