# : ### FICHIER confidence.nls2.s ###
confidence <- function(x, ...)
  UseMethod("confidence")

confidence.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }
	
conflike <- function(x, ...)
  UseMethod("conflike")

conflike.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

	
# ------------------------------------------------------------------------
# quelparnls2: appele par conflike
# Retourne :
# - is.theta=T ou F
# - indp :  l'indice
# - namep:  le nom
# En entree, parameter est entier ou char
# ------------------------------------------------------------------------

quelparnls2 <- function(parameter, theta, beta)
{

is.theta  <- TRUE
if (is.null(theta))
  stop("The nls2.object should contain the component 'theta'")

if (is.numeric(parameter))
  {
  #  numero d'ordre
  if (parameter > (length(theta)+length(beta) ))
     {
     warning(paste("The parameter", parameter,"does not exist"))
     return(NULL)
     }

  if (parameter > length(theta))
    {
    # il s'agit d'un parametre de la variance
    is.theta  <- FALSE
    indp <-  parameter - length(theta)
    namep  <- names(beta)[indp]
    }
  else
    {
    # il s'agit d'un parametre de la regression
    indp <- parameter
    namep  <- names(theta)[indp]
    }
  }
else
  {
  #  le nom
  namep <-  parameter
  if (any(names(theta)==parameter))
    {
    # il s'agit d'un parametre de la regression
    indp <- 1
    while (parameter != names(theta)[indp]) indp <- indp+1
    }
  else
    {
    if (!any(names(beta)==parameter))
       {
       warning(paste("The parameter", parameter,"does not exist"))
       return(NULL)
       }
    is.theta  <-  FALSE
    # il s'agit d'un parametre de la variance
    indp <- 1
    while (parameter != names(beta)[indp]) indp <- indp+1
    }
  }
return(list(indp=indp, namep=namep, is.theta=is.theta))
}
# ------------------ fin fonction quelparnls2 ------------------------------

# ------------------------------------------------------------------
# calcSlnls2
# Appele par dessusnls2, dessousnls2, chercheepsnls2, cherchegrnls2
# Calcule le loglikehood-ratio en 1 point:
# On fixe le parameter a la valeur du point, et on appelle nls2
# pour estimer les autres
# Puis, on calcule le ratio:
#    ntuples * (RetC$loglik-loglik)
# ------------------------------------------------------------------
 calcSlnls2 <- function(
         p.value, loglik, RetQ, ntuples, data, model,context, method)
{

  if (RetQ$is.theta)
    {
    model$eq.theta[RetQ$indp] <-  p.value
    context$theta.start[RetQ$indp] <-  p.value
    }
  else
    {
    model$eq.beta[RetQ$indp] <-  p.value
    context$beta.start[RetQ$indp] <-  p.value
    }

  nll1<-nls2(data, model, context, method=method,
                    control=list(freq=0))
  if (nll1$code!=0)
    {
    warning(paste(
"Problem in estimating the parameters when the parameter", RetQ$namep,
"is set to", p.value,"", "Code:", nll1$code, ""))
    warning(nll1$message)
    Sl<-NaN
    }
  else
    {
    context$theta.start<-nll1$theta
    if (!is.null(context$beta.start))
      context$beta.start<-nll1$beta
    Sl<-ntuples * (nll1$loglik-loglik)
    }
return(Sl)
}

# -------------- fin de calcSl ----------------------------------

# ---------------------------------------------------------
# dessousnls2:
# Appele par chercheepsnls2
# Quand cette fonction est appelee, le ratio
# Sl est au-dessous du x2 au point p.value
# On sort quand on a atteint la precision ou que le ratio
# est passe en-dessus du x2
# ---------------------------------------------------------
dessousnls2 <- function(x2,  div, eps,signe,
            p.value, Sl.value, pas,
            loglik, RetQ, ntuples, data, model,context, method,
            n.values)
{
Retour <- list(p.value=p.value, Sl.value=Sl.value, pas=pas, fini=F, n.values=n.values)

while (Retour$Sl.value < x2)
  {
  if (div) Retour$pas  <-  Retour$pas/2
  # reculer de thetahat:
  Retour$p.value  <-  Retour$p.value -(signe*pas)
  Retour$Sl.value  <-   calcSlnls2(Retour$p.value, loglik, RetQ, ntuples,
               data, model,context, method)
  Retour$n.values  <- Retour$n.values+1

  if (!is.na(Retour$Sl.value) && abs(Retour$Sl.value - x2) <= eps)
    {
    Retour$fini <- T
    return(Retour)
    } 
  }
return(Retour)
}
# -----------fin de dessousnls2 ------------------------------



# ---------------------------------------------------------
# dessusnls2:
# Appele par chercheepsnls2
# Idem que dessousnls2 quand le ratio
# Sl est au-dessus du x2 au point p.value
# ---------------------------------------------------------
dessusnls2 <- function(x2,  div, eps,signe,
            p.value, Sl.value, pas,
            loglik, RetQ, ntuples, data, model,context, method,
            n.values)
{
Retour <- list(p.value=p.value, 
            Sl.value=Sl.value, pas=pas, fini=F, n.values=n.values)

while (Retour$Sl.value > x2)
  {
  if (div) Retour$pas  <-  Retour$pas/2
  # approcher de thetahat:
  Retour$p.value  <-  Retour$p.value +(signe*pas)
  Retour$Sl.value  <-   calcSlnls2(Retour$p.value, loglik, RetQ, ntuples,
               data, model,context, method)
  Retour$n.values  <- Retour$n.values+1

  if (!is.na(Retour$Sl.value) && abs(Retour$Sl.value - x2) <= eps)
    {
    Retour$fini <- T
    return(Retour)
    } 
  }
return(Retour)
}
# -----------fin de dessusnls2 ------------------------------

#-------------------------------------------------------------
# cbornenls2
# Appele par chercheeps
# calcul d'une borne inf ou bien sup de l'intervalle likelihood
# ---------------------------------------------------------
cbornenls2 <- function(x2, eps, signe, Ret,
                   loglik,method, RetQ, ntuples, data, model,context)

{
  div <- F
  Ret$Sl.value<-
      calcSlnls2(Ret$p.value, loglik,RetQ, ntuples,
            data, model,context, method)
   Ret$n.values<- Ret$n.values+1

   while (is.na(Ret$Sl.value) )
    {
    # on ne peut pas calculer : on s'approche de thetahat
    Ret$p.value  <-  Ret$p.value +(signe*Ret$pas)
    Ret$Sl.value<-
       calcSlnls2(Ret$p.value, loglik,RetQ, ntuples,
            data, model,context, method)
     Ret$n.values<- Ret$n.values+1
    }# fin while (is.na(Ret$Sl.value) )


  if ( abs(Ret$Sl.value - x2) > eps)
    {
    if (Ret$Sl.value > x2)
      {
      # on est au-dessus du critere
      Ret <- 
        dessusnls2(x2,  div, eps,signe,
             Ret$p.value, Ret$Sl.value, Ret$pas,
            loglik, RetQ, ntuples, data, model,context, method,
            Ret$n.values)
      div <- T
      while (!Ret$fini)
        {
        Ret <-  
           dessousnls2(x2,  div, eps,signe,
             Ret$p.value, Ret$Sl.value, Ret$pas,
            loglik, RetQ, ntuples, data, model,context, method,
            Ret$n.values)
        if (!Ret$fini)
          Ret <- 
            dessusnls2(x2,  div, eps,signe,
             Ret$p.value, Ret$Sl.value, Ret$pas,
            loglik, RetQ, ntuples, data, model,context, method,
            Ret$n.values)
        } # fin du while
      } # fin du      if (Ret$Sl.value > x2) 
    else
      {
      # on est au-dessous du critere
      Ret <- 
        dessousnls2(x2,  div, eps,signe,
             Ret$p.value, Ret$Sl.value, Ret$pas,
            loglik, RetQ, ntuples, data, model,context, method,
            Ret$n.values)
      div <- T
      while (!Ret$fini)
        {
        Ret <-  
           dessusnls2(x2,  div, eps,signe,
             Ret$p.value, Ret$Sl.value, Ret$pas,
            loglik, RetQ, ntuples, data, model,context, method,
            Ret$n.values)
        if (!Ret$fini)
          Ret <- 
            dessousnls2(x2,  div, eps,signe,
             Ret$p.value, Ret$Sl.value, Ret$pas,
            loglik, RetQ, ntuples, data, model,context, method,
            Ret$n.values)
        } # fin du while!Ret$fini
	
      } # fin du cas (Ret$Sl.value > x2)
	    } #fin du  if (abs(Ret$Sl.value-x2) > eps) 
return(Ret)
}


# ----------------- fin de cbornenls2-----------------------------

# ---------------------------------------------------------
# chercheepsnls2
# Recherche les points d'intersection entre la courbe des
# ratios et le x2 a eps pres
# appele par conflike
# ---------------------------------------------------------
chercheepsnls2 <- function(x2, eps, extends, pas,
                       theta, beta,
                       loglik, method,RetQ, ntuples, data, model, context)

{
Retinf <-  list(p.value=(theta[RetQ$indp]-extends),  
             Sl.value=NaN, pas=pas, fini=F, n.values=0)
# Cherche a gauche (borne inf de l'intervalle de confiance)
signe  <-  +1
Retinf <- cbornenls2(x2, eps, signe, Retinf,
                   loglik,method, RetQ, ntuples, data, model,context)



# Cherche a droite:
# idem mais on part de thetahat+extends et on met signe a -1
# pour changer le sens de "approchenls2" et "recule" par rapport
# a  thetahat

Retsup <-  list(p.value=(theta[RetQ$indp]+extends),  
             Sl.value=NaN, pas=pas, fini=F, n.values=0)
signe  <-  -1
Retsup <- cbornenls2(x2, eps, signe, Retsup,
                   loglik,method, RetQ, ntuples, data, model,context)


like.conf.int <- matrix(c(Retinf$p.value,Retsup$p.value ), nrow=1,
    dimnames=list(RetQ$namep, c("lower", "upper") ))
like.statistics <- matrix(c(Retinf$Sl.value,Retsup$Sl.value ), nrow=1,
    dimnames=list(RetQ$namep, c("lower", "upper") ))
like.n.values <-  matrix(c(Retinf$n.values,Retsup$n.values ), nrow=1,
    dimnames=list(RetQ$namep, c("lower", "upper") ))

return(list(like.n.values=like.n.values,
            like.statistics=like.statistics, 
            like.conf.int=like.conf.int))

}

# ----------- fin de  chercheepsnls2 ------------------------



# ---------------------------------------------------------
# cherchegrnls2
# Recherche le loglikelihood intervalle sur une grille de points equidistants
# appele par conflike
# ---------------------------------------------------------
cherchegrnls2 <- function( x2,n.values, extends, theta, beta,
                       loglik, method,RetQ, ntuples, data, model, context)

{

# On calcule a gauche de la val estimee du param
# celui-ci compris
if (RetQ$is.theta)
  l1<-matrix(
        seq(theta[RetQ$indp]-extends,
        theta[RetQ$indp], 
        length = (n.values+1)))
else
  l1<-matrix(
        seq(beta[RetQ$indp]-extends,
        beta[RetQ$indp], 
        length = (n.values+1)))

llr1 <- apply(l1,1,calcSlnls2, loglik, RetQ, ntuples,data, model,context, method)
  
p.values<-l1
like.statistics<-llr1

# On calcule a droite de la val estimee du param
# celui-ci non compris
if (RetQ$is.theta)
  l1<-matrix(
        seq(theta[RetQ$indp], 
        theta[RetQ$indp]+extends,
        length = (n.values+1)))
else
  l1<-matrix(
        seq(beta[RetQ$indp], 
        beta[RetQ$indp]+extends,
        length = (n.values+1)))
# On elimine le 1ier element: on l'a deja vu
l1m <- matrix(l1[2:(n.values+1)])

# On reinitialise les val init
context$theta.start <-  theta
if (!is.null(beta))
  context$beta.start <-  beta

llr1 <- apply(l1m,1,calcSlnls2, loglik, RetQ, ntuples,data, model,context, method)


# On reunit les resultats
p.values<-c(p.values,l1[2:(n.values+1)])
like.statistics<-c(like.statistics,llr1)

# On les met dans l'ordre croissant des valeurs essayees
porder <- order(p.values)
p.values<- p.values[porder]
like.statistics<-like.statistics[porder]

# On cherche les valeurs les plus proches du chi2

iinf <- isup <- 0

for (i in 2:(2*n.values+1))
  {

  if (!is.na(like.statistics[i-1]) && !is.na(like.statistics[i]) &&
    (like.statistics[i-1] >= x2) && (like.statistics[i] < x2))
    iinf <- i
  if (!is.na(like.statistics[i-1]) && !is.na(like.statistics[i]) &&
     (like.statistics[i-1] < x2) && (like.statistics[i] >= x2))
    isup <- i
  }
like.conf.int <- matrix(c(NaN, NaN), nrow=1,
    dimnames=list(RetQ$namep, c("lower", "upper") ))
if ((iinf==0) || (isup==0))
  {
  warning("Increase 'extends': the search interval is too small")
  }
if (iinf !=0)
  {
  # On approxime entre les 2 valeurs ou se trouve le chi2
  like.conf.int[1,"lower"]  <- 
     approx(like.statistics[(iinf-1):iinf], p.values[(iinf-1):iinf], 
                    x2)$y       
  }
if (isup !=0)
  {
  like.conf.int[1,"upper"]  <- 
     approx(like.statistics[(isup-1):isup], p.values[(isup-1):isup], 
                    x2)$y
  }	
return(list(
            p.values=p.values, 
            like.statistics=like.statistics, 
            like.conf.int=like.conf.int))
}
# ------------- fin de cherchegrnls2--------------------------------------




# ------------------------------------------------------------------------
# conflike.nls2
# Appelee directement par l'usager ou via confidence
# Calcule le likelihood ratio based confidence interval
# pour UN  parametre
# Par defaut, on cherche les points d'intersection
# entre la courbe Sl et le x2 a eps pres
# Si n.values non null (valeur conseillee par ej:19),
# on calcule Sl sur une grille de points equidistants
# ------------------------------------------------------------------------

conflike.nls2 <- function(nls2.object,
	parameter=NULL, n.values=NULL, eps=0.01,
	extends=3* coef(nls2.object)$std.error[parameter],
        step=extends/10,
        conf.level=0.95)
{
# n.values= nbre de valeurs explorees de chaque cote de thetahat
# celui-ci non compris
	
# On impose un estimateur Maximum Likelihood non alterne
if (nls2.object$nb.steps!=1)
  {
  warning(
"Function valid only when the estimating method is not an alternate method")
  return(NULL)
  }
if ((nls2.object$method !="MLTB") && (nls2.object$method !="MLT"))
  {
  warning(
"Function valid only when the estimating method is a Maximum Likelihood method")
   return(NULL)
  }

# Il faut as.var dans le nls2.object ou bien extends

if (is.null(extends) || any(is.na (extends)))
  {
  warning("Component 'as.var' missing in the nls2.object: Set a value to the argument 'extends'")
  return(NULL)
  }					
		
	
# Determiner les data
if (is.null(nls2.object$data.sv))
  data <- plsplitoutnls2(nls2.object)
else
  data <- nls2.object$data.sv
ntuples <-  dim(data)[1]

# Determiner le parametre voulu
RetQ <-  quelparnls2(parameter, nls2.object$theta, nls2.object$beta)
if (is.null(RetQ)) return(RetQ)

# Recreer le context: on ne peut pas utiliser le meme
# car il faut rajouter les val init des param 
context <-  nls2.object$stat.ctx
context$theta.start <-  nls2.object$theta
if (!is.null(nls2.object$beta))
  context$beta.start <-  nls2.object$beta

# Creer le modele: on y ajoutera une contrainte d'egalite numerique
# sur le parametre a etudier
model <-  nls2.object$model

if (RetQ$is.theta && is.null(model$eq.theta))
  model$eq.theta <- rep(NaN, length(nls2.object$theta))
if ( !RetQ$is.theta && is.null(model$eq.beta))
  model$eq.beta <- rep(NaN, length(nls2.object$beta))
x2 <-  qchisq(conf.level, 1)

if (!is.null(n.values))
  {
    if (is.null(nls2.object$loglik))
      stop("The nls2.object should contain the component 'loglik'")
    
  RetInt <- cherchegrnls2(x2, n.values, extends, 
                       nls2.object$theta, nls2.object$beta, nls2.object$loglik, 
                        nls2.object$method, RetQ, ntuples, data, model, context)

  } # fin eps NULL
else
  {
  RetInt  <-  chercheepsnls2(x2, eps, extends, step, 
                       nls2.object$theta, nls2.object$beta,nls2.object$loglik, 
                       nls2.object$method, RetQ, ntuples, data, model, context)
  }

RetInt$call <-  match.call()

return(RetInt)

}
# ------------- fin de conflike.nls2--------------------------------------



# ------------------------------------------------------------------------
 confidence.nls2 <- function(nls2.object, conf.level=0.95,
                    file=NULL,
                    pbispsi= c(nls2.object$model$gamf,nls2.object$model$gamv),
                    varpsi=NULL,
	parameter=NULL, n.values=NULL,
        eps=0.01,
	extends=3* coef(nls2.object)$std.error[parameter],
        step=extends/10)
{
# -------------------------------------------------------------------------
# function that calculates confidence intervals
# for functions of parameters of a given nls2.object or
# for the parameters themselves
# When parameter is  not null, returns the confidence interval
# based on the likelihood for 'parameter' only
# -------------------------------------------------------------------------
	if (!is.numeric(conf.level) || (length(conf.level) >1) ||
     (conf.level <=0) || (conf.level >=1))
  stop("The argument 'conf.level' must be a value between 0 and 1")

# parameter non NULL: likelihood confidence interval
if (!is.null(parameter))
  return(conflike.nls2(nls2.object,
                  parameter, n.values, eps,extends,step, conf.level))

# autres intervalles
cc <- examwaldnls2(nls2.object)

if (!is.null(file))
  RetW <-  wald(nls2.object, file, pbispsi, varpsi)
else
  {
  if (!is.null(dim(cc$as.var)))
	      stderror <-  sqrt(diag(cc$as.var))
	else
	      	stderror <-  sqrt(cc$as.var)
  RetW <-  list(std.error=stderror, var.psi=cc$as.var, psi= cc$pact)
  }
if (is.null(RetW)) {
	stop("Numerical problem in 'wald.nls2'")
		}
	
# Determiner le nombre de parametres actifs:
p.act <- length(cc$pact)

# Determiner le nombre total d'observations
if (is.null(nls2.object$replications))
  stop("The nls2.object should contain the component 'replications'")

n.obs <-  sum(nls2.object$replications)
df <-  n.obs - p.act

level <-  (1-conf.level)/2
u1a <-  qnorm(1-level, 0,1)
t1a <- qt(1-level, df)



	if (!is.null(dim(RetW$var.psi)))
   dvar <-  sqrt(diag(RetW$var.psi))
else 
   	dvar <-  sqrt(RetW$var.psi)
dvart <-  dvar * sqrt( n.obs / (n.obs-p.act))

lower <-   RetW$psi - (dvar*u1a)
upper <-   RetW$psi + (dvar*u1a)
normal.conf.int <- matrix(c(lower, upper),
  ncol=2, dimnames=list(names(RetW$psi), c("lower","upper")))
lower <-   RetW$psi - (dvart*t1a)
upper <-   RetW$psi + (dvart*t1a)
student.conf.int <- matrix(c(lower, upper),
  ncol=2, dimnames=list(names(RetW$psi), c("lower","upper")))
if (nls2.object$model$vari.type != "CST")
  {
  warning(paste(
"A confidence interval based on the quantiles of the Student's t distribution is calculated, but the variances are heterodastic (model$vari.type=",nls2.object$model$vari.type,")", sep=""))
  }

	
if (!is.null(RetW$statistic))
  {
  RetW$wald.statistic  <-  RetW$statistic
  RetW$statistic  <- NULL
  }

RetW$normal.conf.int  <-  normal.conf.int
RetW$student.conf.int  <- student.conf.int
RetW$call <- match.call()
return(RetW)
}

# ----------------------------------------
# ----------- end function confidence.nls2 ----------
# ----------------------------------------
