# : ### FICHIER pldnls2.s ###
pldnls2<-function(data,response.name, X.names,
         smooth=F,
         labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)
{
#***************************************************************************
# FONCTION:
# representation graphique des donnees:
# graphique de la variable
# reponse en fonction  des variables explicatives.
#
# data est un data.frame contenant eventuellement les "parameters"
#    curve et weight
#    Lorsque curve existe, en plus du graphique toutes courbes confondues, 
#    ou les points sont identifies par l'indice de courbe,
#    on obtient un graphique par courbe, les points etant identifies
#    par leurs identificateurs (c.a.d les labels du vecteur response).
#    Lorsqu'il y a plusieurs courbes et plusieurs variables,
#    on obtient, pour chaque variable, un graphique toutes courbes confondues,
#    les points etant identifies par l'indice de courbe,
#    et, pour chaque courbe, un graphique par variable les points etant
#    identifies par leurs identificateurs.
#
# ARGUMENTS:
# data: un data.frame
# response.name: nom du vecteur de data qui contient la variable reponse
# X.names: noms des vecteurs de data qui contiennent les variables independantes
# smooth: T si on veut un lissage des points (cf fonction S: lowess)
# title: titre des graphiques
# figs:
#  Quand il y a plusieurs courbes ou plusieurs variables,
#  plusieurs graphes sont traces; ceux-ci sont disposes sur la page 
#  selon la disposition indiquee dans figs: voir la fonction S "split.screen"
#  p 577 nouveau manuel et "par", page 528 ancien manuel S)
#  Exemple: figs=c(3,2) indique qu'on veut 3 graphes sur la longueur de l'ecran
#                        et 2 sur la largeur.
# ask.pause: TRUE si on veut qu'il y ait une pause entre chaque graphe
#     (fonctionnement interactif)
# ask.modify: TRUE si on veut rajouter ou supprimer des choses sur chaque graphe
#     (fonctionnement interactif): on demande de taper une expression valide:
#      par exemple, legend
# ...: n'importe quel autre argument reconnu par la fonction "plot"
# a l'exception de:
#      main, xlab,ylab,type,sub
#***************************************************************************

if(is.numeric(data))
     data <- sys.frame(data)


# Verification des arguments
# et determination des divers elements constituant les donnees:
# --------------------------------------------------------
z <- plsplitdnls2(data, response.name, X.names, labels=labels)
# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", length(z$y))
else
  {
  if (length(z$labels) != length(z$y))
    stop("\n The length of the label vector does not match \n")
  }

if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------
# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

# parametres qui ne servent pas ici:
xfit <- yfit <- curvefit <- NULL
		
# Appel de la fonction qui gere les graphiques:
plnls2(z$dmat,  z$y, id=z$labels, z$curve,
	xfit, yfit, curvefit,
       title, z$va.names, response.name,
       jump=F, smooth=smooth,  ask.pause=ask.pause, ask.modify=ask.modify, figs,...)

# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
