# : ### FICHIER plfit.nls2.s ###
plfit <- function(x, ...)
  UseMethod("plfit")

plfit.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plfit.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         wanted=list(O.F=T, X.OF=T),
         smooth=F, n.fitted=0,
	 labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)

{
#***************************************************************************
# FONCTION:
# representations graphiques des valeurs observees
# de l'esperance en fonction des ajustees
# et, s'il n'y a qu'une variable explicative,
# des valeurs observees et ajustees de l'esperance en fonction des
# valeurs de la variable explicative
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# O.F: valeurs observees en fonction des ajustees
# X.OF: valeurs observees et ajustees en fonction de la variable explicative
#     valable que si une seule variable
# smooth: T si on veut un lissage des points (cf fonction S: lowess)
# labels, title, figs, ask, ... :voir fonction 'pld'
#***************************************************************************
# Verification des arguments:
# --------------------------
if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step", 
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match\n "))

if ( !is.numeric(n.fitted) || (n.fitted<0) ||
	( (n.fitted>0) &&  (n.fitted<2)))
  stop(paste(
"Argument 'n.fitted',", n.fitted,
"must be an integer greater than 2\n"))
	
# Verification des donnees et
# determination des divers elements constituant les donnees:
# --------------------------------------------------------
  data <- plsplitoutnls2(nls2.object)

z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=labels)
# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls

# Mise en dimension n des ajustes:
# --------------------------------
# Les valeurs observees seront eventuellement lissees
# par une ligne pointillee, les ajustees seront toujours lissees
# par une ligne pleine
if (missing(step))
  {
   fittedf <-  fitted.nls2(nls2.object)$response
   theta <-  coef(nls2.object)$theta
 }
else
  {	
  fittedf <-  nls2.object[[paste("step",step,sep="")]]$response
  theta <- nls2.object[[paste("step",step,sep="")]]$theta
  }
		  	
if ( is.null(fittedf) || !is.numeric(fittedf) ||
    is.null(theta) || is.null(nls2.object$replications))
  stop("The nls2.object should contain the fitted values of the response, the estimated values of the parameters and the vector of replications")

fittedf <- rep(fittedf, nls2.object$replications)


n <- length(fittedf)
if (n != length(z$y))
  stop("\nThe 'nls2.object' and the 'data' does not match\n")


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", n)
else
  {
  if (length(z$labels) != n)
    stop("\n The length of the label vector does not match\n ")
  }


if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

if (!is.null(wanted$O.F) && wanted$O.F)
  {
  cat("\nPlots asked by the O.F option\n",fill=T)
  # Trace des observes en fonction des ajustes:
  plnls2(xmat=as.matrix(z$y),  y=fittedf, id=z$labels, curvey=z$curve,
	 xfit=NULL, yfit=NULL, curvefit=NULL,
           title,
           paste("observed values of ", z$response.name),
           "fitted values of the regression function",
           jump=F,
           smooth=smooth,
           ask.pause, ask.modify,
           figs, ...)
  }

if(!is.null(wanted$X.OF) && wanted$X.OF)
  {
  cat("\nPlots asked by the X.OF option\n",fill=T)
  if (ncol(z$dmat)>1)
    {
    warning("\nThe plot of the fitted values of the regression function cannot be asked when there are several independent variables\n")
    }
  else
    {
     # une seule variable: trace des valeurs observees et estimees de
     # de l'esperance en fonction de la variable:
    if (n.fitted>1)
      {
      # on genere de nouveaux points de calcul
       RetFit <-  cfitnls2(nls2.object,z,n.fitted,
	  theta,   beta=NULL, sigma2=NULL, calc.f=T, calc.v=F)
      xfit <- RetFit$xfit			
      curvefit <- RetFit$curvefit			
      yfit <- RetFit$yfit	
      } # fin de generation de nouveaux points
    else
      {
      yfit <- fittedf
      xfit <- z$dmat[,1]
      curvefit <- z$curve
      }			
    plnls2(as.matrix(z$dmat[,1]), z$y, z$labels, z$curve,
	  as.matrix(xfit), yfit, curvefit,
           title,
           z$va.names[1],
           paste("observed and fitted values of ", z$response.name),
           jump=F,
           smooth=smooth,
           ask.pause, ask.modify,
           figs, ...)
    }
  }


# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}

# -----------------------------------------------------------
# cfitnls2
# Generer une grille de calcul sur l'axe de la variable independente
# (supposee unique)
# et calculer f et/ou 	v(theta,beta)*sigma2
#	(poids supposes 1 sur la grille)				
# -----------------------------------------------------------
cfitnls2 <- function(nls2.object, z,
	  n.fitted, theta, beta, sigma2,
	  calc.f, calc.v)
{
# Initialisation des sorties:
xfit <- yfit <- varfit <- curvefit <- NULL
	
# Creation des donnees de toutes les  courbes:
if (is.null(z$curve))
  z$curve <- rep("a", n.fitted)	# valeur bidon

idc <- unique(z$curve) # noms des courbes
ncurves <-  length(idc)
for (ic in idc)
  {	
  v <- (z$curve==ic)
  xfit <-  c(xfit,
	seq(from=min(z$dmat[v==TRUE ,1]),
 	              to=max(z$dmat[v==TRUE ,1]),
	              length=n.fitted))
  } # fin for (ic in idc)

RetModel <- CrArbnls2(nls2.object$model, nls2.object$ctx.integ)
if (RetModel$CasSedo)	
  .C("debutOdesnls2")	

curvefit <- rep(idc, rep(n.fitted, ncurves))
n <- length(xfit)
	
dataplot <- data.frame( xfit,
        rep(1,n),
	curves=curvefit)
# valeurs bidon pour la reponse
names(dataplot) <- c(nls2.object$X.names, nls2.object$response.name, "curves")
initplotc(dataplot,nls2.object$X.names, nls2.object$response.name)
	
k <- as.integer(0)
	
if(RetModel$CasSedo)
  {
  #  Creation du contexte d'integration:
  crCtxIntegnls2(ncurves, n, RetModel, nls2.object$integ.ctx)
#  .Fortran("initlsoda <- ")
  LgDSedo <- as.integer(0)
  RetDim <- .C("initOdesnls2",
     pbase=as.integer(RetModel$NbTheta),
     k=as.integer(k),
     LgDSedo=as.integer(LgDSedo))
  Retf <-  odesplotcnls2(n , RetModel$NbTheta,
	           length(nls2.object$model$gamf), 
 	           theta, nls2.object$model$gamf)
  } #fin cas sedo
else
  {
  # faire ce qu'a fait crCtxIntegnls2:				
  # Creation de la trace et des donnees
 .C("initCalcnls2",   k=as.integer(k))
  Retf <-    fplotcnls2(n , RetModel$NbTheta,
	           length(nls2.object$model$gamf), 
	          theta, nls2.object$model$gamf)
  } # fin cas non sedo
		
if (calc.f)
  yfit <-  c(yfit, Retf$f)

if (calc.v && RetModel$YaCalcV)
  {
  varfit <-  c(varfit,
          vplotcnls2(n , RetModel$NbTheta, RetModel$NbBeta,
	           length(nls2.object$model$gamv), 
	          theta,
	          beta,
	          nls2.object$model$gamv,
	          Retf$f, Retf$df))
  }	# fin de (calc.v && YaCalcV)

# Desallouer les structures C creees:
if (RetModel$CasSedo)
  .C("delOdesnls2")
else			
  .C("delCalcnls2")

if (calc.v)
  {		
  if (!RetModel$YaCalcV)
    varfit <- rep(sigma2, (n.fitted*ncurves))
  else	
    varfit <-  varfit * sigma2
  }	
return(list(xfit=xfit, yfit=yfit, curvefit=curvefit, varfit=varfit))
}
# --------- fin de 	cfitnls2 --------------------------------	

# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
# initplotc
# Initialise les structures internes de NL:	
#     GNLControle, la trace, les donnees
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
initplotc <- function(data, NomX, NomY)
{			

# Initialisation de GNLControle en ce qui concerne les messages
# -------------------------------------------------------------
check <-  options()$check
warn <-  options()$warn
.C("initcrolenls2",  as.integer(check), as.integer(warn))

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
# ------------------------------
.C("debutCalcnls2")
	
# Creation des donnees:
# -------------------
don <- crDatanls2(data,NomX, NomY)

invisible()
}
# ---------------- fin initplotc -------------------------------
	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
#  fplotcnls2:
#  calcule k valeurs de f et df, les x etant dans 
# la structure interne de NL:	 Data.XObs	 	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
fplotcnls2 <- function(k, NbTheta, NbGamF, Theta, GamF)
{
le <- 0
ie <- 0
f <- vector(mode="double", length=k)
df <- vector(mode="double", length=(k * NbTheta))
if(NbGamF==0)
  GamF <- 0
		
Ret <- .C("calcfnls2", 
   pbase=as.integer(NbTheta),
   nbgf=as.integer(NbGamF),
   Theta=as.double(Theta),
   GamF=as.double(GamF),
   f=as.double(f), df=as.double(df),
   le=as.integer(le), ie=as.integer(ie))
if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
	    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"

  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }
return(list(f=Ret$f, df=Ret$df)	)
	
}
# ----------------- fin de fplotcnls2 ---------------				

	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
#  vplotcnls2:
#  calcule k valeurs de v  les x etant dans 
# la structure interne de NL:	 Data.XObs	 	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
vplotcnls2 <- function(k, NbTheta, NbBeta, NbGamV,
	  Theta, Beta,  GamV, f, df)
{
if (NbGamV==0)
  GamV <- 0
if (NbBeta==0)
  Beta <- 0

			
le <- 0
ie <- 0
v <- vector(mode="double", length=k)
dtv <- vector(mode="double", length=(k * NbTheta))
dbv <- vector(mode="double", length=(k * NbBeta))
	
# Meme si NbGamF=0 et GamF=NULL, ca marche
Ret <- .C("calcvnls2", 
   pbase=as.integer(NbTheta),
   qbase=as.integer(NbBeta),
   nbgv=as.integer(NbGamV),
   Theta=as.double(Theta),
   Beta=as.double(Beta),
   GamV=as.double(GamV),
   f=as.double(f), df=as.double(df),
   v=as.double(v), dtv=as.double(dtv), dbv=as.double(dbv),	
   le=as.integer(le), ie=as.integer(ie))
				
if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
	    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"

  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }
return(list(v=Ret$v)	)
	
}
# ----------------- fin de vplotcnls2 ---------------				
	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
#  odesplotcnls2:
#  calcule k valeurs de f et df,
# quand cas sedo, les x etant dans 
# la structure interne de NL:	 Data.XObs
# les sorties etant aussi dans des structures internes	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
odesplotcnls2 <- function(k, NbTheta, NbGamF, Theta, GamF)
{
le <- 0
ie <- 0
if (is.null(GamF))
  GamF <- 0
		
Ret <- .C("callOdesnls2",
   pbase=as.integer(NbTheta),
   nbgf=as.integer(NbGamF),
   Theta=as.double(Theta),
   GamF=as.double(GamF),
   le=as.integer(le), ie=as.integer(ie))
if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
	    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"

  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }

# Recuperation de f et df:
f <- vector(mode="double", length=k)
df <- vector(mode="double", length=(k * NbTheta))
Ret <-  .C("recupfdfnls2", 
	as.integer(k), as.integer(NbTheta),
             f= as.double(f), df=as.double(df))

# Mettre sous bonne dimension f, df:
if(all(Ret$df ==0)) 
  Ret$df  <- NA	
else
  Ret$df <- matrix(Ret$df, ncol=NbTheta, byrow=T)

if(all(Ret$f==0)) Ret$f  <- NA
				
return(list(f=Ret$f, df=Ret$df)	)
	
}
# ----------------- fin de odesplotcnls2 ---------------				
				
