# : ### FICHIER plnls2.s ###
pl1vnls2<-function(x,y,id,ncurvey,
	     xfit, yfit,ncurvefit,
	     jump,
	     title, xlab,ylab, smooth, ...)
{
#***************************************************************************
# FONCTION pl1vnls2:
# representation graphique des donnees 
# d'une courbe et d'une variable en abscisse
#***************************************************************************
n <- length(x)
nfit <- length(xfit)
		
if (jump && (n<3))
  {	
  # residus(i) en fonction residus(i-1)
  warning(paste("Graph not possible: only", n, "points\n"))
  return()
  } # fin de jump

if (nfit==0)
  {
  finxfit <- 1
  debyfit <- 0
  }
else
  {
  finxfit <- nfit-jump
  debyfit <- 1+jump
  }
							
# On fait le cadre sans mettre les points:
plot(x[1:(n-jump)],y[(1+jump):n],
      xlim=c(min(x[1:(n-jump)],xfit[1:finxfit]),
	     max(x[1:(n-jump)],xfit[1:finxfit])),
      ylim=c(min(y[(1+jump):n],yfit[debyfit:nfit]),
	     max(y[(1+jump):n],yfit[debyfit:nfit])),
      main=title, xlab=xlab, ylab=ylab,type="n",...)

# Rajout de l'identificateur des lgid premiers points sur le graphe:
par(adj=.5)
text(x[1:(n-jump)] ,y[(1+jump):n], labels=id[(1+jump):n])

	
# Lissage des lgid premiers points: toujours des observes ou empiriques
# lty: type de ligne pour le lissage (voir par: 1=ligne pleine, 2=pointilles)
# si une courbe: des pointilles
# si plusieurs courbes sur le meme graphe, lty=1 a nombre de courbes
if (smooth)
  {
  if (length(ncurvey)==1)
    {
    # une courbe: des pointilles
    lines(lowess(x[1:(n-jump)], y[(1+jump):n]), lty=2)
    }
  else
    {
    # lissage par courbe
    lty <- 1
    ideb <- 1	
    for (i in ncurvey)
      {
      ifin <-  ideb+i-1
      lines(lowess(x[ideb:(ifin-jump)],y[(ideb+jump):ifin]), lty=lty)
      lty <- lty+1
      ideb <- ifin+1
      }
    }
  } # fin smooth


# Les ajustes:
if (!is.null(xfit))
  {
   # Rajouter (xfit,yfit) en joignant les points: 
   # si une courbe: 1 ligne pleine
   # si plusieurs courbes sur le meme graphe, lty=1 a nombre de courbes
  if (length(ncurvefit)==1)
    {
    # une courbe: 1 ligne pleine
    # il faut trier les points quand pas de lissage
    xg <- 	xfit[1:(nfit-jump)]
    yg <- 	yfit[(1+jump):nfit]
    ordre <-  order(xg)
    lines(xg[ordre],yg[ordre], lty=1)
    }
  else
    {
    # joindre par courbe
    ideb <- 1
    lty <- 1
    for (i in ncurvefit)
      {
      ifin <-  ideb+i-1
      xg <-  xfit[ideb:(ifin-jump)]
      ordre <-  order(xg)
      yg <- y[(ideb+jump):ifin]
      lines(xg[ordre],yg[ordre], lty=lty)
      lty <- lty+1
      ideb <- ifin+1
      }
    } # fin plusieurs courbes
  } # fin (lgid < lgy)

invisible()
}
# ------------ fin fonction pl1vnls2 ------------------------#


# ---------------plmodifynls2 ------------------------------------
#  FONCTION plmodifynls2:
# gere la possibilite pour l'usager de taper une S-expression pour modifier
# le dession (ou faire autre chose)
# -----------------------------------------------------------------------
plmodifynls2 <- function()
     {
      # on ote l'option "error" pour que l'utilisateur puisse recommencer
      # a taper s'il fait une erreur:
#      restart(TRUE)
      oldopts  <- options(error=NULL) # on ote la creation du dump.calls
      on.exit(options(oldopts))
      while(TRUE)
        {
        cat("\nHit an S-expression or 'return'\n",fill=T)
        l <- scan(n=1, what="character", sep="\n")
        if (length(l)==0)
          break
        eval(parse(text=l))
        }
      }
# -------------- fin fonction plmodifynls2  ------------ #




pl1cnls2<-function(xmat,y, id,  ncurvey,
	         xfit, yfit, ncurvefit,
	          jump,
                  title, xlab, ylab,
                 smooth,   ask.pause, ask.modify,
                 boucle, iscreen,nbscreens, figs, ...)
{
#***************************************************************************
# FONCTION pl1cnls2:
# representation graphique 
# de une ou plusieurs variables 
# pour une courbe (ou plusieurs sur le meme graphe)
# ARGUMENTS: 
# voir fonction 'plnls2'
# boucle: TRUE si cette fonction est appelee dans une boucle
# et qu'il ne faut demander a l'utilisateur s'il vaut effacer le graphe
# que si l'ecran est plein et non pas apres chaque graphe
# iscreen: indice du graphe courant (sert quand plusieurs graphes sur l'ecran)
#***************************************************************************

  for (i in seq(1:length(xlab)))
    {
    screen(nbscreens[iscreen])
    pl1vnls2(xmat[,i],  y, id, ncurvey,
	     xfit, yfit,ncurvefit, jump,
	     title, xlab=xlab[i], ylab=ylab, smooth, ...)

    if (ask.modify)
      {
      plmodifynls2()
      }
    iscreen  <-  iscreen+1

    if  (iscreen > length(nbscreens))
      {
      if (ask.pause)
        {
        cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
        z <- scan(n=1,what="any")
        }
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
       split.screen(figs)
      iscreen <- 1
      }
    } # fin boucle sur length(xvar)

# si iscreen=1, c'est que ca a deja ete demande dans la boucle
if ( (iscreen !=1) && ask.pause && !boucle )
  {
  cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
  z <- scan(n=1,what="any")
  }

return(iscreen)

}
# ------------ fin fonction pl1cnls2 ------------------------#


plnls2<-function(xmat,y, id, curvey,
	         xfit, yfit, curvefit,
                 title, xlab, ylab,
                 jump, smooth,  ask.pause, ask.modify,
                 figs, ...)
{
#***************************************************************************
# FONCTION plnls2:
# representation graphique des donnees 
# de une ou plusieurs courbes en fonction de une ou plusieurs variables
# ARGUMENTS:
# xmat: matrice des valeurs en abscisse
# y: vecteurs des valeurs en ordonnee (points ou lisses si smooth)
# id: vecteur de chaines de caracteres
#       correspondant aux identificateurs des points
# curvey:  vecteur de chaines de caracteres
#       correspondant aux identificateurs de courbe des points (xmat,y)
# xfit, yfit, curvefit:	 eventuellement, les points a joindre par une ligne
# 	
# title: titre des graphiques
# xlab: chaine de caracteres ou vecteur de chaines de caracteres
#       correspondant aux labels en abscisse
#       si ncol(xmat)>1, length(xlab)=ncol(xmat)
# ylab: chaine de caracteres correspondant au label en ordonnee
# Si jump, on ote le 1ier 'y' et le 1ier 'id' et le dernier 'x'
# (jump=T quand on veut le graphe des residus(i) en fonction des residus(i-1)
# smooth: si on veut un lissage de certains points (voir fonction 'pl1vnls2')
# figs, ask.pause,  ask.modify,... :voir fonction 'pld'
#***************************************************************************

# Quand il y a plusieurs variables, on met plusieurs graphes sur la page:
close.screen(all=TRUE)

if (length(xlab)>1)
  nbscreens <- split.screen(figs=figs)
else
  {
  # il n'y a qu'un graphe
  if (!is.matrix(figs))
    {
    # cas ou on demande l'ecran entier
    nbscreens <- split.screen(c(1, 1))
    }
  else
    {
    # cas ou l'ecran est determine par un figs donne par l'utilisateur
    # on prend l'espace total de toutes les figures
    m <- matrix(c(min(figs[,1]), max(figs[,2]), min(figs[,3]),max(figs[,4])),
       nrow=1)
    nbscreens <- split.screen(m)
    }
  }

	
n <- nrow(xmat)
	
if (is.null(curvey))
  {
  # une seule courbe:
  # ----------------
  pl1cnls2(xmat, y, id, ncurvey=n,
	   xfit,yfit, ncurvefit=n,
                 jump,	
                 title, xlab, ylab,
                 smooth,   ask.pause, ask.modify,
                 boucle=F, iscreen=1,nbscreens, figs, ...)
  }

else
  {
  # Plusieurs courbes:
  # ------------------
  # Trace de toutes les courbes sur le (les) meme(s) graphe(s),
  # les points etant identifies par l'identificateur de courbe
  subtitle <-  "curve identifiers"
  # ncurvey:	nbre de points par courbe
  idc <- unique(curvey) # noms des courbes
  ncurvey <- vector(mode="integer", length=length(idc))
  ncurvefit <- vector(mode="integer", length=length(idc))
  for (ic in 1:length(idc))
    {
    v <- (curvey==idc[ic])
    ncurvey[ic] <-  length(v[v==TRUE])
    if (!is.null(curvefit))
      {
      v <- (curvefit==idc[ic])
      ncurvefit[ic] <-  length(v[v==TRUE])
      }
    else
      ncurvefit <- NULL		
    } # fin de for ic

  iscreen <- pl1cnls2(xmat, y, id=curvey,ncurvey,
	         xfit, yfit,  ncurvefit,
	         jump,
                 title, xlab, ylab,
                 smooth,  ask.pause,  ask.modify,
                  boucle=F, iscreen=1,nbscreens, figs,sub=subtitle, ...)
  
  
  # Trace de chaque courbe: plusieurs graphes dans la page,
  # les points etant identifies par id:
  close.screen(all=TRUE)
  nbscreens <- split.screen(figs)
  par(adj=.5)
  iscreen <- 1
  
  deby <- debfit <- 1
  for (c in 1:length(idc)) 
    {
    boucle <- T 	
    if (length(xlab)>1)
      {
      # On repart du debut de l'ecran a chaque courbe
      # boucle=F:demander si on veut effacer apres chaque appel a pl1c	
      deb.screen <- 1
      boucle  <- F
      }		
    else
      {
      # une seule va: on met plusieurs courbes sur le meme ecran
      # ne demander si on veut effacer que si on est a la derniere
      # courbe
      deb.screen <- iscreen 
      if (c == length(idc))
        boucle  <- F
      }
    finy <- deby + ncurvey[c] -1
    if (is.null(xfit))
      {		
      iscreen <-  pl1cnls2(
	             as.matrix(xmat[(deby:finy),]), 
	                y[deby:finy], id[deby:finy], ncurvey[c],
	              xfit,yfit,ncurvefit,
                      jump,	
                      title,xlab, ylab,
                      smooth, ask.pause,  ask.modify,
                      boucle=boucle,
	     iscreen=deb.screen,nbscreens,figs,sub=paste("curve",idc[c]), ...)
      }	
    else	
      {
      finfit <- debfit + ncurvefit[c] -1
      iscreen <-  pl1cnls2(
	             as.matrix(xmat[(deby:finy),]), 
	                y[deby:finy], id[deby:finy], ncurvey[c],
	              as.matrix(xfit[(debfit:finfit),]),
        	         yfit[debfit:finfit],ncurvefit[c],
	               jump,
                      title,xlab, ylab, 
                      smooth,  ask.pause,  ask.modify,
                      boucle=boucle,
	iscreen=deb.screen,nbscreens,figs,sub=paste("curve",idc[c]), ...)
      debfit <-  finfit+1	
      }				

    deby <-  finy+1	
    } # fin boucle sur les courbes
  } # fin du cas plusieurs courbes
  close.screen(all=TRUE)

invisible()
}
# ------------ fin fonction plnls2 ------------------------#
