# : ### FICHIER plot.calibnls2.s ###

# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# plot.calibnls2:	 trace des resultats de calib.nls2
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
plot.calibnls2<- function (
	calib.object,
	xlab=c("R.x", "independent variable"),
	ylab=c("R.values", "fitted standard curve"),
	smooth=F, n.fitted=0,
	title="", ask.pause=T, ask.modify=F, ...)
{	
#-------------------------------------------------------------------------
# Verifications:	
if ( !is.numeric(n.fitted) || (n.fitted<0) ||
	( (n.fitted>0) &&  (n.fitted<2)))
  stop(paste(
"Argument 'n.fitted',", n.fitted,
"must be an integer greater than 2\n"))

if (n.fitted>0)
  smooth <- T

# Il faut le nls2.object
nls2.object <- eval(calib.object$call$nls2.object)
if (!inherits(nls2.object,"nls2"))
  stop(paste("Object",
	calib.object$call$nls2.object,
	"not found\n"))

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

if (ask.modify)
  ask.pause <- T
if (ask.pause)
  par(ask=T)

# Preparation des labels des axes:
if (!missing(xlab))
  {
  if (length(xlab)<2)
    xlab <- c("R.x", xlab)
  }
if (!missing(ylab))
  {
  if (length(ylab)<2)
    ylab <- c("R.values", ylab)
  }
		
# ------------ 1ier plot:R(z) en fonction de z------------------------------
	
if (!is.null(calib.object$R.x))
  {
  par(cex=1)	
  plot(calib.object$R.x, calib.object$R.values,
	 type="n", 
	main=title, xlab=xlab[1], ylab=ylab[1])

  if(!is.null(calib.object$R.conf.set))
    {
    indice <-  calib.object$R.x== any(R.conf.set)	
    text(calib.object$R.x[indice], calib.object$R.values[indice],
         labels="R", cex=0.5)
    text(calib.object$R.x[!indice], calib.object$R.values[!indice],
	labels="*")
    }
  else
    {
    indice <- (calib.object$R.x >= calib.object$R.conf.int[1]) &
                         (calib.object$R.x <= calib.object$R.conf.int[2])
    text(calib.object$R.x[indice],calib.object$R.values[indice],labels="R",
        cex=0.5)
    text(calib.object$R.x[!indice],calib.object$R.values[!indice],labels="*")
   }

# Rajout des lignes conf.bounds
  abline(calib.object$conf.bounds[1],0, lty=2)	
  abline(calib.object$conf.bounds[2],0, lty=2)
  par(cex=0.8)
  mtext(as.character(
          round(calib.object$conf.bounds[1],2)),
	2, at=	calib.object$conf.bounds[1])
  mtext(as.character(
          round(calib.object$conf.bounds[2],2)),
	2, at=	calib.object$conf.bounds[2])


  if (ask.modify)
    {
    # restitution des parametres de plotting originaux:
    par(oldpar) 
    plmodifynls2()
    }

 } # Fin du trace de R(z)
	
# ----------- 2ieme plot ------------------------------------------	
# Sauvegarde des parametres "par" courants si on les a retablis:
if (ask.modify)
  {	
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()
  par(ask=T)
  }
		
moyZ <- mean(calib.object$ord)
	
# Il faut les data:
data  <-  nls2.object$data.sv
if (is.null(data))	
  data <- plsplitoutnls2(nls2.object)
z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=NULL)
# On obtient: z$dmat:  matrice des va explicatives
				

xlim <- c(min(calib.object$x, z$dmat[,1], calib.object$S.conf.int[1],
	calib.object$R.conf.int[1]), 
        max(calib.object$x, z$dmat[,1], calib.object$S.conf.int[2],
	calib.object$R.conf.int[2]))
if (!is.null(calib.object$R.conf.int))
  {
  xlim[1] <- min(xlim[1], calib.object$R.conf.int[1])
  xlim[2] <- max(xlim[2], calib.object$R.conf.int[2])
  }

ylim <- c(min(calib.object$ord, nls2.object$response), 
	max(calib.object$ord, nls2.object$response))
etendue <-  abs(ylim[2]-ylim[1])
grad <- 30 # nombre de lignes minimal en general du graphe
echelle <- etendue/grad # difference des ordonnees entre 2 points	

# plot des (xlim[1], Zj):

plot( rep(xlim[1], length(calib.object$ord)),
      calib.object$ord,
      axes=F, main=title,
      xlab=xlab[2],
      ylab=ylab[2],
      xlim=xlim, ylim=c(-2*echelle, ylim[2]+2*echelle),
	pch="+")

# on rajoute 2 graduations en haut et en bas 
# pour avoir la ligne 0 sur laquelle on va mettre la fleche
# on ne met pas les axes car on ne veut pas que l'axe des abs soit en-dessous
# mais sur la ligne du 0
# on rajoute en haut pour qu'ensuite l'axe vertical
# aille jusqu'en haut


# On met l'axe vertical:
axis(side=2, at= c(ylim[2], moyZ,0), labels=
	  c("",as.character(round(moyZ,3)),"0"), cex=0.8  )
	
	
	
# Rajout de la courbe ajustee
# Si n.fitted>0:	 lisser en plusieurs points
# donc, calculer f en une grille:	
if (n.fitted>1)
  {
  RetFit <- cfitnls2(nls2.object, z, n.fitted,
	nls2.object$theta, beta=NULL, sigma2=NULL,
	calc.f=T, calc.v=F)
  toplot <- lowess(RetFit$xfit, RetFit$yfit)
  } # fin de 	n.fitted>1
else
  {
  if (smooth)
    toplot <- lowess(unique(z$dmat[,1]), nls2.object$response)
  else
    toplot <- list(x= unique(z$dmat[,1]), y=nls2.object$response)	
  }		

lines(toplot)

# Rajout de la ligne du 0
abline(0,0)
taille <- 0.8	
par(cex=taille)

# Rajout des coordonnees x.bounds
text(calib.object$x.bounds[1],
	-echelle*taille,
     as.character(round(calib.object$x.bounds[1],3)))

text(calib.object$x.bounds[2],
	-echelle*taille,
     as.character(round(calib.object$x.bounds[2],3)))


# Rajout de la coordonnee sur x de xchapeau:
text(calib.object$x,
	-echelle*taille,
     as.character(round(calib.object$x,3)))

# On joint par des lignes ces 2 points:	
segments(xlim[1], moyZ,
         calib.object$x, moyZ, lty=2)
segments(calib.object$x,moyZ,
	calib.object$x, 0, lty=2)
	

# Fleche horizontale sur la ligne 0:
if (!is.null(calib.object$S.conf.int))
  {
	if (is.R()) {
  arrows(calib.object$S.conf.int[1], 0,
       calib.object$S.conf.int[2], 0, 
       code=1)
  arrows(calib.object$S.conf.int[2], 0,
       calib.object$S.conf.int[1], 0, 
       code=1)
	 }
	else {
	  arrows(calib.object$S.conf.int[1], 0,
       calib.object$S.conf.int[2], 0, 
       open=F)
  arrows(calib.object$S.conf.int[2], 0,
       calib.object$S.conf.int[1], 0, 
       open=F)
	 }
	
	
  par(cex=0.6)	
  text(	calib.object$S.conf.int[1], echelle/2,"S")
  text(	calib.object$S.conf.int[2], echelle/2,"S")
  }	

if (!is.null(calib.object$R.conf.int))
  {
  # Fleche horizontale sur la ligne 0:
	par(lty=5)
	if (is.R())
  arrows(calib.object$R.conf.int[1], 0,
       calib.object$R.conf.int[2], 0, 
       code=1)
	else
	arrows(calib.object$R.conf.int[1], 0,
       calib.object$R.conf.int[2], 0,
	open=F)

	if (is.R())
  arrows(calib.object$R.conf.int[2], 0,
       calib.object$R.conf.int[1], 0, 
       code=1)
		else
	arrows(calib.object$R.conf.int[1], 0,
       calib.object$R.conf.int[2], 0,
	open=F)
	
  text(	calib.object$R.conf.int[1], -echelle/2,"R")
  text(	calib.object$R.conf.int[2], -echelle/2,"R")
  }

# Rajout de la legende:
par(cex=0.8)
leg <-  paste(
            as.character(round(calib.object$x,3)), 
	     ":	x")

if (!is.null(calib.object$S.conf.int))
  {
  leg <- paste(leg, "     [",
	as.character(round(calib.object$S.conf.int[1],3)), 
             ",",
            as.character(round(calib.object$S.conf.int[2],3)), 
              "] : S")
  }						
if (!is.null(calib.object$R.conf.int))
  {		
  leg <-  paste(leg,
              "     [",
             as.character(round(calib.object$R.conf[1],3)),
              ",",
             as.character(round(calib.object$R.conf[2],3)),
               "] : R", sep="")
				
  }

text(xlim[1],-2*echelle, leg, adj=0)

#ou <-  (abs(xlim[2])-abs(xlim[1]))/2	
#text(ou,-2*ylim[1], leg, adj=0) # au centre
#  text(xlim[2],-2*ylim[1], leg, adj=1) # a droite

if (ask.modify)
  {
  # restitution des parametres de plotting originaux:
  par(oldpar) 
  plmodifynls2()
  }
	
# Plot bidon pour effacer l'ecran
	
plot(1,2,axes=F,type="n", xlab="", ylab="")
# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
# ----------- fin de 	plot.calibnls2 ------------------------
		
