# : ### FICHIER plsplitnls2.s ###
plsplitdnls2<- function(data, response.name, X.names, labels)
{
# Determination des divers elements constituant les donnees
# --------------------------------------------------------
# Renvoie:
# dmat:  matrice des va explicatives
# response.name: nom du vecteur reponse
# y: vecteur reponse,
# va.names: noms des variables explicatives
# curve: noms des n indices indices de courbe
# labels: les labels correspondant a des poids non nuls

# Verification:
# ------------
if (!inherits(data,"data.frame"))
   stop("\nThe data must be in a 'data.frame'\n")

if (!is.character(response.name))
  stop("\nThe name of the response variable must be a character string\n")

if(is.na(match(response.name, names(data))))
  stop(paste("\nThe name of the response variable",
             response.name,
             "must be the name of a vector included in the 'data.frame'\n"))

lvar <- pmatch(X.names, names(data))
if (any(is.na(lvar)))
  stop(paste("\n The names of the vectors containing the independent variables",
  X.names,
  "must be the names of vectors included in the 'data.frame'\n"))


# Determination des divers elements constituant les donnees
# --------------------------------------------------------
dmat <- as.matrix(data)
y <-  dmat[,response.name]
mode(y) <- "numeric"

if (!is.null(data$weights))
  {
  # on enleve les donnees de poids nuls
  w <-  dmat[,"weights"]
  y <- y[w !=0]
  dmat <- dmat[w!=0,]
  if (length(labels) >0)
       labels <-  labels[w !=0]
  }

  
if (!is.null(data$curves))
  {
  curve <-  dmat[, "curves"]
  }
else
 curve <- NULL


dmat <-  as.matrix(dmat[, X.names])
dimnames(dmat) <- list(dimnames(dmat)[[1]], X.names)
mode(dmat) <-  "numeric"
z <- list(dmat=dmat, y=y, va.names=X.names,response.name=response.name,curve=curve, labels=labels)
return(z)
}

plsplitoutnls2 <- function(nls2.object)
{
# Recherche du data.frame associe au nls2.object
# quand celui-ci n'a pas ete sauvegarde dans celui-ci

data.name <-  as.character(nls2.object$call$data)

if (!exists(data.name))
  stop(paste("\nThe data.frame",
       data.name,
       "from which has been built the 'nls2.object' is not found\n"))
return(get(data.name))

}

  
