# : ### FICHIER plvar.nls2.s ###
plvar <- function(x, ...)
  UseMethod("plvar")

plvar.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plvar.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         fitted=F,
         wanted=list(X.S2=T, X.S=F, logX.logS2=F, Y.S2=T, Y.S=F, logY.logS2=F),
         smooth=F, n.fitted=0,
	 labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)

{
#***************************************************************************
# FONCTION:
# representations graphiques en vue d'une etude de la variance empirique
#  (Y1) et/ou ajustee (Ajustes.VarY)
# relative a des donnees etudiees par nls2:
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# fitted: si on veut, sur les memes graphes que ceux ou est representee
#         la variance empirique, les variances ajustees
# X.S2: TRUE si on veut le graphe des variances
#      en fonction des variables explicatives
# X.S: TRUE si on veut le graphe des racines carrees des variances
#      en fonction des variables explicatives
# logX.logS2:  TRUE si on veut le graphe des logarithmes  des variances
#      en fonction des logarithmes  des variables explicatives
# Y.S2:  TRUE si on veut le graphe des variances
#      en fonction des moyennes empiriques (Y1)
#      si fitted, les variances ajustees sont representees
#      en fonction des esperances ajustees
# Y.S: TRUE si on veut le graphe des racines carrees des variances
#      en fonction des moyennes empiriques (Y1)
#      si fitted, les racines carrees des variances ajustees sont representees
#      en fonction des esperances ajustees
# logY.logS2: TRUE si on veut le graphe des logarithmes  des variances
#      en fonction des logarithmes  des moyennes empiriques (Y1)
#      si fitted, les logarithmes des variances ajustees sont representees
#      en fonction des logarithmes des esperances ajustees
#
# smooth: T si on veut un lissage des points (cf fonction S: lowess)
#         relatifs aux valeurs ajustees
# labels, title, figs, ask, ... :voir fonction 'pld'
#***************************************************************************
# Verification des arguments:
# --------------------------
if (is.null(nls2.object$replications))
  stop("The nls2.object should contain the component 'replications'")
if ( all(nls2.object$replications == 1))
  stop("\n This function is valid only when there are replications\n")

if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step",
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match\n "))
if ( !is.numeric(n.fitted) || (n.fitted<0) ||
	( (n.fitted>0) &&  (n.fitted<2)))
  stop(paste(
"Argument 'n.fitted',", n.fitted,
"must be an integer greater than 2\n"))

	
# determination des divers elements constituant les donnees:
# --------------------------------------------------------
  data <- plsplitoutnls2(nls2.object)

if (is.null(nls2.object$data.stat))
  stop("The nls2.object should contain the component 'data.stat'")

if (length(labels) != length(nls2.object$data.stat$S2)) #labels non en dimension k
  z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=labels) 
else
  {
  # ne pas modifier les labels: ils sont en dim k
  z <- plsplitdnls2(data,nls2.object$response.name, nls2.object$X.names, labels=NULL)
  z$labels <- labels
  }


# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls

# Verif quand on demande la generation de nouveaux points de calcul:	
if (n.fitted>0)
  fitted  <-  T

if  (n.fitted>0)
  {	
  if (ncol(z$dmat)>1)
    {
    warning(paste(
	"Option 'n.fitted' ignored because there are several independent variables.\n",
	"Fitted values of the data are considered instead.\n"))
    n.fitted <- 0
    }
  if (nls2.object$model$vari.type=="VI")
    {
    warning(paste(
	"Option 'n.fitted' ignored because the variance is the intra-replications variance.\n",
	"Fitted values of the data are considered instead.\n"))
    n.fitted <- 0
    }
  } # fin (n.fitted>0)
	
					
# Mise en dimension k des variables explicatives:
# ----------------------------------------------
indices <-  cumsum(nls2.object$replications)
if (length(indices) != length(nls2.object$data.stat$S2))
  stop("\nThe 'nls2.object' and the data does not match\n ")

if (length(z$labels) == length(z$y)) 
  {
  z$labels <-  z$labels[indices]
  }

z$dmat <-  matrix(z$dmat[indices,],ncol=length(z$va.names))
z$y <-  z$y[indices]
if (!is.null(data$curve))
  z$curve <- z$curve[indices]


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", length(z$y))
else
  {
  if (length(z$labels) != length(z$y))
    stop("\n The length of the label vector does not match \n")
  }


# Constitution des abscisses et ordonnees:
# --------------------------------------
# Les valeurs observees  qui seront eventuellement lissees
# par une ligne pointillee, les ajustees seront toujours lissees
# par une ligne pleine
xfit <- yfit <- varfit <- curvefit <- logxfit <- logvarfit <- logyfit <- NULL
	
S2 <- nls2.object$data.stat$S2
S2lab <- "empirical variance"

if (fitted)
  {
  if (missing(step))
    {	
    if (n.fitted==0)
      {
      varfit <-  fitted(nls2.object)$variance
      if (is.null(varfit))
        stop("The nls2.object should contain the fitted values of the variance")
      } # fin if (n.fitted==0)
    else
      {
      # Pour le calcul de la variance sur une grille
      theta <- coef(nls2.object)$theta
      beta <-  coef(nls2.object)$beta		
      sigma2 <- coef(nls2.object)$sigma2
      if ( is.null(theta) || is.null(sigma2))
        stop("The nls2.object should contain the estimated values of the parameters and  sigma2")            
      }
    }	# fin de pas d'etape
  else
    {
    if (n.fitted==0)
      {
      varfit <-  nls2.object[[paste("etape",step,sep="")]]$variance
      if (is.null(varfit))
        stop("The nls2.object should contain the fitted values of the variance")
    }# fin if (n.fitted==0)
    else
      {
      # Pour le calcul de la variance sur une grille
      theta <- nls2.object[[paste("step",step,sep="")]]$theta
      beta <- nls2.object[[paste("step",step,sep="")]]$beta
      sigma2 <- nls2.object[[paste("step",step,sep="")]]$sigma2		
      if ( is.null(theta) || is.null(sigma2))
        stop("The nls2.object should contain the estimated values of the parameters and  sigma2")            
      }			
    }	# fin de il y a des steps

  S2lab <- paste("fitted and", S2lab)
  if (n.fitted >1)
    {
    # calc.f=T, si il faut garder les f	
    calc.f <-  ( (!is.null(wanted$Y.S2) && wanted$Y.S2)
   || (!is.null(wanted$Y.S) && wanted$Y.S)
   || (!is.null(wanted$logY.logS2) && wanted$logY.logS2))
    # Generer xfit et curvefit
    # calculer varfit=v(theta,beta)*sigma2 (poids supposes 1 sur la grille)
    # et, si calc.f, yfit
    RetFit <-  cfitnls2(nls2.object,z, n.fitted,
	theta, beta, sigma2, calc.f, calc.v=T)
    xfit <- as.matrix(RetFit$xfit)			
    curvefit <- RetFit$curvefit			
    yfit <- as.matrix(RetFit$yfit)
    varfit <- RetFit$varfit	
    } # fin de (n.fitted >0)
  else
    {
    xfit <- as.matrix(z$dmat)
    curvefit <- z$curve
    }	
  } # fin de fitted

if ( (!is.null(wanted$Y.S2) && wanted$Y.S2)
   || (!is.null(wanted$Y.S) && wanted$Y.S)
   || (!is.null(wanted$logY.logS2) && wanted$logY.logS2)
   )
  {
  Y1 <-  nls2.object$data.stat$Y1
  Y1lab <- "empirical means"
  if (fitted)
    {
    if (missing(step))
      {	
      if (n.fitted==0)      	
        yfit <-  as.matrix(fitted(nls2.object)$response)
      }					
    else
      {
      if (n.fitted==0)  		
        yfit <-  as.matrix(nls2.object[[paste("etape",step,sep="")]]$response)
      }
    if (is.null(yfit) || (!is.numeric(yfit)) )
      stop("The nls2.object should contain the fitted values of the response")
    Y1lab <- paste("fitted and", Y1lab)
    }
  }

		
# Verification des Log:
# --------------------
if (!is.null(wanted$logX.logS2) && wanted$logX.logS2)
  {
  if (any(z$dmat<=0))
    {
    warning(paste(
 "The plot of the logarithm cannot be made:\n",
 "numerical error when calculating the log of the independent variables\n"))
    wanted$logX.logS2  <- F
    }
  logx <- log(z$dmat)
  if (n.fitted>0)
    {	
    if (any(xfit<=0))
      {
      warning(paste(
 "The plot of the logarithm cannot be made:\n",
 "numerical error when calculating the log on the generated values of the independent variables\n"))
      wanted$logX.logS2  <- F
      }
    logxfit <- as.matrix(log(xfit))
    } # fin de (n.fitted>0)	
  } # fin de wanted$logX.logS2

if ( (!is.null(wanted$logX.logS2) && wanted$logX.logS2)
   || (!is.null(wanted$logY.logS2) && wanted$logY.logS2))
  {    
  if (any(S2<=0))
      {
      warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the empirical variances\n"))
      wanted$logX.logS2  <- F
      wanted$logY.logS2 <- F
      }
  logS2 <- log(S2)
  if (fitted)
    {
    if (any(varfit<=0))
      {
      warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the fitted variances\n"))
      wanted$logX.logS2  <- F
      wanted$logY.logS2 <- F
      }
    logvarfit <- log(varfit)
    }	
  }


if ( !is.null(wanted$logY.logS2) && wanted$logY.logS2)
  {
  if (any(Y1<=0))
    {
    warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the empirical means\n"))
    wanted$logY.logS2 <- F
    }
  logY1 <- log(Y1)
  if (fitted)
    {
    if (any(yfit<=0))
      {
      warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the fitted responses\n"))
      wanted$logY.logS2 <- F
      }
    logyfit <- as.matrix(log(yfit))
    }	
  }

	
# Fin verification des log
# -----------------------

# Pour que R ne mette pas d'erreur si varfit est nul:
if (is.null(varfit))
  sqrtvarfit  <-  NULL
else
  sqrtvarfit  <-  sqrt(varfit)

if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

if (!is.null(wanted$X.S2) && wanted$X.S2)
  {
  cat("\nPlots asked by the X.S2 option\n", fill=T)
	
  plnls2(as.matrix(z$dmat),S2, z$labels, z$curve,
	 xfit, varfit,  curvefit,
	  title, 
	  xlab=z$va.names, ylab=S2lab, 
          jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
         figs, ...)
  }
# pour pas que S confonde X.S2 avec X.S:
wanted$X.S2 <- NULL

if (!is.null(wanted$logX.logS2) && wanted$logX.logS2)
  {
  cat("\nPlots asked by the logX.logS2 option\n", fill=T)
  plnls2(as.matrix(logx), logS2, z$labels, z$curve,
	 logxfit, logvarfit, curvefit,
         title,
	 xlab=paste("log of",z$va.names),ylab=paste("log of",S2lab),
         jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }


if (!is.null(wanted$X.S) && wanted$X.S)
  {
  cat("\nPlots asked by the X.S option\n", fill=T)
  plnls2(as.matrix(z$dmat), sqrt(S2), z$labels, z$curve,
	 xfit, sqrtvarfit, curvefit,
         title,
	 xlab=z$va.names,ylab=paste("sqrt of",S2lab),
         jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }

if (!is.null(wanted$Y.S2) && wanted$Y.S2)
  {
  cat("\nPlots asked by the Y.S2 option\n", fill=T)
  plnls2(as.matrix(Y1), S2, z$labels, z$curve,
	 yfit, varfit, curvefit,
         title,
	 xlab=Y1lab,ylab=S2lab,
	 jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }
wanted$Y.S2 <- NULL

if (!is.null(wanted$Y.S) && wanted$Y.S)
  {
  cat("\nPlots asked by the Y.S option\n", fill=T)
  plnls2(as.matrix(Y1), sqrt(S2), z$labels, z$curve,
	 yfit, sqrtvarfit, curvefit,
         title,
	 xlab=Y1lab,ylab=paste("sqrt of",S2lab),
         jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }

if (!is.null(wanted$logY.logS2) && wanted$logY.logS2)
  {
  cat("\nPlots asked by the logY.logS2 option\n", fill=T)
  plnls2(as.matrix(logY1), logS2,  z$labels, z$curve,
	 logyfit, logvarfit, curvefit,
         title,
         xlab=paste("log of",Y1lab),ylab=paste("log of",Y1lab),
        jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }

# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
