# : ### FICHIER print.nls2.s ###
prstepnls2<-function(nls2.step)
{
# fonction d'impression d'une etape d'un nls2.object

cat(nls2.step$message,  fill=T)
if (!is.null(nls2.step$stop.crit))
  cat(" stopping criterion:", nls2.step$stop.crit,  fill=T)
if (!is.null(nls2.step$stat.crit))
  cat(" statistical criterion:", nls2.step$stat.crit,  fill=T)
if (!is.null(nls2.step$nb.iters))
  cat(" number of iterations:",nls2.step$nb.iters,  fill=T)

if (!is.null(nls2.step$theta))
  {
    cat(" parameters estimations:", fill=T)
    print(nls2.step$theta)
    if ( !is.null(nls2.step$beta) && !all(is.na(nls2.step$beta)))
  {
  cat(" variance parameters estimations:", fill=T)
  print(nls2.step$beta)
  }
  } # fin if (!is.null(nls2.step$theta))

if (!is.null(nls2.step$std.error) && !all(is.na(nls2.step$std.error)))
  {
  cat(" parameters standard errors:", fill=T)
  print(nls2.step$std.error)
  }
}


print.nls2<-
function(nls2.object,digits = NULL, ...)
{

# fonction d'impression d'un nls2.object

if(!missing(digits)) 
  {
  if((length(digits) != 1 || digits < 1) || digits > 20)
          stop("Bad value for digits argument")
  d <- options(digits = digits)
  on.exit(options(d))
  }

if (!is.null(nls2.object$replications))
  {
cat("\nNumber of distinct observations:", length(nls2.object$replications), fill=T)

cat("Total number of replications:", sum(nls2.object$replications), fill=T)
} # fin if (!is.null(nls2.object$replications))
 
if (nls2.object$nb.steps ==1)
  {
  prstepnls2(nls2.object)
  }
else
  {
  for (i in (1:nls2.object$nb.steps))
    {
    cat("\nStep", i,":	\n------", fill=T)
    switch(i,
      prstepnls2(nls2.object$step1),
      prstepnls2(nls2.object$step2),
      prstepnls2(nls2.object$step3)
          )
     }
  }


}
