# : ### FICHIER print.summary.nls2.s ###

prsummarystepnls2 <- function(algorithm, summary.step)
{
#
# fonction d'impression d'une etape d'un summary.nls2.object
#

        cat(" method:", summary.step$method, fill=T)
        if (!is.null(summary.step$stat.crit.type))
        cat(" statistical criterion type:", summary.step$stat.crit.type, fill=T)
        if (!is.null(summary.step$nb.iters))
	cat(" number of iterations:", summary.step$nb.iters,  fill=T)
        if (!is.null(summary.step$stop.crit))
        cat(" stopping criterion:", summary.step$stop.crit,  fill=T)
        if (!is.null(summary.step$stat.crit))
        cat(" statistical criterion:", summary.step$stat.crit,  fill=T)
        if (!is.null(summary.step$lambda) && (algorithm == "GM"))
          cat(" Gauss-Marquardt algorithm parameter:", summary.step$lambda,  fill=T)
        if (!is.null(summary.step$sigma2))
        cat(" sigma**2:",summary.step$sigma2,  fill=T)
	if (!is.null(summary.step$deviance))
	cat(" deviance:	", summary.step$deviance, fill=T)
        if (!is.null(summary.step$rss))
        cat(" sum of squares:", summary.step$rss,  fill=T)
        if ( !is.null(summary.step$rss.unweighted) && !is.na(summary.step$rss.unweighted))
          cat(" unweighted sum of squares:", summary.step$rss.unweighted,  fill=T)

        print.coef.nls2(summary.step)
        cat( summary.step$message, "\n\n", fill=T)
}


print.summary.nls2<-
function(summary.nls2.object,digits = NULL, ...)
{
#
# fonction d'impression d'un summary.nls2.object
#
        if(!missing(digits)) {
                if((length(digits) != 1 || digits < 1) || digits > 20)
                        stop("Bad value for digits argument")
                d <- options(digits = digits)
                on.exit(options(d))
        }
if (!is.null(summary.nls2.object$k))
          cat(" number of distinct observations:", summary.nls2.object$k,  fill=T)

if (!is.null(summary.nls2.object$n))
        cat(" total number of replications:", summary.nls2.object$n, fill=T)
if (!is.null(summary.nls2.object$algorithm))
        cat(" algorithm:", summary.nls2.object$algorithm, fill=T)
if (!is.null(summary.nls2.object$sigma2.type))
        cat(" sigma type:", summary.nls2.object$sigma2.type, fill=T)
if (!is.null(summary.nls2.object$vari.type))
        cat(" variance type:", summary.nls2.object$vari.type, fill=T)
if (!is.null(summary.nls2.object$family))
	cat(" family:", summary.nls2.object$family, fill=T)
	
if (is.null(summary.nls2.object$step1))
  {
  prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object)
  }
else
  {
  cat("\nStep 1:	 \n------\n")
  prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object$step1)
  if (!is.null(summary.nls2.object$step2))
    {
      cat("Step 2:	 \n------\n")
      prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object$step2)
    }
   if (!is.null(summary.nls2.object$step3))
    {
    cat("Step 3:	 \n------\n")
    prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object$step3)
    }
  }
}
