# : ### FICHIER wald.nls2.s ###
wald <- function(x, ...)
  UseMethod("wald")

wald.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }
# ----------------------------------------------------------------
# examwaldnls2: renvoyer les theta, beta et asvar actifs de la derniere etape
# ------------------------------------------------------------------
examwaldnls2 <- function(nls2.object)
{
  theta <- coef(nls2.object)$theta
  beta <- coef(nls2.object)$beta
  as.var <- coef(nls2.object)$as.var
 if (is.null(theta))
   stop("The nls2.object does not include the estimated values of the parametres")
  
 if (is.null(as.var) || all(is.na(as.var)))
  stop("The nls2.object does not include a valid as.var")

# Determiner les param actifs
# Oter les param egaux entre eux:
if(!is.null(nls2.object$model$eqp.theta))
  theta <-  theta[duplicated(nls2.object$model$eqp.theta) !=T]
if(!is.null(nls2.object$model$eqp.beta))
  beta <-  beta[duplicated(nls2.object$model$eqp.beta) !=T]
# Oter les param avec contraintes d'egalite num:
actifs <- dimnames(as.var)[[1]][!is.na(diag(as.var))]
namet <- match(actifs, names(theta),0)
theta.act <-  theta[namet]
if (!is.null(beta) && !all(is.na(beta)) )
  {
  nameb <- match(actifs, names(beta),0)
  beta.act <-  beta[nameb]
  }
else
  {
  beta.act <- NULL
  nameb <- NULL
  }
pact <- c(theta.act,beta.act)
namesp <- names(pact)
as.var <- as.var[namesp, namesp]

return( list(pact=pact, as.var=as.var))

}

# ----- end of function examwaldnls2 ---------------------------------

# ------------------------------------------------------------------------
 wald.nls2 <- function(nls2.object, file, 
                    pbispsi= c(nls2.object$model$gamf,nls2.object$model$gamv),
                    varpsi=NULL)
{
# -------------------------------------------------------------------------
# function that calculates the test of Wald
# on a given nls2.object for functions of the parameters
# -------------------------------------------------------------------------

cc <- examwaldnls2(nls2.object)
RetPsi <-  calcpsinls2(file, cc$pact, varpsi=varpsi, pbispsi=pbispsi)

	
if (is.null(RetPsi)) return(NULL)
	
# on ne garde que les parametres actifs qui interviennent dans les psi:
namep <-  dimnames(RetPsi$d.psi)[[2]]
as.var <- as.matrix(cc$as.var[namep, namep])

produit  <-  RetPsi$d.psi %*% as.var %*% t(RetPsi$d.psi)

 options(show.error.messages = FALSE)
	SW <-  try(solve(produit))
	print(produit)
 options(show.error.messages = TRUE)
	
	# pour enlever les warnings dus a l'incompatibilite des labels quand on multiplie:
psi <-  RetPsi$psi
names(psi) <- NULL
if (!	is.numeric(SW)) {
	cat("\nSorry:	 the value of the Wald statistic cannot be calculated\n")
	warning(SW[1])
	SW<- matrix(NaN, ncol=1, nrow=1)
	}
else
	SW  <-  t(psi) %*% SW %*% psi

	dprod <- diag(produit)
	std.error  <-  sqrt(dprod)
names(std.error) <-  names(RetPsi$psi)
	
return(list(psi= RetPsi$psi, d.psi=RetPsi$d.psi, statistic=SW[1,1], std.error=std.error, var.psi=produit,call=match.call()))
}

# ----------------------------------------
# ----------- end function wald.nls2 ----------
# ----------------------------------------
