/*----------------------------------------
description file: /tmp/calib19033

% model CORTI
resp cpm;
var v; 
parresp  dose;
varind  n,d,a,b,g;
pbisresp minf,pinf; 
subroutine;
begin 
cpm= if dose <= minf then d else
      if dose >= pinf then n else
      n+(d-n)*exp(-g*log(1+exp(a+b*log10(dose))))
    fi fi;
v = cpm**2;
end 
----------------------------------------*/
#include <stdio.h>
#include <math.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "nlmacros.h"
#include "nlfonc.h"

short int calcfx_(nbt, nbg, nbl, nbc, t, g, x, f, df, le, ie)
      short int nbt, nbg, nbl, nbc;
      double *t, *g, **x, *f, **df;
      short int *le, *ie;
{
short int i;
double res;
ECRTRACE("calcf");
for (i=0; i<nbl; i++)
  {
    res= ((t[0]) <= (g[0])) ? (x[i][1]) : (((t[0]) >= (g[1])) ? (
      x[i][0]) : ((x[i][0]) + (((x[i][1]) - (x[i][0])) * (
      (double)myexp((-(x[i][4])) * (myln((
      (double)1) + ((double)myexp((x[i][2]) + ((
      x[i][3]) * (mylog(t[0]))))))))))));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=F;
        return(ERRMATH);
      }
    f[i]= res;
    res= ((t[0]) <= (g[0])) ? ((double)0) : (((
      t[0]) >= (g[1])) ? ((double)0) : (((x[i][1]) - (
      x[i][0])) * (((-(x[i][4])) * (mydiv(((x[i][3]) * (mydiv(
      (double)1, (t[0]) * (myln(
      (double)10))))) * ((double)myexp((x[i][2]) + (
      (x[i][3]) * (mylog(t[0]))))), ((double)1) + (
      (double)myexp((x[i][2]) + ((x[i][3]) * (mylog(t[0])))))))) * (
      (double)myexp((-(x[i][4])) * (myln((
      (double)1) + ((double)myexp((x[i][2]) + ((
      x[i][3]) * (mylog(t[0]))))))))))));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DFDT;
        return(ERRMATH);
      }
    df[i][0]= res;
  }
return(OK);
}

short int calcvx_(nbt, nbb, nbg, nbl, nbc, t, b, g,
                f, df, x, v, dtv, dbv, le, ie)
      short int nbt, nbb, nbg, nbl, nbc;
      double *t, *b, *g, **x, *v, **dtv, **dbv, *f, **df;
      short int *le, *ie;
{
short int i;
double res;
ECRTRACE("calcv");
for (i=0; i<nbl; i++)
  {
    res= mypow(f[i], (double)2);
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=V;
        return(ERRMATH);
      }
    v[i]= res;
    res= ((double)2) * ((mypow(f[i], (
      (double)2) - ((double)1))) * (df[i][0]));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DVDT;
        return(ERRMATH);
      }
    dtv[i][0]= res;
  }
return(OK);
}

