      integer function mycalcf(nbtheta, nbgamma, nbobs, nbvar, theta, 
     *gamma, x, fmod, dfmod, le, ie)
      integer nbtheta, nbgamma, nbobs, nbvar
      double precision theta(nbtheta), gamma(nbgamma)
c in FORTRAN, matrix are stored in the inverted way than in S
       double precision x(nbvar, nbobs),  dfmod(nbtheta, nbobs)
      double precision fmod(nbobs)
      double precision resder(6)
      integer le, ie


      external racine1,derive1
      double precision  racine1

c     
c     Definition des communs
c

      double precision xa2
      common/cstes/xa2
      double precision pmsg,init,h
      common/don/pmsg,init,h
      double precision y
      common/valobs/ y(30)
      double precision xh
      common/ctenag/ xh

c       call dblepr("XH",2,xh,1)
c       call dblepr("XA2",3,xa2,1)
c       call dblepr("Y",1,y,30)

c        call dblepr("X",1,x,(nbobs*nbvar))

      do 10 i=1,nbobs
c In FORTRAN, the first variable is in the first dimension:
c Not:    pmsg=x(i,1) but:
      pmsg=x(1,i)
      init=y(i)
      h=xh
c        call dblepr("PMSG",4,pmsg,1)
c        call dblepr("INIT",4,init,1)
c        call dblepr("H",1,h,1)
c        call dblepr("THETA",5,theta,6)
c        call intpr("NBOBS",5,nbobs,1)
c        call intpr("NBTHETA",7,nbtheta,1)
      fmod(i)=racine1(6,theta)
      call derive1(resder,theta)
      do 20 k=1,nbtheta
c Be careful: in FORTRAN, the index for the variables is the first one:
         dfmod(k,i)=resder(k)
c        call dblepr("DFMOD",5,dfmod(k, i),1)
 20   continue   
c        call  dblepr("FMOD",4,fmod(i),1)
c        call dblepr("RESDER",6,resder,6)
 10   continue


c        call intpr("NBTHETA FIN",11,nbtheta,1)
c        call intpr("NBgamma FIN",11,nbgamma,1)
c        call intpr("NBobs FIN  ",11,nbobs,1)
c        call intpr("NBvar FIN  ",11,nbvar,1)
c        call dblepr("THETA",5,theta,6)
c        call dblepr("X    ",5, x,nbobs)
c        call dblepr("FMOD ",5,fmod,nbobs)
c        call dblepr("DFMOD",5,dfmod,(nbobs*nbtheta))
      le=0
      ie=0      
c        call intpr ("LE   ",5,le,1)
c        call intpr ("IE   ",5,ie,1)
      mycalcf=0
      end

c ------------------------------
c     initialisation des communs fortran
c ------------------------------

      subroutine initcommon(yvoulu, xhvoulu, xa2voulu,nbobs)
      integer nbobs
      double precision yvoulu(nbobs), xhvoulu, xa2voulu
      double precision y
      common/valobs/ y(30)
      double precision xh
      common/ctenag/ xh
      double precision xa2
      common/cstes/xa2
      
      xa2=xa2voulu
      xh=xhvoulu
      do 10 i =1, nbobs
         y(i)=yvoulu(i)
 10   continue
c        call intpr("NBOBS",5,nbobs,1)
c        call dblepr("XH",2,xh,1)
c        call dblepr("XA2",3,xa2,1)
c        call dblepr("Y",1,y,27)
      return
      end



c -----------------------------------------------
c        racine1: Fonction de calcul de la racine 
c        y=f(pmsg,theta) de F(y,pmsg,theta)=0
c -----------------------------------------------
      double precision function racine1(nbtheta,theta)
c       Arguments d'entree:
c       theta: valeur courante du parametre,
      integer nbtheta
      double precision theta(nbtheta)

c       Les fonctions appelees: 
      external c05agf,Fonc1
      double precision Fonc1
CC    external c05agf

c       Locals: les arguments de la fonction Nag appelee:
      double precision a,b,x, eps, eta      
      integer ifail

c        Les constantes du probleme:
      double precision xa2
      common/cstes/xa2
      double precision pmsg,init,h
      common/don/pmsg,init,h

c        La valeur courante du parametre:
      double precision parametre
      common /param/parametre(6)

      do 10 i=1,nbtheta
        parametre(i)=theta(i)
 10   continue   
      if(pmsg.eq.-1.) then
       racine1=theta(5)
       return
      endif
      if(pmsg.eq.99999.) then
       racine1=theta(6)
       return
      endif

c       Appel de la fonction  Nag:
      x=init -theta(6)
      eps=1.0d-10
      eta=0.d0
      ifail=0
      call c05agf(x, h, eps, eta, Fonc1,a,b,ifail)
      racine1=x + theta(6)
      return
      end


c ---------------------------------------------------------
c        Fonc1: Fonction appelee par c05agf dans racine1
c     calcul de la fonction implicite F1(y1,pmsg,theta)=Fonc1
c         par l'intermediaire des fonctions S1,V1
c --------------------------------------------------------
      double precision function Fonc1(z)
      double precision z

c       Fonctions appelees:
      external S1,V1
      double precision S1,V1

c        Les commons:
      double precision xa2
      common/cstes/xa2
      double precision pmsg,init,h
      common/don/pmsg,init,h
c        La valeur courante des parametres:
      double precision parametre
      common /param/ parametre(6)


      z=z
      Fonc1= z+pmsg-parametre(2)+S1(z)-V1(S1(z))-
     &     (xa2*parametre(1)*V1(S1(z)))/
     &     ((1.D0+parametre(4)*S1(z))*parametre(1)*V1(S1(z))+1.D0)

      return
      end



c -----------------------------------------------
c        V1: Fonction appelee par Fonc1
c -----------------------------------------------
      double precision function V1(u)
      double precision u

c       Fonction appelee:
      external P1
      double precision P1


c        Les commons:
c        Les constantes du probleme:
      double precision xa2
      common/cstes/xa2

      double precision pmsg,init,h
      common/don/pmsg,init,h

c        La valeur courante du parametre:
      double precision parametre
      common/param/ parametre(6)

c       Locals:
      double precision temp,temp0

      temp0=P1(u)
      temp=(1.D0+parametre(3)*u+parametre(1)*(xa2-pmsg)*
     &      (1.D0+parametre(4)*u))**2+
     &      4.D0*parametre(1)*pmsg*temp0
      V1=(-(1.D0+parametre(3)*u+parametre(1)*(xa2-pmsg)*
     & (1.D0+parametre(4)*u))
     & +dsqrt(temp))/ (2.D0*parametre(1)*temp0)
c      Wite(6,*) temp0, V1
      return
      end

c --------------------------------
c     S1: Fonction appelee par Fonc1
c --------------------------------
      double precision function S1(u)
      double precision u

c        Les commons:
c        Les constantes du probleme:
      double precision xa2
      common/cstes/xa2
      double precision parametre
      common/param/ parametre(6)
 
      S1=u/(parametre(3)*((parametre(5)-parametre(6))-u))
      return
      end

c -----------------------------------------------
c        P1: Fonction appelee par V1
c -----------------------------------------------
      double precision function P1(u)
      double precision u

c        Les commons:
c        Les constantes du probleme:
      double precision xa2
      common/cstes/xa2
c        La valeur courante du parametre:
      double precision parametre
      common /param/ parametre(6)

      P1=(1.D0+parametre(4)*u)*(1.D0+parametre(3)*u)
      return
      end


c -----------------------------------------------
c        derive1: Fonction de calcul de la derivee 
c        par rapport a k1,ro,Kl,ka en (x4i(j),Kl,k1,ro,ka)
c -----------------------------------------------
      subroutine derive1(der1,theta)
c       Les arguments d'entree
      double precision der1(6),theta(6)

c        Les fonctions appelees:
      external e04hbf,funct1
CC    external e04hbf

c        Les commons:
c       L'indicateur d'erreur
      integer ierr
      common / erreur/ ierr


c     Le parametre actif pour le calcul de derivee
c      integer paractif
c      common /pact/paractif
c       La valeur courante des parametres pour la derivee
      double precision parder
      common /paramd/parder(6)  
c       Les arguments de la fonction Nag appelee:
      integer ifail,nf,lh,liw,lw
      double precision F
      double precision delta(6),G(6),
     &    hesd(6),hesl(15),W(12)
      integer iw(1)

c       Appel de la fonction Nag:
      n=6
      do 11 j=1,n
         parder(j)=theta(j)
 11   continue
 
      ifail=0
      lh=15
      liw=1
      lw=12
      call e04hbf(n,funct1,parder,nf,delta,hesl,lh,hesd,F,G,iw,liw,
     &       W,lw,ifail)

         if (ifail.ne.0) then
             ierr = ERRMATH
             return
         endif

       do 20 j=1,n
       der1(j)=G(j)
 20   continue

      return
      end

c ---------------------------------------------------
c        funct1: Fonction appelee par e04hbf dans derive1
c ---------------------------------------------------
      subroutine funct1(iflag,n,xc,FC,GC,iw,liw,w,lw)
      
      double precision FC
      integer liw,lw,n,iflag
      double precision GC(n),w(lw),xc(n)
      integer iw(liw)
c       La valeur courante des parametres pour la derivee
      double precision parder
      common /paramd/parder(6)  
c       Les fonctions appelees:
      external racine1
      double precision racine1
      do 10 j=1,n
         xc(j)=parder(j)
 10   continue

      FC=racine1(n,xc)
      
      return
      end


       integer function mycalcv(nbtheta,nbbeta,
     &         nbgamma,nbobs,nbvar,
     &         theta,beta,gamma,fmod,dfmod,x,
     &         vmod, dvmodt, dvmodb,le,ie)


c in FORTRAN, matrix are stored in the inverted way than in S
      integer nbtheta, nbbeta, nbgamma, nbobs, nbvar
      double precision theta(nbtheta), beta(nbbeta), gamma(nbgamma)
       double precision x(nbvar, nbobs),  dfmod(nbtheta, nbobs)
      double precision dvmodt(nbtheta, nbobs), dvmodb(nbbeta, nbobs)
      double precision fmod(nbobs), vmod(nbobs)
      integer le, ie


      double precision un, zero

c        call intpr("NBOBS",5,nbobs,1)
c        call intpr("NBTHETA",7,nbtheta,1)
c        call intpr("NBBETA",6,nbbeta,1)
c        call intpr("NBgamA",6,nbgamma,1)
c        call dblepr("THETA",5,theta,6)

      un=1.0
      zero=0.0
      do 10 i=1,nbobs
      vmod(i)=un
      do 20 k=1,nbtheta
c Be careful: in FORTRAN, the index for the variables is the first one:
         dvmodt(k,i)=zero
 20   continue   
 10   continue

       mycalcv=0
       return
       end
