#include <stdio.h>
#include <math.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "nlmacros.h"
#include "nlfonc.h"

/* Maximum number of sets of observations */
#define MAXSET 10
/* Maximum number of regression parameters */
#define MAXPAR 10

short int calcf_(nbt, nbg, nbl, nbc, t, g, x, f, df, le, ie)
      short int nbt, nbg, nbl, nbc;
      double *t, *g, **x, *f, **df;
      short int *le, *ie;
{
/* Declarations of the functions that calculate the models: */
/* -------------------------------------------------------  */
     TShortInt  modscat_(), modeli_(), mycalcf_();

/* Note:
  ----- 
The parameters are in the order specified in the formal description file:
 here t contains: ka, r0, k1, kl, l0, ns, alpha */

/* the vectors that will contain the parameters of each model: */
     double tpar[MAXPAR];

/* to store the value of the second level parameter:
    here, a scalar, because only one at a time */
     double geli;

/* the counters of observations in each set of observations */
 TShortInt lgset[MAXSET]; 


/* Arguments of the Fortran program : we use the standard types
   because this program does not know the nl-types */
  int nbtheta, nbgamma, nbobs, nbvar, lef, ief;
  int Codee;

/* Other declarations : */
 TShortInt i,j, iset, Code;


/* Write my name in the trace
   -------------------------- */
ECRTRACE("calcf");

/* Affect the numbers of observations in each set of data
   ------------------------------------------------------ */
/* Initialisation: */
for (i=0; i<MAXSET; i++)
  {
  lgset[i]=0;
  }
/* Affect the counters:
  the last variable is the index of the set (from 1) */
for (i=0; i<nbl; i++)
  {
  lgset[(int)x[i][nbc-1]-1]++;
  }

/* Call to the first model: scatchard
   ----------------------------------- */
iset=0;
i=0;           /* evaluate it on observations from the first one */
tpar[0]=t[2]; /* t[2] is the third parameter specified in the formal model description: k1 */
tpar[1]=t[1]; /* t[1] is parameter r0 */
Code = modscat_(2, 0, lgset[iset], nbc, tpar, g, 
        &(x[i]),&(f[i]), &(df[i]), le, ie);
/* Note: no second level parameter in this model */
if (Code !=OK)
  {
  printf("Error in evaluating model 'modscat'\n");
  return(Code);
  }

/* Call to the second model: elisa
   -------------------------------- */
i=i+lgset[iset];  /* evaluate it on the subsequent observations */
iset=iset+1;
tpar[0]=t[0];  /* t[0] is parameter ka */
tpar[1]=t[6];  /* t[6] is parameter alpha */
/* First model elisa */
geli=g[0];  /* first value of the second level parameter */
Code = modeli_(2, 1, lgset[iset] , nbc, tpar, &(geli),
        &(x[i]),&(f[i]), &(df[i]), le, ie);
if (Code !=OK)
  {
  printf("Error in evaluating first model 'modeli'\n");
  return(Code);
  }

/* Second model elisa */
i=i+lgset[iset];  /* evaluate it on the subsequent observations */
iset=iset+1;
geli=g[1];  /* second value of the second level parameter */
Code = modeli_(2, 1, lgset[iset] , nbc, tpar, &(geli),
        &(x[i]),&(f[i]), &(df[i]), le, ie);
if (Code !=OK)
  {
  printf("Error in evaluating second model 'modeli'\n");
  return(Code);
  }


/* Call to the third model: inhib
   ------------------------------ */
i=i+ lgset[iset];  /* evaluate it on the subsequent observations */
iset=iset+1;
for (j=0; j<=6; j++)
  {
  tpar[j]=t[j]; /* the parameters are ka, r0, k1, kl, l0, ns */
  }

/*  The program that calculate the model is in Fortran:
  we must convert the arguments "TShortInt" into "int" */
nbtheta = (int)(nbt-1); /* number of parameters */
nbgamma = (int)0;       /* no second level parameter */
nbobs = (int)lgset[iset];  /* number of observations */
nbvar = (int)nbc;       /* number of variables */

Codee = mycalcf_( &nbtheta, &nbgamma, &nbobs, &nbvar,
                   tpar ,g, 
                   &(x[i][0]),&(f[i]),
                   &(df[i][0]),&lef,&ief); 

/* Convert the output arguments and the returned value */
Code = (TShortInt)Codee;
if (Code !=OK)
  {
  printf("Error in evaluating model 'inhib'\n");
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  return(Code);
  }
return(OK);
}


/* --------------------------------------------------
   calcv
 ---------------------------------------------------- */

short int calcv_(nbt, nbb, nbg, nbl, nbc, t, b, g,
                f, df, x, v, dtv, dbv, le, ie)
      short int nbt, nbb, nbg, nbl, nbc;
      double *t, *b, *g, **x, *v, **dtv, **dbv, *f, **df;
      short int *le, *ie;

{
/* Declarations of the functions that calculate the models: */
/* -------------------------------------------------------  */
     TShortInt  varscat_(), vareli_(), mycalcv_();

/* the vectors that will contain the parameters of each model:
   Note: no parameters for the variance */
        double tpar[MAXPAR];

/* to store the value of the second level parameter: 
    here, a scalar, because only one at a time */
     double geli;

/* the counters of observations in each set of observations */
 TShortInt lgset[MAXSET]; 

/* Arguments of the Fortran program : we use the standard types
   because this program does not know the nl-types */
  int nbtheta, nbbeta, nbgamma, nbobs, nbvar, lef, ief;
  int Codee;

/* Other declarations : */
 TShortInt i,j, iset, Code;


/* Write my name in the trace
   -------------------------- */
ECRTRACE("calcv");

/* Affect the numbers of observations in each set of data
   ------------------------------------------------------ */
/* Initialisation: */
for (i=0; i<MAXSET; i++)
  {
  lgset[i]=0;
  }
/* Affect the counters:
  the last variable is the index of the set (from 1) */
for (i=0; i<nbl; i++)
  {
  lgset[(int)x[i][nbc-1]-1]++;
  }

/* Call to the first model: scatchard
   ----------------------------------- */
iset=0;
i=0;           /* evaluate it on observations from the first one */
tpar[0]=t[2]; /* t[2] is the third parameter specified in the formal model description: k1 */
tpar[1]=t[1]; /* t[1] is parameter r0 */
Code = varscat_(2, 0, 0, lgset[iset], nbc, tpar, b, g, 
        &(f[i]), &(df[i]),
        &(x[i]), &(v[i]), &(dtv[i]), &(dbv[i]), le, ie);
if (Code !=OK)
  {
  printf("Error in evaluating model 'varscat'\n");
  return(Code);
  }

/* Call to the second model: elisa
   -------------------------------- */
i=i+lgset[iset];  /* evaluate it on the subsequent observations */
iset=iset+1;
tpar[0]=t[0];  /* t[0] is parameter ka */
tpar[1]=t[6];  /* t[6] is parameter alpha */
/* First model elisa */
geli=g[0];  /* first value of the second level parameter */
Code = vareli_(2, 0, 1, lgset[iset] , nbc, tpar, b, &(geli),
        &(f[i]), &(df[i]),
         &(x[i]), &(v[i]), &(dtv[i]), &(dbv[i]), le, ie);
if (Code !=OK)
  {
  printf("Error in evaluating first model 'vareli'\n");
  return(Code);
  }

/* Second model elisa */
i=i+lgset[iset];  /* evaluate it on the subsequent observations */
iset=iset+1;
geli=g[1];  /* second value of the second level parameter */
Code = vareli_(2, 0, 1, lgset[iset] , nbc, tpar, b, &(geli),
        &(f[i]), &(df[i]),
         &(x[i]), &(v[i]), &(dtv[i]), &(dbv[i]), le, ie);
if (Code !=OK)
  {
  printf("Error in evaluating second model 'vareli'\n");
  return(Code);
  }


/* Call to the third model: inhib
   ------------------------------ */
i=i+ lgset[iset];  /* evaluate it on the subsequent observations */
iset=iset+1;
for (j=0; j<=6; j++)
  tpar[j]=t[j];

 /* the parameters are ka, r0, k1, kl, l0, ns */

/*  The program that calculate the model is in Fortran:
  we must convert the arguments "TShortInt" into "int" */
nbtheta = (int)(nbt-1); /* number of parameters */
nbbeta = (int)0;
nbgamma = (int)0;       /* no second level parameter */
nbobs = (int)lgset[iset];  /* number of observations */
nbvar = (int)nbc;       /* number of variables */

Codee = mycalcv_( &nbtheta, &nbbeta, &nbgamma, &nbobs, &nbvar,
                   tpar, b, g, 
                   &(f[i]), &(df[i][0]),
                   &(x[i][0]),&(v[i]),
                   &(dtv[i][0]), &(dbv[i][0]), &lef,&ief); 

/* Convert the output arguments and the returned value */
Code = (TShortInt)Codee;
if (Code !=OK)
  {
  printf("Error in evaluating model 'mycalcv'\n");
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  return(Code);
  }
return(OK);
}





calcodes_()
{}

calcjac_()
{}

calcphi_()
{}
