c/*--------------- Identification fonction ----------
c| Nom de la fonction    : initcommon               |
c| Role                  : initialisation des       |
c|      commons Fortran                             |
c| Parametres d'entree   :                          |
c|  les valeurs des commons                         |
c--------------------------------------------------*/
c
c/*--------------- Definition fonction ------------*/

       subroutine initcommon(
     &                        xaVoulu,xrVoulu,clVoulu,cnsVoulu,
     &                        xkVoulu,xkaVoulu, xk1Voulu,coefVoulu,
     &                        hVoulu, epsVoulu, etaVoulu, hbaseVoulu,
     &                        nbobs,  x ,y)

       double precision xaVoulu,xrVoulu,clVoulu,cnsVoulu,
     &                  xkVoulu,xkaVoulu,xk1Voulu,coefVoulu
       double precision hVoulu, epsVoulu, etaVoulu, hbaseVoulu
       integer nbobs
       double precision x(nbobs),y(nbobs)

c        Les commons:
c        Les constantes du probleme:
       double precision xa,xr,cl,cns,xk,xka,xk1,coef
       common/ctes/xa,xr,cl,cns,xk,xka,xk1,coef

c        Les arguments numeriques des fonctions Nag appelees:
       double precision h, eps, eta, hbase
       common / ctesnag/h, eps, eta, hbase

c        Les valeurs de la reponse et de la variable explicative:
       double precision xobs,yobs
       common/valobs/yobs(24), xobs(24,1)

c        On remplit le common des constantes du probleme:
       xa=xaVoulu
       xr=xrVoulu
       cl=clVoulu
       cns=cnsVoulu
       xk=xkVoulu
       xka=xkaVoulu
       xk1=xk1Voulu
       coef=coefVoulu

c        On remplit le common des arguments des fonctions Nag:
       h=hVoulu
       eps=epsVoulu
       eta=etaVoulu
       hbase=hbaseVoulu 

c        On remplit le common des observations:
       do 10 i=1,nbobs
       xobs(i,1)=x(i)
       yobs(i)=y(i)
  10   continue

      return
      end

c/*--------------- Identification fonction ----------
c| Nom de la fonction    : mycalcf                 |
c| Role                  : calcul de mon modele     |
c| Parametres d'entree   :                          |
c|  nbtheta: nombre de parametres Theta             |
c|  nbgamma: nombre de  parametres de second niveau |
c|  nbobs: nombre d'observations                    |
c|  nbvar: nombre de variables explicatives         |
c|  theta: les nbtheta valeurs des parametres Theta |
c|  gamma: les nbgamma valeurs des parametres Gamma |
c|  x: la matrice des observations                  |
c|    (nbobs*nbvar valeurs: x(j,i)= valeur de la    |
c|    j-ieme variable pour la i-ieme observation)   |
c| Parametres de sortie  :                          |
c|  fmod: les nbobs valeurs ajustees de f           |
c|  dfmod: les valeurs des derivees de f            |
c|   (nbobs*nbtheta valeurs: dfmod(t,i)=valeur de la|
c|    derivee par rapport au t-ieme parametre pour  |
c|    l'observation i)                              |
c|  le: en cas d'erreur, precise si l'erreur a lieu |
c|    lors du calcul de f ou de ses derivees        |
c|  ie: en cas d'erreur, indice de l'observation ou |
c|    l'erreur s'est produit                        |
c| Retour fonction: OK si tout s'est bien passe,    |
c|    code d'erreur sinon                           |
c--------------------------------------------------*/
c
c/*--------------- Definition fonction ------------*/

      integer function mycalcf
     1 (nbtheta,nbgamma,nbobs,nbvar,
     2 theta,gamma,x,fmod,dfmod,le,ie)
c        Arguments d'entree:
      integer nbtheta,nbgamma,nbobs,nbvar
      double precision theta(nbtheta), gamma(nbgamma) ,x(nbobs,nbvar)
c        Arguments de sortie:  
      double precision fmod(nbobs),dfmod(nbobs,nbtheta)
c        Arguments de sortie en cas d'erreur:
      integer le,ie

c/*--------------- Fin identification fonction ----*/

c        Les fonctions appelees:
      external racine,derive
      double precision racine,derive

c        Les commons:
c       L'indice courant de la repetition
      integer irepet
      common /indice/irepet
c       L'indicateur d'erreur
      integer ierr
      common / erreur/ ierr

c        Local:
       integer j

c       Initialisation de l'indicateur d'erreur
       ierr = OK
c       Boucle sur les observations
      do 10 j=1,nbobs
c          on remplit le common indice:
        irepet =(j-1)*3 +1 
c          calcul de la racine:
        fmod(j) =racine(theta(1))
c          on remplit les arguments de sortie en cas d'erreur:
        if (ierr.ne.OK) then
             le = F
             ie = j
             mycalcf= ERRMATH
             return
         endif
c          calcul de la derivee:
        dfmod(j,1)=derive()
        if (ierr.ne.OK) then
             le = DF
             ie = j
             mycalcf= ERRMATH
             return
         endif
 10    continue

      mycalcf=OK
      return
      end

c -----------------------------------------------
c        racine: Fonction de calcul de la racine 
c        y=f(x(j),theta) de F(y,x(j),theta)=0
c -----------------------------------------------
      double precision function racine(theta)
c       Arguments d'entree:
c       theta: valeur courante du parametre,
      double precision theta

c       Les fonctions appelees: 
      external c05agf,Fonc
      double precision Fonc

c       Les commons:
c        Les constantes du probleme:
      double precision xa,xr,cl,cns,xk,xka,xk1,coef
      common/ctes/xa,xr,cl,cns,xk,xka,xk1,coef
c        Les arguments numeriques des fonctions Nag appelees:
       double precision h, eps, eta, hbase
       common / ctesnag/h, eps, eta, hbase
c        Les valeurs de la reponse et de la variable explicative:
      double precision xobs,yobs
      common/valobs/yobs(24), xobs(24,1)
c       L'indice courant de la repetition
      integer irepet
      common /indice/irepet
c       L'indicateur d'erreur
      integer ierr
      common / erreur/ ierr
c        La valeur courante du parametre:
      double precision parametre
      common parametre

c       Locals: les arguments de la fonction Nag appelee:
c       a et b sont ignores 
      double precision a,b,x
      integer ifail

c       On remplit le common parametre:
      parametre=theta
c       Calcul du point d'observation:
c     moyenne ponderee des valeurs observees sur 
c     les 3 repetitions de l'observation:
      x=(yobs(irepet)+yobs(irepet+1)+yobs(irepet+2))*
     1  coef*1.d-6/(6.d0*3.d0)

c       Appel de la fonction  Nag:
      ifail=0
      call c05agf(x, h, eps, eta, Fonc,a,b,ifail)
c        positionner l'indicateur si erreur:
        if (ifail.ne.0) then
             ierr = ERRMATH
             racine= ERRMATH
             return
         endif
c        On effectue sur le resultat la ponderation inverse
c      de celle operee sur les entrees:
      racine = (x * 6.d0)/ (coef*1.d-6)
      return
      end

c -----------------------------------------------
c        derive: Fonction de calcul de la derivee 
c        par rapport a theta en (xi(j),theta)
c -----------------------------------------------
      double precision function derive()

c        Les fonctions appelees:
      external d04aaf,Fun
      double precision Fun

c        Les commons:
c        Les arguments numeriques des fonctions Nag appelees:
       double precision h, eps, eta, hbase
       common / ctesnag/h, eps, eta, hbase
c       L'indicateur d'erreur
      integer ierr
      common / erreur/ ierr
c        La valeur courante du parametre:
      double precision parametre
      common parametre
c       Les arguments de la fonction Nag appelee:
      double precision pval,der(1),erest(1)
      integer ifail

c       Appel de la fonction Nag:
      pval=parametre
      ifail=0
      call d04aaf(pval,1 ,hbase,der,erest,Fun,ifail)
c        positionner l'indicateur si erreur:
        if (ifail.ne.0) then
             ierr = ERRMATH
             derive= ERRMATH
             return
         endif
      derive=der(1)
      return
      end

c ---------------------------------------------------
c        Fun: Fonction appelee par d04aaf dans derive
c ---------------------------------------------------
      double precision function Fun(theta)
      double precision theta

c       Les fonctions appelees:
      external racine
      double precision racine

      Fun=racine(theta)
      return
      end

c ---------------------------------------------------------
c        Fonc: Fonction appelee par c05agf dans racine
c     calcul de la fonction implicite F(y,xi(j),theta)=Fonc
c         par l'intermediaire des fonctions S,P,V
c --------------------------------------------------------
      double precision function Fonc(z)
      double precision z

c       Fonctions appelees:
      external S,V
      double precision S,V

c        Les commons:
c        Les constantes du probleme:
      double precision xa,xr,cl,cns,xk,xka,xk1,coef
      common/ctes/xa,xr,cl,cns,xk,xka,xk1,coef
c        Les valeurs de la reponse et de la variable explicative:
      double precision xobs,yobs
      common/valobs/yobs(24), xobs(24,1)
c       L'indice courant de la repetition
      integer irepet
      common /indice/irepet
c        La valeur courante du parametre:
      double precision parametre
      common parametre

      Fonc= z+xobs(irepet,1)-xr+S(z)-V(S(z))-
     &     (xa*xka*V(S(z)))/
     &     ((1.D0+parametre*S(z))*xka*V(S(z))+1.D0)
      return
      end

c -----------------------------------------------
c        V: Fonction appelee par Fonc
c -----------------------------------------------
      double precision function V(u)
      double precision u

c       Fonction appelee:
      external P
      double precision P

c        Les commons:
c        Les constantes du probleme:
      double precision xa,xr,cl,cns,xk,xka,xk1,coef
      common/ctes/xa,xr,cl,cns,xk,xka,xk1,coef
c        Les valeurs de la reponse et de la variable explicative:
      double precision xobs,yobs
      common/valobs/yobs(24), xobs(24,1)
c       L'indice courant de la repetition
      integer irepet
      common /indice/irepet
c        La valeur courante du parametre:
      double precision parametre
      common parametre

c       Locals:
      double precision temp,temp0

      temp0=P(u)
      temp=(1.D0+xk*u+xka*(xa-xobs(irepet,1))*
     &      (1.D0+parametre*u))**2+
     &      4.D0*xka*xobs(irepet,1)*temp0
      V=(-(1.D0+xk*u+xka*(xa-xobs(irepet,1))*(1.D0+parametre*u))
     & +dsqrt(temp))/ (2.D0*xka*temp0)
      return
      end

c --------------------------------
c     S: Fonction appelee par Fonc
c --------------------------------
      double precision function S(u)
      double precision u

c        Les commons:
c        Les constantes du probleme:
      double precision xa,xr,cl,cns,xk,xka,xk1,coef
      common/ctes/xa,xr,cl,cns,xk,xka,xk1,coef

      S=u/(xk1*((cl-cns)*(coef*1.d-6/6.d0)-u))
      return
      end

c -----------------------------------------------
c        P: Fonction appelee par V
c -----------------------------------------------
      double precision function P(u)
      double precision u

c        Les commons:
c        Les constantes du probleme:
      double precision xa,xr,cl,cns,xk,xka,xk1,coef
      common/ctes/xa,xr,cl,cns,xk,xka,xk1,coef
c        La valeur courante du parametre:
      double precision parametre
      common parametre

      P=(1.D0+parametre*u)*(1.D0+xk*u)
      return
      end


c ------------------------------------------------
c      calcv: fonction vide
c ------------------------------------------------
       integer function mycalcv(nbtheta,nbbeta,
     &         nbgamma,nbobs,nbvar,
     &         theta,beta,gamma,fmod,dfmod,x,
     &         vmod, dvmodt, dvmodb,le,ie)
       calcv=0
       return
       end


      integer function mycalcodes()
      end

      integer function mycalcphi()
      end

      integer function mycalcpsi()
      end
