/*----------------------------------------
description file: vaso.m

% file vaso.m
% linear logistic regression model
%  
resp y; 
varind vol,rate;
aux eta,p; 
var v;
parresp t0,t1,t2;
subroutine;
begin 
eta=t0+t1*log(vol)+t2*log(rate);
p=exp(eta)/(1+exp(eta));
y=p;
v = (1-p)*p;
end 
----------------------------------------*/
#include <stdio.h>
#include <math.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "nlmacros.h"
#include "nlfonc.h"

short int calcf_(nbt, nbg, nbl, nbc, t, g, x, f, df, le, ie)
      short int nbt, nbg, nbl, nbc;
      double *t, *g, **x, *f, **df;
      short int *le, *ie;
{
short int i;
double res;
double a[2], da[2][3];
ECRTRACE("calcf");
for (i=0; i<nbl; i++)
  {
    res= ((t[0]) + ((t[1]) * (myln(x[i][0])))) + ((t[2]) * (
      myln(x[i][1])));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=A;
        return(ERRMATH);
      }
    a[0]= res;
    res= mydiv((double)myexp(a[0]), ((double)1) + (
      (double)myexp(a[0])));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=A;
        return(ERRMATH);
      }
    a[1]= res;
    res= a[1];
    f[i]= res;
    res= (double)1;
    da[0][0]= res;
    res= myln(x[i][0]);
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[0][1]= res;
    res= myln(x[i][1]);
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[0][2]= res;
    res= mydiv((((da[0][0]) * ((double)myexp(a[0]))) * ((
      (double)1) + ((double)myexp(a[0])))) - (((double)myexp(
      a[0])) * ((da[0][0]) * ((double)myexp(a[0])))), mypow(
      ((double)1) + ((double)myexp(a[0])), 
      (double)2));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[1][0]= res;
    res= mydiv((((da[0][1]) * ((double)myexp(a[0]))) * ((
      (double)1) + ((double)myexp(a[0])))) - (((double)myexp(
      a[0])) * ((da[0][1]) * ((double)myexp(a[0])))), mypow(
      ((double)1) + ((double)myexp(a[0])), 
      (double)2));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[1][1]= res;
    res= mydiv((((da[0][2]) * ((double)myexp(a[0]))) * ((
      (double)1) + ((double)myexp(a[0])))) - (((double)myexp(
      a[0])) * ((da[0][2]) * ((double)myexp(a[0])))), mypow(
      ((double)1) + ((double)myexp(a[0])), 
      (double)2));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[1][2]= res;
    res= da[1][0];
    df[i][0]= res;
    res= da[1][1];
    df[i][1]= res;
    res= da[1][2];
    df[i][2]= res;
  }
return(OK);
}

short int calcv_(nbt, nbb, nbg, nbl, nbc, t, b, g,
                f, df, x, v, dtv, dbv, le, ie)
      short int nbt, nbb, nbg, nbl, nbc;
      double *t, *b, *g, **x, *v, **dtv, **dbv, *f, **df;
      short int *le, *ie;
{
short int i;
double res;
double a[2], da[2][3];
ECRTRACE("calcv");
for (i=0; i<nbl; i++)
  {
    res= ((t[0]) + ((t[1]) * (myln(x[i][0])))) + ((t[2]) * (
      myln(x[i][1])));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=A;
        return(ERRMATH);
      }
    a[0]= res;
    res= mydiv((double)myexp(a[0]), ((double)1) + (
      (double)myexp(a[0])));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=A;
        return(ERRMATH);
      }
    a[1]= res;
    res= (((double)1) - (a[1])) * (a[1]);
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=V;
        return(ERRMATH);
      }
    v[i]= res;
    res= (double)1;
    da[0][0]= res;
    res= myln(x[i][0]);
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[0][1]= res;
    res= myln(x[i][1]);
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[0][2]= res;
    res= mydiv((((da[0][0]) * ((double)myexp(a[0]))) * ((
      (double)1) + ((double)myexp(a[0])))) - (((double)myexp(
      a[0])) * ((da[0][0]) * ((double)myexp(a[0])))), mypow(
      ((double)1) + ((double)myexp(a[0])), 
      (double)2));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[1][0]= res;
    res= mydiv((((da[0][1]) * ((double)myexp(a[0]))) * ((
      (double)1) + ((double)myexp(a[0])))) - (((double)myexp(
      a[0])) * ((da[0][1]) * ((double)myexp(a[0])))), mypow(
      ((double)1) + ((double)myexp(a[0])), 
      (double)2));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[1][1]= res;
    res= mydiv((((da[0][2]) * ((double)myexp(a[0]))) * ((
      (double)1) + ((double)myexp(a[0])))) - (((double)myexp(
      a[0])) * ((da[0][2]) * ((double)myexp(a[0])))), mypow(
      ((double)1) + ((double)myexp(a[0])), 
      (double)2));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DADT;
        return(ERRMATH);
      }
    da[1][2]= res;
    res= ((((double)1) - (a[1])) * (da[1][0])) + (
      (-(da[1][0])) * (a[1]));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DVDT;
        return(ERRMATH);
      }
    dtv[i][0]= res;
    res= ((((double)1) - (a[1])) * (da[1][1])) + (
      (-(da[1][1])) * (a[1]));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DVDT;
        return(ERRMATH);
      }
    dtv[i][1]= res;
    res= ((((double)1) - (a[1])) * (da[1][2])) + (
      (-(da[1][2])) * (a[1]));
    if (finite(res)!=1)
      {
        *ie=i+1;
        *le=DVDT;
        return(ERRMATH);
      }
    dtv[i][2]= res;
  }
return(OK);
}

calcodes_()
{}

calcjac_()
{}

calcphi_()
{}
