# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("cheese")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 7.1.8")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Cheese example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation \n\n") 

nomlib <- loadnls2()
# Exemple cheese page 175, McNe

ctx <- list(theta.start=c(-8,rep(0,7),rep(0,3)), 
              sigma2.type="KNOWN", sigma2=1,
		family="multinomial", nameN="n")
cheese.nl1 <- nls2(cheese, cheese.m, stat.ctx=ctx, method="QLT",
 control=list(freq=0))

cat( "Result of the estimation process:\n ")
print(summary(cheese.nl1))

# ----------------------------------------------------------
cat("\n ---------------------------")
cat("\n Confidence intervals ") 
cat("\n\n") 

 if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/crPsi ", cheese.teta14.m, " > cheese.teta14.m.c", sep=""))
nomlib <-  loadnls2(psi="cheese.teta14.m.c")
teta14.conf <- confidence(cheese.nl1,
                            file=cheese.teta14.m)
result <- c(teta14.conf$psi, teta14.conf$std.error,
                  teta14.conf$normal.conf.int)
names(result) <- c("teta14","std.teta14","lower.IN","upper.IN")
cat("\nConfidence interval:","\n")
print(result)

cat("\n ---------------------------")
cat( "Minimum deviance:", cheese.nl1$deviance, 
     "X2(0.95,21)", qchisq(0.95,21), "\n\n" )

cat("\nPlot of cumulative residuals\n")
r <- length(unique(cheese$cat))
k <- length(unique(cheese$ch))
n <- rep(52,length(cheese$ch))
p <- cheese.nl1$response/n
P <- rep(1,length(p))
PI <- P
P[cheese$cat==1] <- p[cheese$cat==1]
PI[cheese$cat==1] <- cheese$y[cheese$cat==1]/n[cheese$cat==1]
for (l in (2:r)) {
  P[cheese$cat==l] <- P[cheese$cat==(l-1)] + p[cheese$cat==l]
  PI[cheese$cat==l] <- PI[cheese$cat==(l-1)] +
                    cheese$y[cheese$cat==l]/n[cheese$cat==1]
}
RES <- (n*PI-n*P)/sqrt(n*P*(1-P))
RES[cheese$cat==r] <- 0


if (interactive()) {X11(); par(ask=T)} else { postscript(file="cheese.ps"); par(ask=F)}

plot(c(1,r), range(RES), type="n", xlab="score",
       ylab="cumulative standardised residuals",las=1)
matpoints(1:r, t(matrix(RES,nrow=k)), pch=15:18)
title <- c("A","B","C","D")
if (is.R())
  legend(x=0.8, y=1.4, legend=title, pch=15:18, col=1:4) else
  legend(x=0.8, y=1.4, legend=title, marks=15:18, col=1:4)


# ---------------------------------------------------------------
cat("\nConfidence intervals for the cumulative probabilities $P_{l}(x_{i}, \theta)$ ")
 cat("\n ---------------------------\n")

# Careful: another loadnls2 is required because the model has changed
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/crPsi ", cheese.logit.proba.m, " > cheese.logit.proba.m.c", sep=""))
nomlib <- loadnls2(psi="cheese.logit.proba.m.c")

lP.conf <- confidence(cheese.nl1,
                            file=cheese.logit.proba.m,
                            varpsi=as.matrix(as.matrix(cheese[,c(1,2)])))
IN <- exp(lP.conf$normal.conf.int)/(1+exp(lP.conf$normal.conf.int))
result <- cbind(lP.conf$psi, lP.conf$std.error,
                lP.conf$normal.conf.int,
                exp(lP.conf$psi)/(1+exp(lP.conf$psi)), IN)
dimnames(result) <- list(NULL, c("logit.P", "std.logit.P", 
                    "lower.logit.IN", "upper.logit.IN", 
                    "P", "lower.l.IN", "upper.l.IN" ))
cat("\nConfidence intervals:","\n")
print(signif(result,digits=3))

plot(c(1,r), range(c(PI,P,IN)), type="n", 
     xlab="score", ylab="", las=1)
matpoints(1:r, t(matrix(PI,nrow=4)), pch=15:18)
matlines(1:r, t(matrix(P,nrow=4)), lty=1:4)
if (is.R())
 legend(x=1, y=1, legend=title, lty=1:4, pch=15:18, col=1:4) else
 legend(x=1, y=1, legend=title, lty=1:4, marks=15:18, col=1:4)
for (l in 1:k) {
if (is.R()) 
  segments(x0=1:r, y0=IN[cheese$ch==l,1],
           x1=1:r, y1=IN[cheese$ch==l,2],
           lty=l) else
  segments(x1=1:r, y1=IN[cheese$ch==l,1],
           x2=1:r, y2=IN[cheese$ch==l,2],
           lty=l)

}

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
if (!interactive()) dev.off()

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
