# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("corti")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 1.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Cortisol assay example ") 
cat("\n ---------------------------")
cat("\n\n") 

# ------------------------------------------------------------
# Creation of the model -evaluation programs
lesystem(paste(.Nls2dir, "/analDer ", corti.mod1, " > corti.mod1.c", sep=""))
lesystem(paste(.Nls2dir, "/analDer ", corti.mod6, " > corti.mod6.c", sep=""))
lesystem(paste(.Nls2dir, "/crPsi ", corti.D, " > corti.D.c", sep=""))
lesystem(paste(.Nls2dir, "/crInv ", corti.finv, " > corti.finv.c", sep=""))
# ------------------------------------------------------------

cat("\n Plot of the observed and fitted response values \n\n") 
logdose<-c(rep(-3,8),log10(corti$dose[9:60]),rep(2,4))

if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="corti.ps"); (ask.pause <- F)  }
par (ask=ask.pause)

plot(logdose,corti$cpm,xlab="log-dose",ylab="response",
      main="Cortisol example",sub="Observed and fitted response")

# ------------------------------------------------------------
nomlib <- loadnls2("corti.mod1.c")
corti.nl1<-nls2(corti,
                list(file=corti.mod1, gamf=c(0,10),vari.type="VI"),
                c(30,3000,0,1,1))

cat( "Estimated values of the parameters:\n ")
print( corti.nl1$theta); cat( "\n\n")
plot(logdose,corti$cpm,xlab="log-dose",ylab="response",
      main="Cortisol example",sub="Observed and fitted response")
lines(unique(logdose),corti.nl1$response)


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 2.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Cortisol assay example:") 
cat("\n confidence interval for D ") 
cat("\n ---------------------------\n\n")

cat("\n Parameters estimation \n\n") 
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("corti.mod1.c",   psi="corti.D.c")

cat("\n Confidence interval for D \n\n") 
corti.conf.D <- confidence(corti.nl1,file=corti.D,pbispsi=2000)
  # Print the results:
cat("\nEstimated value of D:", corti.conf.D$psi,"\n" )
cat("\nEstimated value of S:",corti.conf.D$std.error,"\n" )
cat("\nnu <- (0.975):", qnorm(0.975),"\n" )
cat("\nEstimated value of In:",corti.conf.D$normal.conf.int,"\n" )

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Cortisol assay example: ") 
cat("\n how to choose the variance function using replications? ") 
cat("\n ---------------------------")
cat("\n Estimation using a symmetric sigmoidally-shaped regression curve and") 
cat("\n  a constant variance ") 
cat("\n\n") 

corti.nl3<-nls2(corti, 
	 list(file=corti.mod1,gamf=c(0,10), eq.theta=c(rep(NaN,4),1)), 
	 c(corti.nl1$theta[1:4],1))
  # Print the main results
cat( "Estimated values of the parameters:\n ")
print(coef(corti.nl3))
cat( "Estimated value of sigma2:\n ")
print( corti.nl3$sigma2); cat( "\n\n")

cat("\n Plotting the response values") 
cat("\n and the residuals when the regression function is") 
cat("\n  a symmetric sigmoidally-shaped curve and the variance is constant ") 
cat("\n\n") 

 # Plot the observed and fitted values of the response
 # against the log-dose
plot(logdose,corti$cpm,xlab="log-dose",ylab="response")
title(main="Cortisol example",
    sub="Observed and adjusted response")
lines(unique(logdose),corti.nl3$response)

 # Plot the residuals 
plres(corti.nl3,
    wanted=list(F.R=T),
    absolute=T,
    title="Cortisol example", ask.pause=ask.pause)

cat("\n Plotting the empirical variances versus the empirical means") 
cat("\n  when the regression function is") 
cat("\n  a symmetric sigmoidally shaped curve and the variance is constant ") 
cat("\n\n") 

plvar(corti.nl3,wanted=list(Y.S2=T,Y.S=T,logY.logS2=T),
 smooth=T,
 title="Cortisol example", ask.pause=ask.pause)

cat("\n Estimation using a symmetric sigmoidally shaped regression curve and a heteroscedastic variance ") 
cat("\n\n") 

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("corti.mod6.c")

corti.nl6<-nls2(corti, 
	list(file= corti.mod6,gamf=c(0,10), eq.theta=c(rep(NaN,4),1)), 
	c(corti.nl1$theta[1:4],1))
  # Print the main results
cat( "Estimated values of the parameters:\n ")
print(coef(corti.nl6)) 
cat( "Estimated value of sigma2:\n ")
print( corti.nl6$sigma2); cat( "\n\n")

cat("\n Plotting the observed and fitted values of the response") 
cat("\n and the residuals") 
cat("\n when the regression function is") 
cat("\n  a symmetric sigmoidally shaped curve and the") 
cat("\n variance is heteroscedastic ") 
cat("\n\n") 

  # Plot the observed and fitted values of the response
  # against the log-dose
plot(logdose,corti$cpm,xlab="log-dose",ylab="response")
title(main="Cortisol example",
    sub="Observed and adjusted response")
lines(unique(logdose),corti.nl6$response)
  # Plot the residuals
plres(corti.nl6,
     wanted=list(F.R=T),
     absolute=T,st=T,smooth=T,
     title="Cortisol example", ask.pause=ask.pause, ask.modify=ask.pause)
abline(0,0)

cat("\n Estimation using a asymmetric sigmoidally shaped regression curve and an heteroscedastic variance ") 
cat("\n\n") 

corti.nl7<-nls2(corti,
   list(file=corti.mod6,gamf=c(0,10)),
   corti.nl6$theta)
   # Print the main results
cat( "Estimated values of the parameters:\n ")
print(coef(corti.nl7))
cat( "Estimated value of sigma2:\n ")
print( corti.nl7$sigma2); cat( "\n\n")


cat("\n Plotting the observed and fitted values of the response") 
cat("\n and the residuals") 
cat("\n when the regression the function is") 
cat("\n  a asymmetric sigmoidally shaped  curve and the") 
cat("\n variance is heteroscedastic ") 
cat("\n\n") 

  # Plot the observed and fitted values of the response
  # against the log-dose
 plot(logdose,corti$cpm,xlab="log-dose",ylab="response")
 title(main="Cortisol example",
    sub="Observed and adjusted response")
 lines(unique(logdose),corti.nl7$response)
 plres(corti.nl7,
     wanted=list(F.R=T),
     absolute=T,st=T,smooth=T,
     title="Cortisol example",ask.pause=ask.pause, ask.modify=ask.pause)
 abline(0,0)

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6: following")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Cortisol assay example: ") 
cat("\n misspecification tests ") 
cat("\n ---------------------------")

cat("\n Comparison of nested models ") 
cat("\n\n") 

Sl <- 64*(corti.nl6$loglik - corti.nl7$loglik)
cat( "Sl: ", Sl,  "X2(0.95,1):  ",qchisq(0.95,1),"\n ")

cat("\n Test when the regression function is symmetric ") 
cat("\n and the variance proportional to the squared") 
cat("\n expectation ") 
cat("\n\n") 

Sl <- sum(corti.nl6$replications*log(corti.nl6$variance))-
     sum(corti.nl6$replications*log(corti.nl6$data.stat$S2))
k <- length(corti.nl6$replications) # number of observations
cat( "Sl:", Sl,
 "\nX2(0.95,25):",qchisq(0.95, 2*k - 5),"\n\n"  )

cat("\n Test when the regression function is an asymmetric  sigmoidally-shaped curve") 
cat("\n and the variance heteroscedastic ") 
cat("\n\n") 

Sl <- sum(corti.nl7$replications*log(corti.nl7$variance))-
    sum(corti.nl7$replications*log(corti.nl7$data.stat$S2))
cat( "Sl:", Sl,
 "\nX2(0.95,24):",qchisq(0.95, 2*k - 6),"\n\n"  )

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 5.6")
cat("\n#------------------------------------------------------")
cat("\nLikelihood ratio type calibration interval for $x_{0}$")
cat("\nwith asymptotic level 95% ")
# Reduce max.lambda in stat.ctx to make converge 'calib'
ctx<- list(theta.start=corti.nl6$theta,  max.lambda=10e-5 )
corti.nl7<-nls2(corti,
   list(file=corti.mod6,gamf=c(0,10)),
   ctx)

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# Copy the file  /corti.mod6.dc.c
lesystem( paste("cp ",  .Nls2dir, "/data/corti.mod6.dc.c  .", sep=""))
nomlib <- loadnls2(
	model= "corti.mod6.c corti.mod6.dc.c",
	psi="",
	inv="corti.finv.c",
        tomyown= paste(.Nls2dir, "/nls2libs/EquNCalib.o", sep=""))
corti.calib<-calib(corti.nl7, file=corti.finv,
       x.bounds=c(0.02,0.08),
       ord=c(2144,2187,2325,2330))
if (!is.null(corti.calib)) {
cat("\nEstimated value of d:", corti.calib$x,"\n" )
cat("\nJr:",corti.calib$R.conf.int,"\n" )
	}

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 7.2.4")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Cortisol assay example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation: poisson ") 
cat("\n\n") 

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}; nomlib <- loadnls2()

ctx <- list( theta.start=corti.nl6$theta, 
             sigma2.type="KNOWN", sigma2=1,family="poisson")
model <- list(file=corti.mpois, gamf=c(0,10))
corti.nlpois <- nls2(corti, model,ctx, method="QLT", control=list(freq=0))



cat( "Result of the estimation process:\n ")
print(summary(corti.nlpois))

cat("\nModeling the variance function as a power of the mean\n")
ctx <- list( theta.start=corti.nl6$theta, 
                  beta.start=1, max.iters=500)
model <- list(file=corti.mpois2,gamf=c(0,10))
corti.nlpois2 <- nls2(corti,model,ctx,method="QLTB", control=list(freq=0))
cat( "Result of the estimation process:\n ")
print(summary(corti.nlpois2))

plot(rep(corti.nlpois2$response,corti.nlpois2$rep),corti.nlpois2$s.residuals,
ylab="residuals", xlab="fitted")

par(cex=1.5)
plot(rep(corti.nlpois2$response,corti.nlpois2$rep),corti.nlpois2$s.residuals,
ylab="Standardized residuals", xlab="fitted responses",las=1,type="n")
points(rep(corti.nlpois2$response,corti.nlpois2$rep),corti.nlpois2$s.residuals,pch=8)

plot(rep(corti.nlpois2$response,corti.nlpois2$rep),corti.nlpois2$s.residuals,
ylab="", xlab="fitted responses",type="n")
points(rep(corti.nlpois2$response,corti.nlpois2$rep),corti.nlpois2$s.residuals,pch=8)
mtext(at=c(3,1),text=c("\\rm Standardized","\\rm residuals"),side=2,line=2)

# Another example, not in the cookbook:
# -------------------------------------
ctx <- list(theta.start=corti.nl6$theta, beta.start=1, max.iters=1000)
model <- list(file=corti.mpois4,gamf=c(0,10))
corti.nlpois4 <- nls2(corti,model,ctx,method="MLSTB")
plot(rep(corti.nlpois4$response,corti.nlpois4$rep),corti.nlpois4$s.residuals,
ylab="residuals", xlab="fitted")

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
