# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data
data("fbeetles")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 6.7")
cat("\n#------------------------------------------------------")

# -----------------------------------
# Function used via apply
# -----------------------------------
bouclenls2 <- function(X, indice, model, ctx, method, control ) {
	model$eq.theta[indice] <- X[indice]
	ctx$theta.start <- X
	z <- nls2(fbeetles, model,ctx,method=method, control=control)
	  return(z$deviance)
	}
#  fin bouclenls2
# -----------------------------------


cat("\n ---------------------------")
cat("\n fbeetles example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation ") 
cat("\n\n") 

# Description of the model
# ------------------------
ctx <- list(theta.start=rep(c(4.5,3,2.5,3),2),
	sigma2.type="KNOWN",sigma2=1, 
	family="binomial", nameN="n")
nomlib <- loadnls2()
fbeetles.nl1 <- nls2(fbeetles,fbeetles.m,ctx,method="QLT")
cat("\n Result of the estimation process: \n")
print(summary(fbeetles.nl1))

cat("\n value of the minimum deviance: \n")
print(fbeetles.nl1$deviance)

# Comparison of curves
# --------------------
cat("\n Comparison of curves")
model <- list(file=fbeetles.m, eqp.theta=c(1,2,3,4,1,2,3,4))
fbeetles.nl2 <- nls2(fbeetles, model, ctx, method="QLT")
model$eqp.theta <- c(1,2,3,4,1,2,5,6)
fbeetles.nl3 <- nls2(fbeetles, model, ctx, method="QLT")
model$eqp.theta <- c(1,2,3,4,5,6,3,4)
fbeetles.nl4 <- nls2(fbeetles, model, ctx, method="QLT")
model$eqp.theta <- c(1,2,3,4,5,2,6,7)
fbeetles.nl5 <- nls2(fbeetles, model, ctx, method="QLT")
cat("SL:", (fbeetles.nl2$deviance - fbeetles.nl1$deviance),
      "X2(0.95,4):", qchisq(0.95,4),"\n\n")

cat("SL:", (fbeetles.nl3$deviance - fbeetles.nl1$deviance),
      "X2(0.95,2):", qchisq(0.95,2),"\n\n")

cat("SL:", (fbeetles.nl4$deviance - fbeetles.nl1$deviance),
      "X2(0.95,2):", qchisq(0.95,2),"\n\n")
cat("SL:", (fbeetles.nl5$deviance - fbeetles.nl1$deviance),
      "X2(0.95,1):", qchisq(0.95,1),"\n\n")


# Wald confidence interval for the ED50
# -------------------------------------
cat("\n\n Wald confidence interval for the ED50\n")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2(psi="")

temps <- unique(fbeetles$tps)
ED50.conf.13M <- confidence.nls2( fbeetles.nl5, 
                   file=fED50.mM, varpsi=temps[13])
ED50.conf.13F <- confidence.nls2( fbeetles.nl5, 
                   file=fED50.mF, varpsi=temps[13])
cat("\n Estimated value and standard error \n")
cat(" of the log ED50 for the males: \n")
print(c(ED50.conf.13M$psi,ED50.conf.13M$std.error))
cat("95% confidence interval of the log ED50 for the males: \n")
print(ED50.conf.13M$normal.conf.int)
cat("\n Estimated value and standard error \n")
cat("of the log ED50 for the females: \n")
print(c(ED50.conf.13F$psi,ED50.conf.13F$std.error))
cat("95% confidence interval of the log ED50 for the females: \n")
print(ED50.conf.13F$normal.conf.int)



# Wald confidence interval for the susceptibility ratio
# ------------------------------------------------------
cat("\n\n Wald confidence interval for the susceptibility ratio")
ratio.conf.13 <- confidence.nls2(fbeetles.nl5,file=fratio.m,varpsi=temps[13])
cat("\n Estimated value of the susceptibility ratio \n")
print(c(exp(ratio.conf.13$psi),exp(ratio.conf.13$psi)*ratio.conf.13$std.error))
cat("95% confidence interval of the susceptibility ratio: \n")
print(exp(ratio.conf.13$normal.conf.int))


# LR confidence interval for the ED50
# -----------------------------------
cat("\n\nLikelihood ratio type confidence interval for the ED50")

options(warn=-1)
nboucles <- 50
bmethod <- "QLT"
control <- list(freq=0)

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", fbeetles.mED50, " > fbeetles.mED50.c", sep=""))
nomlib <- loadnls2("fbeetles.mED50.c")


model <- list(file=fbeetles.mED50, eqp.theta=c(1,2,3,4,5,2,6,7))
ctx <- list(theta.start=rep(c(-1.5,3,2.5,3),2), sigma2.type="KNOWN", sigma2=1, family="binomial", nameN="n")
fbeetles.nl6 <- nls2(fbeetles, model, ctx,method="QLT", control=control)
cat("\n Result of the estimation process by method QLT", ": \n")
print(summary(fbeetles.nl6))
indice <- 1
ED50M <- fbeetles.nl6$theta[indice]
se.ED50M <- summary(fbeetles.nl6)$std.error[indice]

grid <- seq(ED50M-3*se.ED50M,ED50M+3*se.ED50M,length=nboucles)
thetagrid <- matrix(rep(fbeetles.nl6$theta,nboucles), nrow=nboucles, byrow=T)
thetagrid[,indice] <- grid
model <- list(file=fbeetles.mED50,eq.theta=c(thetagrid[1,indice],NaN,NaN,NaN,
                                              NaN,NaN,NaN,NaN ),
               eqp.theta=c(1,2,3,4,5,2,6,7))
ctx <- list(theta.start=thetagrid[1,],
            sigma2.type="KNOWN", sigma2=1, family="binomial",nameN="n")  

Diff <- apply(thetagrid, 1, bouclenls2, indice, model, ctx, bmethod, control)
Diff <- as.vector(Diff)


ind1 <- 1:(length(grid)/2)
ind2 <- (length(grid)/2):length(grid)
ED50MInf <- approx(Diff[ind1]-fbeetles.nl6$deviance,grid[ind1],xout=3.84)$y
ED50MSup <- approx(Diff[ind2]-fbeetles.nl6$deviance,grid[ind2],xout=3.84)$y
print(cbind(ED50MInf,ED50M,ED50MSup))

indice <- 5
ED50F <- fbeetles.nl6$theta[indice]
se.ED50F <- summary(fbeetles.nl6)$std.error[indice]
grid <- seq(ED50F-3*se.ED50F,ED50F+3*se.ED50F,length=nboucles)
thetagrid <- matrix(rep(fbeetles.nl6$theta, nboucles ), 
     nrow=nboucles, byrow=T)
thetagrid[,indice] <- grid

model <- list(file=fbeetles.mED50,eq.theta=c(NaN,NaN,NaN,
                                        NaN,thetagrid[1,indice],NaN,NaN,NaN ),
                                eqp.theta=c(1,2,3,4,5,2,6,7))
ctx <- list(theta.start=thetagrid[1,],
            sigma2.type="KNOWN", sigma2=1, family="binomial", nameN="n")  

Diff <- apply(thetagrid, 1, bouclenls2, indice, model, ctx, bmethod, control)
Diff <- as.vector(Diff)

ind1 <- 1:(length(grid)/2)
ind2 <- (length(grid)/2):length(grid)
ED50FInf <- approx(Diff[ind1]-fbeetles.nl6$deviance,grid[ind1],xout=3.84)$y
ED50FSup <- approx(Diff[ind2]-fbeetles.nl6$deviance,grid[ind2],xout=3.84)$y
print(cbind(ED50FInf,ED50F,ED50FSup))


options(warn=0)
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
