# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("mag")

# ---------------------------------------------------------------
# Example mag:
# - `mag':  example of a bootstrap estimation on the Cortisol example.
#   Subroutines of the Nag library are used to generate pseudo-observations.
#   Used functions: 
#     . `renls2'
# ---------------------------------------------------------------

 mag.stat.ctx <- list(theta.start=c(130,3000,3,3,0.6), 
              lambda.start=0.001, max.err.c2=30,
              max.iters=500, sigma2.type="VARRESID")

 mag.model <-list(file=mag.mod, gamf=c(-5,5), gamv=c(2.3))

# ------------------------------------------------------------------------
lesprog <- paste(
	paste(mag.mod,".c", sep=""),
	paste(mag.tirage,".c", sep=""),
	paste(mag.g05cbft, ".f", sep=""))
nomlib <- loadnls2(lesprog, lib="-L/usr/lib/fllux20dgl  -lnag -lpthread")
# ------------------------------------------------------------------------


oneloop <- function( p, Bool, VectBool, Nb, rboot1, new.resp)
{
# ---------------------------------------------------------------
# This function realizes the instructions of one loop 
# Arguments:
# b: loop index ( used for printing messages)
# Bool, VectBool, Nb: arguments of the random generator
# rboot1: results of the first estimation
# new.resp: new values of the response
#
# Result:
# rboot :  the result of the current estimation
# ---------------------------------------------------------------
#
# Random generation of a n-vector containing 0-1
# "tirage" is a C program
VectBool<-.C("tirage", p=as.double(p), Bool=as.integer(Bool), 
                      VectBool=as.integer(VectBool),
                      Lg=as.integer(Nb))$VectBool

# The 0-1 vector is transformed to facilitate the expression
# that generates the new values of f:
VectBool[VectBool==1] <- -1
VectBool[VectBool==0] <-  1

# Creation of the new values of f from the preceeding estimated
# values, the residuals calculated at the first estimation
# and the random vector:

f<- rep(new.resp, rboot1$replications) + 
        (( 1  + (VectBool*sqrt(5)) /2 ) * rboot1$residuals)


# The new estimation is realized by call to the function "renls2":

rboot <- renls2(rboot1,  f, rboot1$theta, 
                  sv.residuals=T, sv.estim=T, sv.fitted=T)
if (is.null(rboot))
  {
  warning(paste("exec: execution of the loop",b,"wrong"))
  return(NULL)
  }

# Printing of some of the results:
cat("\nNumber of iterations at the loop", b,":", rboot$nb.iters,"\n")
cat("Estimated values of the 'Theta' parameters at the loop", b,":\n")
print(rboot$theta)
return(theta=rboot$theta, new.resp=rboot$response)

} # end of a loop 
# ---------------------------------------------------------------
# end of the function oneloop
# ---------------------------------------------------------------

# ------------------------------------------------------------------------
# renls2
# ------------------------------------------------------------------------
n.loops <- 3

   # First invokation of nls2:
   # -------------------------
 rboot1 <- nls2(mag,mag.model,mag.stat.ctx, method="MLT", 
                control=list(freq=0), renls2=TRUE)

# Initialization of the random seed:
# ----------------------------------
# illustration of a call to external functions:  Nag functions

# p= bernoulli probabability for the random generator
p<- (5. + sqrt(5))/ 10.

# initialization of the random seed by call to the Nag function "g05cbf":
Bool<-as.integer(0)
.Fortran("g05cbf", as.integer(Bool))

# initialization of the vector containing the random numbers:
Nb <- length(mag$f) 
VectBool<- vector(mode="integer", length=Nb)

# mag simulations:
# ---------------------
# The commands of each loop are grouped in the function "oneloop":
# Thus, we can use the function "apply" more performant
# than the command "for"

# At each loop, the new values of the response are generated from
# the values estimated at the preceeding loop
new.resp <-  rboot1$response
mag.nls2 <-  matrix(ncol=5, nrow=n.loops)

for (b in 1:n.loops)
{
  retour <-  oneloop( p, Bool, VectBool, Nb, rboot1, new.resp)
  mag.nls2[b,]  <-  retour$theta
  new.resp  <- retour$new.resp  
}

print(mag.nls2)
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++



