
# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("orobranche")

cat("\n#------------------------------------------------------\n")
cat("# paragraphe 6.7\n")
cat("#------------------------------------------------------\n")

cat(" ---------------------------\n")
cat(" Orobranche example \n") 
cat(" ---------------------------\n")
cat(" Parameters estimation \n") 
cat("\n\n") 


orobranche.glm <- glm(cbind(orobranche$y,orobranche$n-orobranche$y) ~ orobranche$sp*orobranche$ex,  family="binomial")
print(orobranche.glm$coef)
cat("\nvalue of the minimum deviance:", orobranche.glm$deviance,
    "X2(0.95,17):",  qchisq(0.95,17), "\n\n")
lesystem(paste(.Nls2dir, "/analDer ",orobranche.m1, " > orobranche.m1.c", sep=""))
nomlib <- loadnls2("orobranche.m1.c")

# orobranche.nl11
# ---------------------
orobranche.nl11 <- nls2(orobranche,orobranche.m1,
        rep(0,4), method="QLT", control=list(freq=0))
print(summary(orobranche.nl11))


cat("\nModeling the variance function as in equation\n")
# orobranche.nl2
# --------------
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ",orobranche.m2, " > orobranche.m2.c", sep=""))
nomlib <- loadnls2("orobranche.m2.c")
ctx <- list(theta.start=orobranche.nl11$theta, beta.start=0, 
        sigma2.type="KNOWN", sigma2=1)
orobranche.nl2 <- nls2(orobranche, orobranche.m2,ctx,method="QLTB",
	control=list(freq=0))
print(summary(orobranche.nl2))

cat("\n Confidence interval for $\tau$ using the Wald test\n")
tau <- orobranche.nl2$beta
Stau <- sqrt(orobranche.nl2$as.var[5, 5])
cat("Estimated value of tau:", tau,"\n" )
cat("Estimated value of S:", Stau,"\n" )
cat("nu_(0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",
   c(tau-qnorm(0.975)*Stau,
     tau+qnorm(0.975)*Stau)
   ,"\n" )


# orobranche.nl2 par bootstrap
# ----------------------------
cat("\nConfidence interval for $\tau$ using  bootstrap with asymptotic level 95% ")
orobranche.nl2 <- nls2(orobranche, orobranche.m2,ctx,method="QLTB",
             renls2=T,control=list(freq=0))
conf.boot.nl2 <- bootstrap.nls2(orobranche.nl2,method="wild.2",n.loops=500)
delnls2()

tauStar <- conf.boot.nl2$pStar[,5]
StauStar <- sqrt(conf.boot.nl2$var.pStar[,5])
cat("Estimated value of tau:", tau,"\n")
cat("Estimated value of S:", Stau,"\n")
qu <- quantile((tauStar-tau)/StauStar,c(0.025,0.975))
cat("b_(0.025):", qu[1],"\n")
cat("b_(0.975):", qu[2],"\n")
cat("Estimated value of Ib:",
   tau + qu[1]*Stau,
   tau + qu[2]*Stau,"\n")

# orobranche.nl4
# --------------
cat("\n\nModeling the variance function orobranche.m4")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ",orobranche.m4, " > orobranche.m4.c", sep=""))
nomlib <- loadnls2("orobranche.m4.c")

ctx <- list(theta.start=orobranche.nl11$theta, beta.start=rep(0,4),
	sigma2.type="KNOWN", sigma2=1)
orobranche.nl4 <- nls2(orobranche, orobranche.m4,ctx,method="QLTB",
	control=list(freq=0))
print(summary(orobranche.nl4))


# orobranche.nl5
# --------------
cat("\n\nModeling the variance function orobranche.m5")

ctx <- list(theta.start=orobranche.nl11$theta, beta.start=0, 
      sigma2.type="KNOWN", sigma2=1)
#	nameN="n",family="binomial")

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ",orobranche.m5, " > orobranche.m5.c", sep=""))
nomlib <- loadnls2("orobranche.m5.c")
orobranche.nl5 <- nls2(
orobranche, orobranche.m5,ctx,method="QLTB",
            control=list(freq=0))
print(summary(orobranche.nl5))
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
