# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("ownmethod")

# --------------------------------------------------------------------
# ----------------------------------------------------------------
# - `ownmethod': example of an estimation method defined by the user.
#   This method can be used in every case of auto-correlation of the errors.
#   See 
#   "Rapport de Stage DESS Mathematiques Appliquees",
#    David Deschamps,
#    INRA, Jouy-en-Josas, juin 1994.
#   But, be careful in using the t-values issued by functions "summary" and
# "coef".
#   2 examples are available: example with simulated data and real data.
#   Used functions: 
#     . `nls2'
# Messages "An error has occured" are issued.
# ---------------------------------------------------------------------------
# Simulation example :	arexp(phi=.6,theta=.045,iter=100)
# -----------------------------------------------------------------------------
# ---------------------------------------------------------------------------
lesystem(paste(.Nls2dir, "/analDer ", own.simul.mod, " > own.simul.mod.c", sep=""))
nomlib <- loadnls2("own.simul.mod.c",
     tomyown= paste(own.ToMyOwn.mod, ".c", sep=""))
# ---------------------------------------------------------------------------

# ---------------------------------------------------------------------------
# nls2
# ---------------------------------------------------------------------------
# Dans le modele: ne pas mettre de eq.beta
# beta contient phi (exprime la correlation des erreurs) et sigma2	

 ownmethod.simul.nls2 <- nls2(ownmethod.simul,
        list(
           file=own.simul.mod,
           vari.type="VSB",
           inf.beta=c(-1,0),sup.beta=c(1,1)),
        list(theta.start=c(.01), algorithm="GM",
             beta.start=c(0.6, 1),
             max.iters=30,
              max.err.c2=10, sigma2.type="KNOWN",sigma2=1),
        method = "MYOWN",
        num.ctx=list(nh=3,effic=T,W.type="SYM",fit.type="MYOWN"),
        control= list(
          fitted=F,
          estim=T, deriv.fct=F, num.res=T,
          freq=1))
 print(ownmethod.simul.nls2)



# ---------------------------------------------------------------------------
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", own.roots.mod, " > own.roots.mod.c", sep=""))
nomlib <- loadnls2("own.roots.mod.c",
     tomyown= paste(own.ToMyOwn.mod, ".c", sep=""))

# -----------------------------------------------------------------------
# nls2
# -----------------------------------------------------------------------
ownmethod.roots.nls2 <- nls2(ownmethod.roots,
 list(
  file=own.roots.mod,
  vari.type="VSB",inf.beta=c(-1,0),sup.beta=c(1,NA)),
 list(theta.start=c(67,.05),beta.start=c(.2,1),max.iters=20,
	max.err.c2=10,algorithm="GM",sigma2.type="KNOWN",sigma2=1),
 method = "MYOWN",
 num.ctx=list(nh=3,effic=T,W.type="SYM",fitting.crit="MYOWN"),
 control=list(fitted=F,estim=T, deriv.fct=F, 
	num.res=T, freq=1, it.steps=T))
print(ownmethod.roots.nls2)
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
