# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("pasture")


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 1.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Pasture re-growth example ") 
cat("\n ---------------------------\n\n")

if (interactive()) {X11(); (ask.pause <- T); par(ask=T)} else { postscript(file="pasture.ps"); (ask.pause <- F)  }
pldnls2(pasture, response.name="yield", X.name="time",
          title = "Pasture regrowth example", 
          sub = "Observed response")

lesystem(paste(.Nls2dir, "/analDer ",pasture.mod1, " > pasture.mod1.c", sep=""))
nomlib <- loadnls2("pasture.mod1.c")
pasture.nl1 <- nls2(pasture, pasture.mod1,
                list(theta.start= c(70, 60, 0, 1), max.iters=100)) 
cat( "Estimated values of the parameters:\n ")
print( pasture.nl1$theta); cat( "\n\n")


plfit(pasture.nl1, title ="Pasture regrowth example", ask.pause=ask.pause,
       sub = "Observed and adjusted response")


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 2.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Pasture re-growth example:") 
cat("\n confidence interval for the maximum yield ") 
cat("\n ---------------------------\n")
pasture.conf.par <- confidence(pasture.nl1)
cat("Estimated value of lambda:", pasture.conf.par$psi[1],"\n" )
cat("Estimated value of S:",pasture.conf.par$std.error[1],"\n" )
cat("nu <- (0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",
     pasture.conf.par$normal.conf.int[1,],"\n" )
cat("t <- (0.975, 5):", qt(0.975,5),"\n" )
cat("Estimated value of It:",
     pasture.conf.par$student.conf.int[1,],"\n" )


cat("\n Confidence interval for $lambda=theta <- 1$ ") 
cat("\n using bootstrap with asymptotic level 95% \n\n") 
pasture.nl1 <- nls2(pasture, pasture.mod1,
          list(theta.start= c(70, 60, 0, 1), max.iters=100),
          control=list(freq=0),
          renls2=T)
pasture.boot <- bootstrap(pasture.nl1, 
           method="residuals",
           n.loops=199)
delnls2()
P1.B <- pasture.boot$pStar[,1]
SE.P1.B <- sqrt(pasture.boot$var.pStar[,1])
T.B <- (P1.B-pasture.nl1$theta[1])/SE.P1.B
hist(T.B,nclass=12)
title(main="Pasture regrowth example",
    sub="Histogram of bootstrap estimations for T")
b0  <-  sort(T.B)  

   # Print the results:
cat("Estimated value of lambda:", pasture.nl1$theta[1],"\n")
cat("Estimated value of S:",coef(pasture.nl1)$std.error[1],"\n")
cat("b <- (0.025):", b0[5],"\n" )
cat("b <- (0.975):", b0[195],"\n" )
cat("Estimated value of Ib:",
 pasture.nl1$theta[1]+b0[5]*coef(pasture.nl1)$std.error[1],
 pasture.nl1$theta[1]+b0[195]*coef(pasture.nl1)$std.error[1],"\n")
cat("BIAS:" , (mean(P1.B)-pasture.nl1$theta[1]),"\n" ) 
cat("S:" ,sqrt(var(P1.B)),"\n" )  
cat("MSE:" ,
  var(P1.B)+(mean(P1.B)-pasture.nl1$theta[1])^2 ,"\n" ) 
cat("MED:" ,median(P1.B) ,"\n" )  


cat("\n# ------------------------------------------------")
cat("\n# paragraph 2.6: follow")
cat("\n# ------------------------------------------------")

cat("\n ---------------------------")
cat("\n Pasture re-growth example: confidence interval for") 
cat("\n $lambda=exp(theta) <- {3}$ ") 
cat("\n ---------------------------\n\n")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/crPsi ",pasture.lambda, " > pasture.lambda.c", sep=""))
nomlib <- loadnls2("pasture.mod1.c",
      psi="pasture.lambda.c")
pasture.conf.expP3 <- confidence(pasture.nl1,
           file=pasture.lambda)
   # Print the results:
cat("Estimated value of lambda:", pasture.conf.expP3$psi,"\n" )
cat("Estimated value of S:",pasture.conf.expP3$std.error,"\n" )
cat("nu <- (0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In for exp(p3):",
  pasture.conf.expP3$normal.conf.int,"\n" )
cat("Estimated value of In for p3:",
  pasture.conf.par$normal.conf.int[3,],"\n" )
cat("Exponential transformation of the preceding interval:",
  exp(pasture.conf.par$normal.conf.int[3,]),"\n" )

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")

cat("\n\n Pasture: Second model:\n")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ",pasture.mod2, " > pasture.mod2.c", sep=""))
nomlib <- loadnls2("pasture.mod2.c")
pasture.nl2<- nls2(pasture,pasture.mod2,c(70,-2,20))
cat( "Estimated values of the parameters:\n ")
print( pasture.nl2$theta)
cat( "Estimated value of sigma2:\n ")
print( pasture.nl2$sigma2)


cat("\n Plotting the observed and fitted values of the response \n\n") 

plfit(pasture.nl2, title ="Pasture regrowth example", ask.pause=ask.pause,
      sub = "Observed and adjusted response")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 5.6")
cat("\n#------------------------------------------------------")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/crPsi ",pasture.predict, " > pasture.predict.c", sep=""))
nomlib <- loadnls2("pasture.mod1.c",
      psi="pasture.predict.c")

pasture.conf.fx0<-confidence(pasture.nl1,
         file=pasture.predict,
         pbispsi=50)
  # Print the results
cat("Estimated value of f(x0,theta):", pasture.conf.fx0$psi,"\n" )
cat("Estimated value of S:", pasture.conf.fx0$std.error,"\n" )

cat("\nPrediction interval $widehat{I}_{ N}(x_{0})$ for $y_{0}$, with asymptotic level 95% \n\n") 

variance.y0 <- pasture.nl1$sigma2 + pasture.conf.fx0$var.psi
sqrt.var <- sqrt(variance.y0)
lower.y0<- pasture.conf.fx0$psi + qnorm(0.025)*sqrt.var
upper.y0<- pasture.conf.fx0$psi + qnorm(0.975)*sqrt.var

cat("Estimated value of y0:",pasture.conf.fx0$psi,"\n" )
cat("Estimated value of the std:", sqrt.var,"\n" )
cat("nu_(0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",lower.y0, upper.y0,"\n" )

cat("\nBootstrap prediction intervals for $y_{0}$\n\n")
pasture.pred.y0<-bootstrap(pasture.nl1,
                            n.loops=500,
                            method="calib",
                            file=pasture.predict,
                            ord=pasture.conf.fx0$psi,
                            pbispsi=50)
lower.y0<- pasture.conf.fx0$psi +
              pasture.pred.y0$conf.bounds[1] *sqrt(variance.y0)
upper.y0<- pasture.conf.fx0$psi +
                  pasture.pred.y0$conf.bounds[2] *sqrt(variance.y0)
cat("Estimated value of y0:", pasture.conf.fx0$psi,"\n" )
cat("b_0.025, b_0.975:",pasture.pred.y0$conf.bounds,"\n" )
cat("Estimated value of Ib:",lower.y0,upper.y0,"\n" )



if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
