# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("pept")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 3.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Solubility of peptides example")
cat("\n ---------------------------\n\n")

cat("\n Plot of the observed percentage of solubility versus") 
cat("\n the retention time \n\n") 

if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="variance.pept.ps"); (ask.pause <- F)  }

pldnls2(pept.d, response.name="solubility", X.name="RetTime",
        ask.pause=ask.pause,
         title="Solubility of peptides example",          
         sub="observed response")                         

lesystem(paste(.Nls2dir, "/analDer ", pept.m1, " > pept.m1.c", sep=""))
nomlib <- loadnls2("pept.m1.c")
pept.nl1<-nls2(pept.d,pept.m1,
    list(theta.start=c(1,1), max.iters=100),
                 control=list(freq=0))

cat("\n\n Estimation under hypothesis A\n\n")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", pept.m3, " > pept.m3.c", sep=""))
nomlib <-loadnls2("pept.m3.c")

pept.c3 <- list(theta.start=pept.nl1$theta,
              beta.start=0) 
pept.nl3<-nls2(pept.d, pept.m3, stat.ctx= pept.c3,
                control=list(freq=0))  
cat("\nSummary of pept.nl3:\n" )
print(summary(pept.nl3))


# Plot the observed and fitted values of the response
# against the independent variable.
plfit(pept.nl3, wanted=list(X.OF=T),ask.pause=ask.pause,
       title="Solubility of peptides",
       sub="Observed and fitted response")


cat("\n\n Estimation under hypothesis H\n\n")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", pept.m2, " > pept.m2.c", sep=""))
nomlib <- loadnls2("pept.m2.c")

pept.nl2<-nls2(pept.d, pept.m2 ,pept.nl3$theta)

cat("\n Likelihood ratio test of the existence of a constant term") 
cat("\n in the variance model \n\n") 
cat( "Sl:", 
  75 * (pept.nl2$loglik - pept.nl3$loglik),
  "X2(0.95,1):",  qchisq(0.95,1), "\n\n")

cat("\n Plots of the fitted curves \n\n") 
plot(RetTime,solubility,xlab="retention time",ylab="solubility",
main="Solubility of peptides example",
      sub="Observed and fitted response")
X<-seq(-1,75,length=100)
Y<-100/(1+exp(pept.nl3$theta[2]*(X-pept.nl3$theta[1])))
lines(X,Y)
Z<-100/(1+exp(pept.nl2$theta[2]*(X-pept.nl2$theta[1])))	
par (lty=2)
lines (X,Z)
par (lty=1)

cat("\n Confidence interval for $\theta <- {2}$ using the log-likelihood ratio ") 
cat("\n\n") 

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("pept.m3.c")

pept.conflike  <-  conflike(pept.nl3, parameter = 2)
  # Print the results 
cat("Estimated value of theta <- 2:", pept.nl3$theta[2],"\n" )
cat("Estimated value of S:",  sqrt(pept.nl3$as.var[2, 2]),"\n" )
cat("X2(0.95,1):", qchisq(0.95, 1),"\n" )
cat("Estimated value of Is:", pept.conflike$like.conf.int,"\n" )

cat("\n Confidence interval for $\theta <- {2}$") 
cat("\n using the Wald statistic,") 
cat("\n based on the maximum likelihood estimator \n\n") 

pept.conf <- confidence(pept.nl3)
   # Print the results:
cat("Estimated value of theta <- 2:",pept.conf$psi[2],"\n" )
cat("Estimated value of S:", pept.conf$std.error[2],"\n" )
cat("nu <- (0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",pept.conf$normal.conf.int[2,], "\n" )

cat("\n Confidence interval for $\theta <- {2}$") 
 cat("\n using the Wald statistic,\n") 
 cat("\n based on the three step") 
 cat("\n alternate method \n\n") 


pept.nl8<-nls2(pept.d, pept.m3, pept.c3,
 method=c("OLST","MLSB","MLST"))
  # Print the results
cat("Estimated value of the parameters theta:\n")
print(pept.nl8$step3$theta)
cat("Estimated value of the parameters beta:\n",
  pept.nl8$step3$beta[1], pept.nl8$step3$sigma2)
cat("\nEstimated value of the asymptotic covariance matrix:\n")
print(pept.nl8$step3$as.var[1:2, 1:2])

cat("\n Plots of the results \n\n") 

plot(RetTime,solubility,
      xlab="retention time",ylab="solubility",
      main="Solubility of peptides example",
      sub="Observed and fitted response")
X<-seq(-1,75,length=100)
Y<-100/(1+exp(pept.nl3$theta[2]*(X-pept.nl3$theta[1])))
Z<-100/(1+exp(pept.nl8$step3$theta[2]*(X-pept.nl2$theta[1])))	
lines(X,Y)
par (lty=2)
lines (X,Z)
par (lty=1)

cat("\n Confidence interval for $\theta <- {2}$") 
cat("\n based on results of the three steps method \n\n") 

pept.In <- confidence(pept.nl8)
     # Print the results
cat("Estimated value of theta <- 2:",coef(pept.nl8)$theta[2],"\n" )
cat("Estimated value of S:", coef(pept.nl8)$std.error[2],"\n" )
cat("nu <- (0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",pept.In$normal.conf.int[2,],"\n" )
cat("Loglikelihood values:",
  -(pept.nl3$loglik*75/2), -(pept.nl8$step3$loglik*75/2),"\n" )


cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Solubility of peptides example: graphics for diagnostic ") 
cat("\n ---------------------------\n\n")

cat("\n Plotting the observed and fitted values of the response") 
cat("\n when variance is assumed to be constant \n\n") 

if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="pept.1.ps"); (ask.pause <- F)  }

plfit(pept.nl1, wanted=list(X.OF=T),
      title="Solubility of peptides example - constant variance",
     ask.pause=ask.pause ,
      sub="Observed and fitted response")

cat("\n Plotting the residuals") 
cat("\n when variance is assumed to be constant \n\n") 

plres.nls2(pept.nl1,  wanted=list(F.R=T),
      absolute=T, smooth=T, ask.modify=ask.pause,
     ask.pause=ask.pause ,
      title="Solubility of peptides example - constant variance")
abline(0,0)

cat("\n Plotting the observed and fitted values of the response") 
cat("\n and the residuals") 
cat("\n when variance is assumed to be heteroscedastic ") 
cat("\n\n") 

   # Plot the observed and fitted values of the response
   # against the independent variable.
plfit(pept.nl3, wanted=list(X.OF=T),ask.pause=ask.pause,
      title="Solubility of peptides - non constant variance",
      sub="Observed and fitted response")
   # Plot the residuals
plres.nls2(pept.nl3,  wanted=list(F.R=T),
      absolute=T, st=T, smooth=T, ask.pause=ask.pause, ask.modify=ask.pause,
      title="Solubility of peptides - non constant variance")
abline(0,0)

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6: following")
cat("\n#------------------------------------------------------")


cat("\n ---------------------------")
cat("\n Solubility of peptides example: numerical troubles during") 
cat("\n the estimation process ") 
cat("\n ---------------------------\n")


if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", pept.m13, " > pept.m13.c", sep=""))
nomlib <-loadnls2("pept.m13.c")

pept.ctx13<-list(theta.start=pept.nl3$theta,
          beta.start=c(pept.nl3$beta,0),max.iters=500)
pept.ctr13<-list(
  freq=5,it.steps=1,
   it.iter=T, it.estim=T, it.num.res=T,
   iter=F,estim=F,fitted=F,num.res=F,sigma2=F)
pept.nl13<-nls2(pept.d, pept.m13,
 pept.ctx13,control=pept.ctr13)

# Print the result
summary(pept.nl13)

ind<-50:100
par(mfrow=c(2,2))
plot(pept.nl13$iters.sv$theta[ind,1],
-75*pept.nl13$iters.sv$stat.crit[ind]/2)
plot(pept.nl13$iters.sv$theta[ind,2],
 -75*pept.nl13$iters.sv$stat.crit[ind]/2)
 plot(pept.nl13$iters.sv$beta[ind,1],
 -75*pept.nl13$iters.sv$stat.crit[ind]/2)
plot(pept.nl13$iters.sv$beta[ind,2],
 -75*pept.nl13$iters.sv$stat.crit[ind]/2)


if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", pept.m14, " > pept.m14.c", sep=""))
nomlib <-loadnls2("pept.m14.c")
pept.ctx14<-list(theta.start=pept.nl3$theta,
                beta.start=c(0.001,0),max.iters=500)
pept.nl14<-nls2(pept.d, pept.m14, pept.ctx14)
 # Print the result
summary(pept.nl14)

cat("\n Peptides example: concluded \n\n")

# On ferme le device, car pbe avec R/linux quand,
# aprs avoir trac pls fentres dans un cran, on utilise l'cran entier
dev.off()
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="pept.2.ps"); (ask.pause <- F)  }

   # Plot the observed and fitted values of the response
   # against the independent variable.
plfit(pept.nl14, wanted=list(X.OF=T),ask.pause=ask.pause,
      title="Solubility of peptides - exponential variance",
      sub="Observed and fitted response")
   # Plot the residuals
plres.nls2(pept.nl14,  wanted=list(F.R=T),
      smooth=T, ask.pause=ask.pause, ask.modify=ask.pause,
      title="Solubility of peptides - exponential variance")
abline(0,0)
plres.nls2(pept.nl14,  wanted=list(F.R=T),
      absolute=T, st=T, smooth=T, ask.pause=ask.pause, ask.modify=ask.pause,
      title="Solubility of peptides - exponential variance")

dev.off()
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="pept.3.ps"); (ask.pause <- F)  }

par(mfrow=c(1,2))
plot(range(pept.nl14$response),
   range(c(pept.nl14$residuals**2,pept.nl14$variance)),
   xlab="fitted responses", ylab="squared residuals")
title(main="Parabolic variance function")
points(rep(pept.nl3$response,pept.nl3$replications),
  pept.nl3$residuals**2)
lines(sort(pept.nl3$response),
  pept.nl3$variance[order(pept.nl3$response)],lty=1)
plot(range(pept.nl14$response),
   range(c(pept.nl14$residuals**2,pept.nl14$variance)),
   xlab="fitted responses", ylab="squared residuals")
title(main="Exponential variance function")
points(rep(pept.nl14$response,pept.nl14$replications),
   pept.nl14$residuals**2)
lines(sort(pept.nl14$response),
        pept.nl14$variance[order(pept.nl14$response)],lty=1)


if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++

