# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("perm")


# ---------------------------------------------------------------
# Example PERM:
# example of a model described by a differential equations system.
#  Weights, curves and numerical constraints.
#  (Don't worry about the values of the component "as.var" of the result
# that may look a bit strange. It is due to the complicated model definition).
# There is also a warning message when calling nls2:
# Error when calculating the direction

# Functions called:
# calcmodnls2 and nls2
# ---------------------------------------------------------------
#data(perm)

# ---------- function crno ----------------------------------
crno <- function(perm,filename)
  {
  # call to nls2  without estimation and constraints
  # to calculate FOdes and d.FOdes for the initial values:
  gamf<-c(18, 1, 1.596e-6, 6.604e-4, 0.29, 0.29, 1)
  model <-list(file=filename, gamf=gamf)
  theta<- c(
          rep(c(0.05000, 0.00001, 62.07000, 1.11300, 1.47500, 0.15000, 0.05000, 0.00001,
 92.09000, 1.26000, 1.33700, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000,
 1.62000, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000, 1.62000, 0.06500), 3),
   0.05000,  0.00001, 76.09000, 1.04000, 1.62000, 0.15000, 0.05000, 0.00001,
 76.09000, 1.04000, 1.62000, 0.06500, 0.05000, 0.00001, 92.09000, 1.26000,
 1.33700, 0.06500)
  ctx <-list(theta.start=theta, sigma2.type="VARINTRA", max.iters=0)
  ctxi<-list(start=0, nb.theta.odes=6,
       cond.start=matrix(c(
       rep(c(1.35660e-6,0,1.35660e-6,0,1.35660e-6,0, 1.49226e-6,0),3),
        1.35660e-6, 0, 1.49226e-06, 0, 1.49226e-06, 0), ncol=2), byrow=T)

  return(nls2(perm,model,ctx, method="VITWLS", integ.ctx=ctxi, control=list(freq=0)))
}
# ----------End of  function crno ----------------------------------

# ---------- function crphi ----------------------------------
crphi <-  function(perm,filename,no)
{
#  Example of evaluation of phi:
# -----------------------------
  gamf<-c(18, 1, 1.596e-6, 6.604e-4, 0.29, 0.29, 1)
  theta<- c(
          rep(c(0.05000, 0.00001, 62.07000, 1.11300, 1.47500, 0.15000, 0.05000, 0.00001,
 92.09000, 1.26000, 1.33700, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000,
 1.62000, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000, 1.62000, 0.06500), 3),
   0.05000,  0.00001, 76.09000, 1.04000, 1.62000, 0.15000, 0.05000, 0.00001,
 76.09000, 1.04000, 1.62000, 0.06500, 0.05000, 0.00001, 92.09000, 1.26000,
 1.33700, 0.06500)

  return(calcmodnls2(perm,filename,
             theta=theta,gamf=gamf,
             FOdes=no$FOdes, d.FOdes=no$d.FOdes,
             integ.ctx= list(nb.theta.odes=6),
             func="phi"))
}
# ----------End of function crphi ----------------------------------

# ---------- function crodes ----------------------------------
crodes <- function(perm,filename)
{    
#  Example of evaluation of the odes:
# -----------------------------
  gamf<-c(18, 1, 1.596e-6, 6.604e-4, 0.29, 0.29, 1)
  theta<- c(
          rep(c(0.05000, 0.00001, 62.07000, 1.11300, 1.47500, 0.15000, 0.05000, 0.00001,
 92.09000, 1.26000, 1.33700, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000,
 1.62000, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000, 1.62000, 0.06500), 3),
   0.05000,  0.00001, 76.09000, 1.04000, 1.62000, 0.15000, 0.05000, 0.00001,
 76.09000, 1.04000, 1.62000, 0.06500, 0.05000, 0.00001, 92.09000, 1.26000,
 1.33700, 0.06500)
  ctxi<-list(start=0, nb.theta.odes=6,
       cond.start=matrix(c(
       rep(c(1.35660e-6,0,1.35660e-6,0,1.35660e-6,0, 1.49226e-6,0),3),
        1.35660e-6, 0, 1.49226e-06, 0, 1.49226e-06, 0), ncol=2), byrow=T)

  return( calcmodnls2(perm, filename,
                  theta=theta, gamf=gamf,
                  integ.ctx=ctxi, func="odes"))
  }
# ---------- End of function crodes ----------------------------------


# Context creation:
  Theta0<- c(
          rep(c(0.05000, 0.00001, 62.07000, 1.11300, 1.47500, 0.15000, 0.05000, 0.00001,
 92.09000, 1.26000, 1.33700, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000,
 1.62000, 0.15000, 0.05000, 0.00001, 76.09000, 1.04000, 1.62000, 0.06500), 3),
   0.05000,  0.00001, 76.09000, 1.04000, 1.62000, 0.15000, 0.05000, 0.00001,
 76.09000, 1.04000, 1.62000, 0.06500, 0.05000, 0.00001, 92.09000, 1.26000,
 1.33700, 0.06500)

# Creation of the statistical context:
  perm.stat.ctx <-list(theta.start=Theta0, sigma2.type="VARINTRA")

# Creation of the integration context:
  perm.integ.ctx<-list(start=0, nb.theta.odes=6,
       cond.start=matrix(c(
       rep(c(1.35660e-6,0,1.35660e-6,0,1.35660e-6,0, 1.49226e-6,0),3),
        1.35660e-6, 0, 1.49226e-06, 0, 1.49226e-06, 0), ncol=2), byrow=T)

# Model creation:
  filename <- perm.mod
  perm.model <-
    list(file=filename, gamf=c(18, 1, 1.596e-6, 6.604e-4, 0.29, 0.29, 1),
    vari.type="VI", 
    eq.theta=c( 
               rep(c(NaN,  NaN, 62.07000,  1.11300,  1.47500,  0.15000,  NaN,  NaN,
 92.09000,  1.26000,  1.33700,  0.15000,  NaN,  NaN, 76.09000,  1.04000,
  1.62000,  0.15000,  NaN,  NaN, 76.09000,  1.04000,  1.62000,  0.06500),3),
    NaN,  NaN, 76.09000, 1.04000, 1.62000, 0.15000, NaN, NaN,
 76.09000, 1.04000, 1.62000, 0.06500, NaN, NaN, 92.09000, 1.26000,
 1.33700, 0.06500)
         )
# ---------------------------------------------------------------
# load the object-files
# ---------------------------------------------------------------
lesystem(paste(.Nls2dir, "/analDer ", perm.mod, " > perm.mod.c", sep=""))
nomlib <- loadnls2("perm.mod.c")

# ---------------------------------------------------------------
# Function "calcmodnls2"
# ---------------------------------------------------------------
  # Direct calculation of the model for the initial values:
  # calculation of odes:
  # ------------------
  perm.odes <- crodes(perm, filename)

  # nls2 without estimation to verify:
  # ----------------------------------
  no <- crno(perm, filename)

  # Verification:
  # -------------
# odes.out should be equal to no:
  if (all(perm.odes$FOdes==no$FOdes))
    cat("Correct calculation of FOdes\n") else
    cat("Incorrect calculation of FOdes\n")
  if (all(perm.odes$d.FOdes==no$d.FOdes))
    cat("Correct calculation of d.FOdes\n")  else
    cat("Incorrect calculation of d.FOdes\n")

  if (all(perm.odes$response==no$response))
    cat("Correct calculation of response\n")  else
    cat("Incorrect calculation of response\n")
  if (all(perm.odes$d.resp==no$d.resp))
    cat("Correct calculation of d.resp\n")  else
    cat("Incorrect calculation of d.resp\n")


  # calculation of phi alone:
  # -------------------------
  perm.phi <- crphi(perm, filename,no)

  # verification of phi:
  # -------------------
# perm.phi$response should be equal to no$response:
  if (all(perm.phi$response==no$response))
    cat("Correct calculation of response\n")  else
    cat("Incorrect calculation of response\n")
# perm.phi$d.resp should be equal to no$d.resp:
  if (all(perm.phi$d.resp==no$d.resp))
    cat("Correct calculation of d.resp\n")  else
    cat("Incorrect calculation of d.resp\n")



# ---------------------------------------------------------------
# Function "nls2"
# ---------------------------------------------------------------
	
  perm.nls2 <- nls2(perm,perm.model,perm.stat.ctx, 
        method="VITWLS", integ.ctx=perm.integ.ctx)
  print(perm.nls2 )
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
