# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("root")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Trajectory of roots of maize") 
cat("\n ---------------------------\n")

cat("\n Plotting the observed responses against the") 
cat("\n independent variable \n\n") 
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="root.ps"); (ask.pause <- F)  }

pldnls2(root,response.name="dist",X.names="depth", ask.pause=ask.pause )

cat("\n Parameter estimation \n\n") 
lesystem(paste(.Nls2dir, "/analDer ", root.mod1, " > root.mod1.c", sep=""))
nomlib <- loadnls2("root.mod1.c")

root.nl1<-nls2(root,root.mod1,c(70,1))
    # Print the estimated values
cat( "Estimated values of the parameters:\n ")
print(root.nl1$theta); cat( "\n\n")

cat("\n Plotting the observed and fitted values of the response") 
cat("\n and the residuals \n\n") 

    # Plot the observed and fitted values of the response
    # against the independent variable.
plfit(root.nl1, 
       wanted=list(X.OF=T), ask.pause=ask.pause,
       title="Trajectory of roots")
    # Plot the residuals
plres(root.nl1,
       wanted=list(R.R=T),ask.pause=ask.pause,
       title="Trajectory of roots")

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++

