# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("sim")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 4.6")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Simulated example ") 
cat("\n ---------------------------\n")

cat("\n Parameter estimation with the first data-set \n\n") 

lesystem(paste(.Nls2dir, "/analDer ", sim.mod1, " > sim.mod1.c", sep=""))
nomlib <- loadnls2("sim.mod1.c")
sim.nl1<-nls2(exsw1,sim.mod1,c(1,1))
    # Print the main results
cat( "Estimated values of the parameters:\n ")
print(coef(sim.nl1))
cat( "Estimated value of sigma2:\n ")
print(sim.nl1$sigma2); cat( "\n\n")


confsim <- confidence(sim.nl1)
cat( "Confidence interval for the parameters:\n")
print(confsim$normal.conf.int); cat( "\n\n")

cat("\n Plotting the generated and fitted values of the response") 
cat("\n with the first data-set \n\n") 
if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="sim.ps"); (ask.pause <- F)  }

plfit(sim.nl1, wanted=list(X.OF=T),title="Simulated example 1", ask.pause=ask.pause)

cat("\n Plotting sensitivity functions for the first data-set \n\n") 

matplot(exsw1$x, sim.nl1$d.resp,type="l",xlab="x",ylab="")
legend(x=0.5,y=.3,legend=c("phi1","phi2"),lty=c(1,2))
title(" Plot of sensitivity functions")

# ---------------------------------------------------
cat("\n Parameter estimation with the second data-set \n\n") 
sim.nl2 <- nls2(exsw2,sim.mod1,c(1,1))
   # Print the main results
cat( "Estimated values of the parameters:\n ")
print(coef(sim.nl2))


cat("\n Plotting the generated and fitted values of the response") 
cat("\n with the second data-set \n\n") 

plfit(sim.nl2, 
      wanted=list(X.OF=T),
       title="Simulated example 2", ask.pause=ask.pause)

if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
