# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("simul")

# ---------------------------------------------------------------
# Example SIMUL: simulation 
# example of a model calculated by a Fortran program
#  The regression function is solution of an implicit equation.
# Functions called:
# "nls2" "calcmodnls2"
# ---------------------------------------------------------------

cat("\n ---------------------------")
cat("\n Simul example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation ") 
cat("\n\n") 


# problem constants creation:
xa<-66.67;xr<-0.086;cl<-26587;cns<-1100;
xk<-1.3;xka<-3.3;xk1<-1.37;coefct<-11.95;
h<-0.5e-3; eps<-1.0e-6; eta<-0.0; hbase<-0.00005


# ---------------------------------------------------
lesprog <- paste(simul.mod,".f", sep="")
nomlib <- loadnls2(lesprog, lang="F", lib="-L/usr/lib/fllux20dgl  -lnag -lpthread")
# ---------------------------------------------------

# ---------------------------------------------------
# nls2
# ---------------------------------------------------
	
# Call to the program that initializes the Fortran commons:
 z<-.Fortran("initcommon", 
     as.double(xa),as.double(xr),as.double(cl),
     as.double(cns),as.double(xk),as.double(xka),
     as.double(xk1),as.double(coefct),
     as.double(h),as.double( eps),as.double( eta),as.double( hbase),
     as.integer(length(simul$y)), as.double(simul$x), as.double(simul$y))

# Call to the function "nls2":
# the model is described only by the component
# which is always required, i.e the
# name of the formal description file,
# and the context is described only by the component
# which is always required, i.e the
# initial values of the Theta
simul.nls2 <- nls2(simul,simul.mod, c(0.1))

# ---------------------------------------------------------
# calcmodnls2
# ---------------------------------------------------------
# Direct calculation of the model for the initial values:

# Call to the program that initializes the Fortran commons:
 z<-.Fortran("initcommon",
      as.double(xa),as.double(xr),as.double(cl),
      as.double(cns),as.double(xk),as.double(xka),
      as.double(xk1),as.double(coefct),
      as.double(h),as.double( eps),as.double( eta),as.double( hbase),
      as.integer(length(simul$y)), as.double(simul$x), as.double(simul$y))

 simul.f <-calcmodnls2(simul,file=simul.mod, theta=c(0.1))
# To verify, call to nls2:
 no <- nls2(simul,simul.mod, 
             stat.ctx=list(theta.start=c(0.1),max.iters=0),
             control=list(freq=0))
# simul.f$response should be equal to no$response
 if (all(simul.f$response==no$response))
   cat("Correct calculation of response\n")  else
   cat("Incorrect calculation of response\n")
# simul.f$d.resp should be equal to no$d.resp:
 if (all(simul.f$d.resp==no$d.resp))
   cat("Correct calculation of d.resp\n")  else
       cat("Incorrect calculation of d.resp\n")

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
