# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("substrat")

# ---------------------------------------------------------------
# Example SUBSTRAT:
# example of model described by a differential equations system.
#  2 independent variables, curves, and numerical and equality
# constraints between parameters.
# Functions called:
# "nls2", "calcmodnls2"
# ---------------------------------------------------------------

# Context creation:
  Theta0 <- c(
 0.0365462, 0, 143.143, 0.0780203, 65.3065, 
    -0.470539, 0.152847, 0.305194, 3.98004, 7, 
0.0365462, 0, 30.127, 0.174533, 0.0165749, 
    -0.470539, 0.0794103, 5.67044, 1.40917, 7, 
0.0365462, 0, 78.5286, 0.0627824, 35.8085, 
    -0.470539, 0.0987851, 0.731376, 2.21063, 7)

  substrat.stat.ctx <-list( theta.start=Theta0, 
         algorithm= "GM", lambda.start=5,
         max.iters=5)

# Control creation:
  substrat.control <- list(freq=0)

# Integration context:
  substrat.integ.ctx <-list(start=0, nb.theta.odes=7)

# Model creation:
substrat.model <-list(file=substrat.mod, gamf=-1, 
     eqp.theta=c(1:10,1,2,11:13,6,14:17,1,2,18:20,6,21:24),
     eq.theta=c(NaN,0, rep(NaN,7),7,
                 NaN,0 ,rep(NaN,7),7,
                 NaN,0 ,rep(NaN,7),7),
     inf.theta=c(rep(NaN,3),0,0,NaN,rep(0,4), 
                rep(NaN,3),0,0,NaN,rep(0,4),
                rep(NaN,3),0,0,NaN,rep(0,4))
         )

# ---------------------------------------------------------------
lesystem(paste(.Nls2dir, "/analDer ", substrat.mod, " > substrat.mod.c", sep=""))
nomlib <- loadnls2("substrat.mod.c")

  substrat.nls2  <- nls2(substrat,substrat.model,substrat.stat.ctx, 
      method="MLT", integ.ctx=substrat.integ.ctx, control=substrat.control)
  print(substrat.nls2)

# ---------------------------------------------------------------
# calcmodnls2
# ---------------------------------------------------------------

  # Direct calculation of the model for the initial values:
#  Example of evaluation of phi:
# -----------------------------
# call to nls2 to calculate FOdes and d.FOdes for the initial values
# without constraints:
  mod <-list(file=substrat.mod, gamf=-1) 
  ctx <- substrat.stat.ctx
  ctx$max.iters <- 0

  no <- nls2(substrat,mod,ctx, 
      method="MLT", integ.ctx=substrat.integ.ctx, control=list(freq=0))


  substrat.phi  <- calcmodnls2(substrat, file=substrat.mod, 
               theta=substrat.stat.ctx$theta.start, gamf=-1,
               FOdes=no$FOdes, d.FOdes=no$d.FOdes,func="phi",
               integ.ctx=substrat.integ.ctx)

# substrat.phi should be equal to no:
  if (all(substrat.phi$response==no$response))
    cat("Correct calculation of response\n")  else
    cat("Incorrect calculation of response\n")
  if (all(substrat.phi$d.resp==no$d.resp))
    cat("Correct calculation of d.resp\n")  else
    cat("Incorrect calculation of d.resp\n")
    
#  Example of evaluation of the odes:
# -----------------------------
  substrat.odes  <- calcmodnls2(substrat, substrat.mod, 
              theta=substrat.stat.ctx$theta.start, gamf=-1,
              integ.ctx=substrat.integ.ctx,func="odes")


# substrat.odes should be equal to no:
  if (all(substrat.odes$FOdes==no$FOdes))
    cat("Correct calculation of FOdes\n")  else
    cat("Incorrect calculation of FOdes\n")
  if (all(substrat.odes$d.FOdes==no$d.FOdes))
    cat("Correct calculation of d.FOdes\n")  else
    cat("Incorrect calculation of d.FOdes\n")

  if (all(substrat.odes$response==no$response))
    cat("Correct calculation of response\n")  else
    cat("Incorrect calculation of response\n")
  if (all(substrat.odes$d.resp==no$d.resp))
    cat("Correct calculation of d.resp\n")  else
    cat("Incorrect calculation of d.resp\n")

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
