# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("tiller")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 3.6")
cat("\n#------------------------------------------------------\n")

cat(" ---------------------------\n")
cat(" Growth of winter wheat tiller example ") 
cat(" ---------------------------\n\n")

cat(" Plot of the observed dry weights on a degree") 
cat(" days time scale. \n\n") 

if (interactive()) {X11(); par(ask=T)} else { postscript(file="tiller.ps"); par(ask=F)  }

plot(DegreeDays,DryWeight,xlab="degree days",ylab="dry weight",
    main="Growth of winter wheat tillers example",
    sub="Observed response")

cat("\n Plot of the empirical variance versus mean \n\n") 
tiller.mean<-as.vector(
  unlist(lapply(split(DryWeight,DegreeDays),mean)))
tiller.var<-as.vector(
  unlist(lapply(split(DryWeight,DegreeDays),var)))
plot(tiller.mean, tiller.var, xlab="mean", ylab="var",
  main="Growth of winter wheat tillers example",
  sub="Empirical response variance versus response mean")
plot(log(tiller.mean), log(tiller.var), 
    xlab="log(mean)", ylab="log(var)",
    main="Growth of winter wheat tillers example",
    sub="Log of empirical response variance\
versus log of response mean")

cat("\n Parameters estimation under hypothesis H \n\n") 
tiller.lm <- lm(log(DryWeight) ~ DegreeDays)
lesystem(paste(.Nls2dir, "/analDer ", tiller.exp.m2, " > tiller.exp.m2.c", sep=""))
nomlib <- loadnls2("tiller.exp.m2.c")

tiller.nl2 <- nls2(tiller, tiller.exp.m2,
   c(exp(tiller.lm$coefficients[1]),tiller.lm$coefficients[2]),
	control=list(freq=0))
   # Print the results:
cat( "Estimated values of the parameters:\n ")
cat(tiller.nl2$theta)
cat( "\nEstimated value of sigma2:\n ")
cat( tiller.nl2$sigma2)
cat( "\nEstimated asymptotic covariance matrix: \n ")
cat(tiller.nl2$as.var); cat("\n\n")
plot(DegreeDays,DryWeight,xlab="degree days",ylab="dry weight",
     main="Growth of winter wheat tillers example",
     sub="Observed response")
X<-seq(400,685,length=100)
Y<-tiller.nl2$theta[1]*exp(tiller.nl2$theta[2]*X)
lines(X,Y)


 cat("\n ---------------------------\n")
 cat(" Parameters estimation under hypothesis A \n\n") 

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
lesystem(paste(.Nls2dir, "/analDer ", tiller.exp.m7, " > tiller.exp.m7.c", sep=""))
nomlib <- loadnls2("tiller.exp.m7.c")

tiller.nl7 <- nls2(tiller, tiller.exp.m7,
  list(theta.start = c(tiller.nl2$theta, 1), max.iters=500),
	control=list(freq=0))
   # Print the results:
cat( "Estimated values of the parameters:\n ")
print(tiller.nl7$theta)
cat( "\nEstimated value of sigma2:\n ")
print( tiller.nl7$sigma2)
cat( "\nEstimated asymptotic covariance matrix: \n ")
print(tiller.nl7$as.var); cat("\n\n")

cat(" Plots of the fitted curves \n\n") 
plot(DegreeDays,DryWeight,xlab="DegreeDays",ylab="dry weight",
   main="Growth of winter wheat tillers example",
   sub="Observed response")
X<-seq(400,685,length=100)
Y<-tiller.nl7$theta[1] *
      exp((tiller.nl7$theta[2]*X)**tiller.nl7$theta[3])
lines(X,Y)
Z<-tiller.nl2$theta[1]*exp(tiller.nl2$theta[2]*X)	
par (lty=2)
lines (X,Z)
par (lty=1)

cat("\n Likelihood ratio test of ``H: $\theta <- {3}=1$'' against ``A:") 
cat("  $\theta <- {3} \neq 1$'' \n\n") 

cat( "Sl:", 
  dim(tiller)[1] * (tiller.nl2$loglik - tiller.nl7$loglik),
  "X2(0.95,1):",  qchisq(0.95,1), "\n\n")

cat("\n Confidence interval for $\theta <- {3}$") 
cat("\n using the asymptotic distribution of $widehat{theta} <- {3}$ \n\n") 
tiller.In <- confidence(tiller.nl7)
  # Print the results:
cat("Estimated value of theta <- 3:", tiller.nl7$theta[3],"\n" )
cat("Estimated value of S:", sqrt(tiller.nl7$as.var[3, 3]),"\n" )
cat("nu <- (0.975):", qnorm(0.975),"\n" )
cat("Estimated value of In:",tiller.In$normal.conf.int[3,],"\n" )

cat("\n Confidence interval for $\theta <- {3}$\n") 
cat("  using the log-likelihood ratio \n\n") 

cat("Estimated value of theta <- 3:", tiller.nl7$theta[3],"\n" )
cat("Estimated value of S:", sqrt(tiller.nl7$as.var[3, 3]),"\n" )
cat("X2(0.95,1):", qchisq(0.95, 1),"\n" )
cat("Estimated value of Is:",
	conflike(tiller.nl7,parameter=3)$like.conf.int,"\n" )

cat(" \nConfidence interval using the bootstrap method \n\n")
tiller.nl7 <- nls2(tiller, tiller.exp.m7, 
	list(theta.start = c(tiller.nl2$theta, 1), max.iters=500),
       control=list(freq=0),renls2=T) 
tiller.boot <- bootstrap(tiller.nl7,method="wild.2",n.loops=500)
tiller.Tg <- (tiller.boot$pStar[,3]-tiller.nl7$theta[3])/sqrt(tiller.boot$var.pStar[,3])

qu <- quantile(tiller.Tg,probs=c(0.975,0.025))
tiller.IntBoot <- tiller.nl7$theta[3]-qu*sqrt(tiller.nl7$as.var[3,3])
cat("Estimated value of theta_3:", tiller.nl7$theta[3],"\n")
cat("Estimated value of S:", sqrt(tiller.nl7$as.var[3,3]),"\n")
cat("b_(0.025):", qu[2], "\n")
cat("b_(0.975):", qu[1], "\n")
cat("Estimated value of Ib:",
tiller.nl7$theta[3] + qu[2]*sqrt(tiller.nl7$as.var[3,3]),
tiller.nl7$theta[3] + qu[1]*sqrt(tiller.nl7$as.var[3,3]),"\n")


if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
