# Exemple vaso (Aitkin, page 167)

# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("vaso")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 6.7")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Vaso example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation ") 
cat("\n\n") 


nomlib <- loadnls2()
ctx <- list(theta.start=rep(0,3), sigma2.type="KNOWN",  sigma2=1,family="bernoulli")
vaso.nl1 <- nls2(vaso, vaso.m, ctx, method="QLT", control=list(freq=0))

cat( "Result of the estimation process:\n ")
print(summary(vaso.nl1))
cat( "\nvalue of the minimum deviance:\n ")
print(vaso.nl1$deviance)


cat("\n\n Likelihood ratio test of ")
cat("\n $\"{\rm H}: \theta_{1} =  \theta_{2}\"$ against $\"{\rm A}:")
cat("\n \theta_{1} \neq \theta_{2}\"$ \n")

model <- list(file=vaso.m, eqp.theta=c(1,2,2))
vaso.nl2 <- nls2(vaso, model,ctx,method="QLT",
	control=list(freq=0))

cat( "Result of the estimation process:\n ")
cat( "under the hypothesis A ``t1=t2'':\n ")
print(summary(vaso.nl2))
cat( "\nvalue of the minimum deviance\n ")
cat( "under the hypothesis A ``t1=t2'':\n ")
print(vaso.nl2$deviance)
cat( "SL:", 
    (vaso.nl2$deviance - vaso.nl1$deviance),
    "X2(0.95,1):",  qchisq(0.95,1), "\n\n")

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
