# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("weibull")


# ---------------------------------------------------------------
# Example WEIBULL
# simple example of a Weibull model.
#  4 parameters, 9 observations and variance constant.
# Functions called:
# "nls2", "rexnls2"
# ---------------------------------------------------------------

cat("\n ---------------------------")
  cat("\n WEIBULL example ") 
  cat("\n ---------------------------")
  cat("\n Parameters estimation ") 
  cat("\n\n") 
lesystem(paste(.Nls2dir, "/analDer ", weibull.mod, " > weibull.mod.c", sep=""))
nomlib <- loadnls2("weibull.mod.c")

# Context creation:
weibull.stat.ctx <- list(theta.start=c(70,62,0.0001,2.5))
# ---------------------------------------------------------------
# nls2
# ---------------------------------------------------------------

  weibull.nl  <- nls2(weibull, weibull.mod,weibull.stat.ctx,
                        control=list(freq=0))
  print(weibull.nl)

# ---------------------------------------------------------------
# rexnls2
# ---------------------------------------------------------------
#The "onexrenls2" function processes each call to "rexnls2":
onexrenls2 <- function(i, nls2.out, data)
    {
# the observation i is removed:
    data$weights[i] <- 0
    return(rexnls2(nls2.out,data, sv.num.res=T)$rss)
    }

  #returns the successive values of "rss"
  #by removing one observation each time.
  # Create the nls2.object: all the observations, 
  # except from the first one, are included in 
  # the analysis:
  leweibull <- weibull
  leweibull$weights <- c(0,rep(1, (nrow(weibull)-1)))
  # the "freq" option of the "control" argument is used 
  # to suppress all printing. Otherwise, intermediate 
  # results will appear each successive estimations.
  nls2.out<-nls2(leweibull, weibull.mod,weibull.stat.ctx,
               control=list(freq=0), renls2=T)

  # Initialisations of the successive estimations:
  # the S-option "warn" is used to prevent the same 
  # warnings from appearing each successive estimations.
#  options(warn=-1)
  # Build a matrix for storing the weighting values;
  # so the S-command "apply" can be used:

  iobs <- matrix(2:nrow(weibull), ncol=1)
  leweibull$weights[1] <- 1
  rss <-  apply(iobs, 1, onexrenls2, nls2.out, leweibull)
  # Delete the internal structures that are no more useful:
  delnls2()
  rexnls2.out <- c(nls2.out$rss,rss)
  print(rexnls2.out)	

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++




