/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"


#define MAXLIG 255
#define MAXMOT 50
/* ------ Functions used before their definition ------------*/

void cptemots(FILE *fic, TFuncInt *Nb, TFuncInt *Code);
void mots(FILE *fic, TFuncInt *Nb, char ***PointeurNoms, TFuncInt *Code);

/*--------------- Identification fonction ----------
| Nom de la fonction    : nbListnls2            |
| Role                  : compter les elements des |
|  listes du fichier de description du modele      |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: analFilenls2                      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void nbListnls2(ficmod, 
         NbTheta, NbBeta,  NbGamF, NbGamV, NbX,
         NbJ, NbEq, NbDF,
         YaCalcV,CasSedo, IndicCi,
         YaSubr,
         Code)

/* arguments d'entree */
char **ficmod;


/* arguments de sortie */
TFuncInt *NbTheta, *NbBeta,  *NbGamF, *NbGamV, *NbX, *NbJ, *NbEq, *NbDF;
TFuncInt *YaCalcV, *CasSedo, *IndicCi,*YaSubr;
TFuncInt *Code;

/*--------------- Fin identification fonction ----*/

{


char motlu[MAXMOT], ch[MAXLIG];
FILE *fic;

if ( (fic=fopen(*ficmod,"r")) == NULL)
  /* if ( (int)(fic= fopen(*ficmod,"r")) == NULL) */


  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }

while( fscanf(fic,"%s", motlu) != EOF)
  {


    if (strncmp(motlu, "%",1) ==0)
      {
      fgets(ch, MAXLIG, fic);
      continue;
      }


    if (strncmp(motlu,"varind", 6)==0)
      {
      cptemots(fic, NbX, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"parresp", 7)==0)
      {
      cptemots(fic, NbTheta, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"parvar", 6)==0)
      {
      cptemots(fic, NbBeta, Code);
      if (*Code !=OK) return;
      continue;
      }


    if (strncmp(motlu,"pbisresp", 8)==0)
      {
      cptemots(fic, NbGamF, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"pbisvar", 7)==0)
      {
      cptemots(fic, NbGamV, Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"varint", 6)==0)
      {
      *CasSedo=1;
      continue;
      }

    if (strncmp(motlu,"var", 3)==0)
      {
      /* variance */
      *YaCalcV=1;
      continue;
      }

    if (strncmp(motlu,"valint", 6)==0)
      {
      cptemots(fic, NbJ,  Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"F", 1)==0)
      {
      cptemots(fic, NbEq,  Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"dF", 2)==0)
      {
      cptemots(fic, NbDF,  Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"condinit", 8)==0)
      {
      *IndicCi=1;
      continue;
      }


    if (strncmp(motlu,"subroutine", 10)==0)
      {
      *YaSubr=1;
      break;
      }



  } /* fin du while fscanf */

fclose(fic);
return;
}

/* ------------- fin nbListnls2 ----------------------------- */

/*--------------- Identification fonction ----------
| Nom de la fonction    : cptemots
| Role                  : compter les elements d'une |
|  liste du fichier de description du modele      |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction C: nbListls2
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void cptemots(FILE *fic, TFuncInt *Nb, TFuncInt *Code)

/* arguments d'entree 
FILE *fic;

 arguments de sortie 
TFuncInt *Nb;
TFuncInt *Code;
*/


/*--------------- Fin identification fonction ----*/

{

char chaine[MAXLIG], chlu[MAXLIG];


strcpy(chaine,"");
do
  {
  if( fscanf(fic,"%s",chlu) == EOF)
    {
    fprintf(stderr,
"\n Error: a key-word not followed by at least one value \n");
    *Code=ERR;
    return;
    }
  strcat(chaine,chlu);
  }  while(strstr(chlu,";")==NULL);


/* les blancs sont otes de la liste */
strtok(chaine,",;");
*Nb=1;
while(strtok(NULL, ",;") !=NULL)
  {
  *Nb = *Nb + 1;
  }
return;
}

/* ------------- fin cptemots ----------------------------- */

/*--------------- Identification fonction ----------
| Nom de la fonction    : nameListnls2             |
| Role                  : renvoyer les noms des    |
|  listes du fichier de description du modele      |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: analFilenls2                      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void nameListnls2(ficmod,
              NbTheta, NbBeta,NbGamF, NbGamV,
              NbX, NbJ,NbEq, NbDF,
              NomTheta, NomBeta,NomGamF,NomGamV,
              NomX, NomY, NomValInt, NomLesF,NomLesDF,
              Code)

/* arguments d'entree */
char **ficmod;
TFuncInt *NbTheta, *NbBeta, *NbGamF, *NbGamV,*NbX, *NbJ, *NbEq, *NbDF;
/* arguments de sortie */
char ***NomTheta, ***NomBeta, ***NomGamF, ***NomGamV, ***NomX,  **NomY;
char ***NomValInt, ***NomLesF, ***NomLesDF;
TFuncInt *Code;

/*--------------- Fin identification fonction ----*/

{


  /* char NomModele[MAXLGFIC] */
char ch[MAXLIG];
char motlu[MAXMOT], nom[MAXMOT];

FILE *fic;
/* strcpy(NomModele, *ficmod); */


if( (fic=fopen(*ficmod,"r")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }

while(  fscanf(fic,"%s", motlu) != EOF)
  {
    if (strncmp(motlu, "%",1) ==0)
      {
      fgets(ch, MAXLIG, fic);
      continue;
      }


    if (strncmp(motlu,"resp", 4)==0)
      {
      if(fscanf(fic,"%s", nom)==EOF)
        {
        fprintf(stderr,
"\n Error: the key-word `resp' not followed by a value \n");
        *Code=ERR;
        return;
       }

      /* avant le 2/05/2003:
 #ifdef LINUX 
      strcpy( *NomY, (char *)strtok(nom,";") );
#else
      *NomY= (char *)strtok(nom,";");
#endif
      */
      strcpy( *NomY, (char *)strtok(nom,";") );

      continue;
      }


    if (strncmp(motlu,"varind", 6)==0)
      {
      mots(fic, NbX, NomX, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"parresp", 7)==0)
      {
      mots(fic, NbTheta, NomTheta, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"parvar", 6)==0)
      {
      mots(fic, NbBeta, NomBeta, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"pbisresp", 8)==0)
      {
      mots(fic, NbGamF, NomGamF, Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"pbisvar", 7)==0)
      {
      mots(fic, NbGamV, NomGamV, Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"valint", 6)==0)
      {
      mots(fic, NbJ,NomValInt,  Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"F", 1)==0)
      {
      mots(fic, NbEq,  NomLesF, Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"dF", 2)==0)
      {
      mots(fic, NbDF, NomLesDF, Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"subroutine", 10)==0)
      {
      break;
      }

  } /* fin du while fscanf */

fclose(fic);
return;
}

/* ------------- fin nameListnls2 ----------------------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : mots
| Role                  : renvoyer les elements d'une |
|  liste du fichier de description du modele      |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction C: nameListnls2
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void mots(FILE *fic, TFuncInt *Nb, char ***Noms, TFuncInt *Code)

/* arguments d'entree
FILE *fic;
TFuncInt *Nb;

arguments de sortie
char ***Noms;
TFuncInt *Code;
*/

/*--------------- Fin identification fonction ----*/

{

char chaine[MAXLIG], chlu[MAXLIG];
int i;

strcpy(chaine,"");
do
  {
  if( fscanf(fic,"%s",chlu) == EOF)
    {
    fprintf(stderr,
"\n Error: a key-word not followed by at least one value \n");
    *Code=ERR;
    return;
    }
  strcat(chaine,chlu);
  }  while(strstr(chlu,";")==NULL);

/* dans chaine, les blancs sont otes de la liste */
strcpy((Noms[0]), (char *)strtok(chaine,",;"));

for (i=1; i<*Nb; i++)
  {
   strcpy((Noms[i]),(char *)strtok(NULL, ",;"));
  }
return;
}

/* ------------- fin mots ----------------------------- */
