#include <stdio.h>
#include <stdlib.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlglobal.h"
#include "nlchoix.h"
/*--------------- VARIABLES EXTERNES -------------*/
/* les arguments de NL: */
#include "nldcl.h"

/*----------------FONCTIONS EXTERNES ------------*/
short int calcf_(short int nbt, short int nbg, short int nbl, 
		 short int nbc, 
		 double *t, double *g, double **x, 
		 double *f, double **df, 
		 short int *le, short int *ie);


short int calcv_(short int nbt, short int nbb, short int nbg, short int nbl, 
		 short int nbc, 
		 double *t, double *b, double *g,
		 double *f, double **df, double **x, double *v, 
		 double **dtv, double **dbv, short int *le, short int *ie);

short int calcphi_(short int nbt, short int nbg, short int nbl, short int nbc,
		   double *t, double *g, double **x, double ***Fsedo, 
		   double ***dFsedo, double *f, double **df, 
		   short int *le, short int *ie);

TShortInt AlloueSedo ( TLongInt NbObs,
                       TSedo *Sedo);
TShortInt GerMessage( );
TShortInt ModSedo(TShortInt nbt,TShortInt nbg,TShortInt nbl,TShortInt nbc,
		  TDouble *theta, TDouble *gamf,TDouble **xobs,
		  TDouble ***FSedo,TDouble ***DFSedo,
		  TDouble *f, TDouble **df,
		  TShortInt *le,TShortInt *ie,
		  TShortInt indc);
TShortInt NL(TDonnees *Donnees, TModele *Modele, TCtxPuss *CtxPuss, TCtxNum CtxNum[],
             TContr CTheta[], TContr CBeta[], TParam Theta[], TParam Beta[],
	     TResNum ResNum[], TResStat ResStat[],
             TShortInt NbItSv[MAXETAP], TResNum ItNum[MAXETAP][MAXSVIT],
	     TResStat ItStat[MAXETAP][MAXSVIT], 
	     TVect ItTheta[MAXETAP][MAXSVIT], TVect ItBeta[MAXETAP][MAXSVIT], 
	     TVect ItDirec[MAXETAP][MAXSVIT], TDouble ItOmega[MAXETAP][MAXSVIT]);
TShortInt NLDebut(TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum CtxNum[]);


TShortInt NLVCtxInteg(TShortInt NbCourbe, 
		      TVectLong *NbObsC, 
		      TVectLong *NbRepet, 
		      TMat *XObs, TVect *PoidsT);


TShortInt NLVDon(TDonnees *Donnees, TShortInt *Code);
TShortInt CreerMat( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectShort(TShortInt nbele, TVectShort *pvect);
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
void DetruMatC(TMat *pmat);
void DetruVect(TVect *pvect);
void DetruSedo (TLongInt NbObs, TSedo *Sedo);
void DetruTrace();
void DetruDon(TDonnees *Donnees);
void DetruCtxI( TShortInt NbCourbe);

void crTracenls2();
void initcrolenls2(TFuncInt *check, TFuncInt *warn);




/* ---------------- debutCalcnls2---------------- */

void debutCalcnls2()
{
/* initialisation des donnees */
CreerMat((TShortInt)0, (TShortInt)0, &(Donnees.XObsT));
CreerVect((TShortInt)0, &(Donnees.ValY));
CreerVect((TShortInt)0, &(Donnees.PoidsT));
CreerVectStr((TShortInt)0, &(Donnees.NomCT));
CreerVectStr((TShortInt)0, &(Donnees.NomObsT));
CreerVectStr((TShortInt)0, &(Donnees.NomX));
CREER_T1(Donnees.NomY, MAXCH, char);
strcpy(Donnees.NomY, DEFY);
/* Donnees.NomY=DEFY; */
Donnees.NbX = 1;
Donnees.NbCourbe = 1;
return;
}
/* -------------- Fin fonction debutCalcnls2 ----------------- */


/* ---------------- debutOdesnl2 ---------------- */
void debutOdesnls2()
{

/* initialisation du contexte d'integration  */
CreerVect((TShortInt)1, &(GNLCtxInteg.atol)); /* tolerance absolue */
GNLCtxInteg.atol.donnees[0]=DEFATOL;
CreerVect((TShortInt)1, &(GNLCtxInteg.rtol)); /* tolerance relative */
GNLCtxInteg.rtol.donnees[0]=DEFRTOL;
CreerVect((TShortInt)0, &(GNLCtxInteg.T0Bis)); /* tableau de travail */
CreerVectShort((TShortInt)0, &(GNLCtxInteg.IndicTj)); /* tableau de travail */
GNLCtxInteg.ImpInteg=FAUX; /* pas d'impression (non disponible) */
GNLCtxInteg.IndicCi=VRAI;  /* Valeurs initiales sont des parametres */
GNLCtxInteg.IndicX=FAUX;   /* Xobs n'intervient pas dans les equations */
GNLCtxInteg.iopt=FAUX;      /* pas d'options de lsoda */
GNLCtxInteg.itol=DEFITOL; /* type de tolerance */
GNLCtxInteg.jt=DEFJT;
GNLCtxInteg.LongSys=0;
GNLCtxInteg.liw=0;
GNLCtxInteg.lrw=0;
/* initialisation des donnees */
debutCalcnls2();
return;
}

/* ----------------- initCalcnls2 ---------------------------- */
void initCalcnls2( k)
TFuncInt  *k;
{
TShortInt CodeDon;

 /* creation de la trace */
  crTracenls2();
  /* verif et init des donnees */
  NLVDon(&Donnees, &CodeDon);
  /* AB: 27/06/2001
     Je supprime NLERREUR car celui-ci retourne une valeur
     alors que la fonction est void, ce qui est obligatoire
     car celle-ci est appele par Splus */
  /*  if (CodeDon != OK)  NLERREUR((ERRVINIT,1,"NLVInit", ERR));*/
  if (CodeDon != OK)
    {
      GerMessage(ERRVINIT,1,"NLVInit", ERR);
      return;
    }

  *k= Donnees.XObs.nblig;

}

/* -------------- Fin fonction initCalcnls2 ----------------- */

/* ----------------- initOdesnls2 ---------------------------- */
void initOdesnls2(pbase, k, LgDSedo)
TFuncInt *pbase, *k,  *LgDSedo;
{

 /* creation de la trace et verif et init des donnees */
  initCalcnls2(k);
  /* verif et init de CtxInteg */
  NLVCtxInteg(Donnees.NbCourbe,  &(Donnees.NbObsC),
                    &(Donnees.NbRepet),  &(Donnees.XObs),
                    &(Donnees.PoidsT));
  *LgDSedo= GNLCtxInteg.LongSys -  GNLCtxInteg.NbEq;

/* Allocation de FSedo et DFSedo */
AlloueSedo((TLongInt) *k, &(ResStat[0].Sedo));
/* Allocation des   Ajustes */
CreerVect((TShortInt) *k, &(ResStat[0].Ajustes.Valf));
/*  Allocation des FctSensib */
CreerMatC( (TShortInt) *k, (TShortInt) *pbase, &(ResStat[0].FctSensib.DValf));
return;

}

/* -------------- Fin fonction initOdesnls2 ----------------- */

/* ----------------- calcfnls2 ---------------------- */
void calcfnls2(pbase, nbgf,  Theta, GamF, f, df, le, ie)
      TFuncInt *pbase, *nbgf;
      double *Theta, *GamF,  *f, *df;
      TFuncInt *le, *ie;
{

short int i,j,l,lee, iee, RetCode, NbObs, NbExpl, NbCourbe, IParamT, IObs, ICourbe;
TMat dfo;

NbObs=Donnees.XObs.nblig;
NbExpl=Donnees.XObs.nbcol;

/* mettre df sous forme de matrice allouee continuement  */
CreerMatC((TShortInt)NbObs, (TShortInt)*pbase, &dfo);

NbCourbe = Donnees.NbCourbe;
/* initialisation de la boucle sur les courbes */
IParamT = 0;
IObs = 0;
lee=iee=0;

for (ICourbe = 0 ; ICourbe < NbCourbe ; ICourbe++)
  {
  RetCode=calcf_((short int)*pbase, (short int)*nbgf, 
              Donnees.NbObsC.donnees[ICourbe], NbExpl, &(Theta[IParamT]),
              GamF,
              &(Donnees.XObs.donnees[IObs]),
              &(f[IObs]), &(dfo.donnees[IObs]), &lee, &iee);


  if(RetCode !=OK)
    {
    *ie = iee + IObs;
    *le = lee;
    return;
    }


  IObs = IObs + Donnees.NbObsC.donnees[ICourbe];
  IParamT= IParamT + *pbase;
  } /* fin boucle sur les courbes */



/* Mettre dfo dans df */
l=0;
for(i=0; i<NbObs; i++)
  {
  for (j=0; j< *pbase; j++)
    {
     df[l]=dfo.donnees[i][j]; 
     l=l+1;
    }
  }

/* desallouer dfo */
DetruMatC( &dfo);


*ie=0;
*le=0;

return;

}
/* ---------------- end of calcfnls2 -----------------*/

/* ----------------- calcvnls2 ---------------------- */
void calcvnls2(pbase, qbase, nbgv,  Theta, Beta, GamV,f, df,
      v,dtv,dbv,  le, ie)
      TFuncInt *pbase, *qbase, *nbgv;
      double *Theta, *Beta, *GamV,  *f, *df, *v, *dtv, *dbv;
      TFuncInt *le, *ie;
{

short int i,j,l,lee, iee, RetCode, NbObs, NbExpl,NbCourbe, IParamT, IParamB, IObs, ICourbe;
TMat dfo, dtvo, dbvo;

NbObs=Donnees.XObs.nblig;
NbExpl=Donnees.XObs.nbcol;

/* mettre df sous forme de matrice allouee continuement  */
CreerMatC((TShortInt)NbObs, (TShortInt)*pbase, &dfo);

for(i=0; i<NbObs; i++)
  {
  for (j=0; j< *pbase; j++)
    {
     dfo.donnees[i][j]=df[i +(j * NbObs)];
    }
  }


/* mettre dtv sous forme de matrice */
 CreerMatC((TShortInt)NbObs, (TShortInt)*pbase, &dtvo); 

/* mettre dbv sous forme de matrice */
CreerMatC((TShortInt)NbObs, (TShortInt)*qbase, &dbvo);

NbCourbe = Donnees.NbCourbe;
lee=iee=0;

/* initialisation de la boucle sur les courbes */
IParamT = 0;
IParamB = 0;
IObs = 0;
for (ICourbe = 0 ; ICourbe < NbCourbe ; ICourbe++)
  {
  RetCode=calcv_((short int)*pbase, (short int)*qbase, (short int)*nbgv, 
              Donnees.NbObsC.donnees[ICourbe], NbExpl, &(Theta[IParamT]),
              &(Beta[IParamB]),
              GamV, &(f[IObs]), &(dfo.donnees[IObs]),
              &(Donnees.XObs.donnees[IObs]),
              &(v[IObs]), &(dtvo.donnees[IObs]), &(dbvo.donnees[IObs]), &lee, &iee);

  if(RetCode !=OK)
    {
    *ie = iee + IObs;
    *le = lee;
    return;
    }

  /* incrementation des indices de boucle */
  IParamT = IParamT + *pbase;
  IParamB = IParamB + *qbase;
  IObs = IObs + Donnees.NbObsC.donnees[ICourbe];
  } /* fin boucle sur les courbes */



/* Mettre dtvo dans dtv */
l=0;
for(i=0; i<NbObs; i++)
  {
  for (j=0; j< *pbase; j++)
    {
    dtv[l]=dtvo.donnees[i][j];
    l=l+1;
    }
  }

/* Mettre dbvo dans dbv */
if(*qbase>0)
  {
  l=0;
  for(i=0; i<NbObs; i++)
    {
    for (j=0; j< *qbase; j++)
      {
      dbv[l]=dbvo.donnees[i][j];
      l=l+1;
      }
    }
  }

/* desallouer dfo */
DetruMatC( &dfo); 


/* desallouer dtvo */
DetruMatC( &dtvo);


/* desallouer dbvo */
DetruMatC( &dbvo);


*ie=0;
*le=0;

return;
}
/* ---------------- end of calcvnls2 -----------------*/


/* ----------------- calcphinls2 ---------------------- */
void calcphinls2(pbase, nbgf, nbj, nbeq, l3,
           Theta, GamF, fodes, dfodes,
           f,df, le, ie)
      TFuncInt *pbase, *nbgf, *nbj, *nbeq, *l3;
      double *Theta, *GamF, *fodes, *dfodes, *f, *df;
      TFuncInt *le, *ie;
{

short int i,j, lee, iee, kf, kdf,l,RetCode, NbObs, NbExpl,NbCourbe, IParamT, IObs, ICourbe;
double  ***FSedo, ***DFSedo;
TMat dfo;

NbObs=Donnees.XObs.nblig;
NbExpl=Donnees.XObs.nbcol;

/* mettre FSedo, DFSedo sous forme de matrice */
FSedo = (TDouble ***) calloc ((unsigned) NbObs, sizeof (TDouble **));
DFSedo = (TDouble ***) calloc ((unsigned) NbObs, sizeof (TDouble **));
if ( (FSedo==NULL) || (DFSedo==NULL))
  {
  fprintf(stderr,"Memory allocation problem\n");
  return;
  }

kf=0;
kdf=0;
for (i = 0; i < NbObs; i++)
  {
  FSedo[i] = (TDouble **)
       calloc ((unsigned) *nbj, sizeof (TDouble *));
  DFSedo[i] = (TDouble **)
       calloc ((unsigned) *nbj, sizeof (TDouble *));
  if ( (FSedo[i]==NULL) || (DFSedo[i]==NULL))
    {
    fprintf(stderr,"Memory allocation problem\n");
    return;
    }

  for (j =0; j < *nbj; j++)
    {
    FSedo[i][j] = (TDouble *)
        calloc ((unsigned) *nbeq, sizeof (TDouble ));
    DFSedo[i][j] = (TDouble *)
        calloc ((unsigned) *l3, sizeof (TDouble ));
    if ( (FSedo[i][j]==NULL) || (DFSedo[i][j]==NULL))
      {
      fprintf(stderr,"Memory allocation problem\n");
      return;
      }
    for (l=0; l< *nbeq; l++)
      {
      FSedo[i][j][l]= fodes[kf];
      kf=kf+1;
      }
    for (l=0; l< *l3; l++)
      {
      DFSedo[i][j][l]= dfodes[kdf];
      kdf=kdf+1;
      }

    } /* fin boucle sur j */
  } /* fin boucle sur i */



/* mettre df sous forme de matrice allouee continuement  */
CreerMatC((TShortInt)NbObs, (TShortInt)*pbase, &dfo);


NbCourbe = Donnees.NbCourbe;
lee=iee=0;

/* initialisation de la boucle sur les courbes */
IParamT = 0;
IObs = 0;
for (ICourbe = 0 ; ICourbe < NbCourbe ; ICourbe++)
  {
  RetCode=calcphi_((short int)*pbase, (short int)*nbgf,
                   Donnees.NbObsC.donnees[ICourbe], NbExpl, &(Theta[IParamT]),
                   GamF,
                   &(Donnees.XObs.donnees[IObs]),
                   &(FSedo[IObs]), &(DFSedo[IObs]), 
                   &(f[IObs]), &(dfo.donnees[IObs]), &lee, &iee);
  if(RetCode !=OK)
    {
    *ie = iee + IObs;
    *le = lee;
    return;
    }

  IObs = IObs + Donnees.NbObsC.donnees[ICourbe];
  IParamT= IParamT + *pbase;
  } /* fin boucle sur les courbes */



/* Mettre dfo dans df */
l=0;
for(i=0; i<NbObs; i++)
  {
  for (j=0; j< *pbase; j++)
    {
    df[l]=dfo.donnees[i][j];
    l=l+1;
    }
  }

/* desallouer dfo */
DetruMatC( &dfo);

/* desallouer le sedo */
for (i = 0; i < NbObs; i++)
  {
  for (j =0; j < *nbj; j++)
    {
    free ((char *) FSedo[i][j]);
    free ((char *) DFSedo[i][j]);
    }
  free ((char *) FSedo[i]);
  free ((char *) DFSedo[i]);
  }


*ie=0;
*le=0;

return;
}
/* ---------------- end of calcphinls2 -----------------*/


/*--------------- callOdesnls2 --------------------- */

void callOdesnls2(pbase, nbgf, Theta, GamF,
             le, ie)
/* argument d'entree */
TFuncInt *pbase, *nbgf;
double *Theta, *GamF;

/* argu de sortie */
TFuncInt   *le, *ie;
{
TShortInt  lee, iee, RetCode,  IObs, IParamT, ICourbe, NbExpl, NbCourbe;


NbExpl=Donnees.XObs.nbcol;
NbCourbe = Donnees.NbCourbe;

/* initialisation de la boucle sur les courbes */
IParamT = 0;
IObs = 0;
lee=iee=0;


for (ICourbe = 0 ; ICourbe < NbCourbe ; ICourbe++)
  {
  RetCode= (TShortInt)ModSedo((TShortInt)*pbase, (TShortInt)*nbgf, 
                   Donnees.NbObsC.donnees[ICourbe], NbExpl, &(Theta[IParamT]), 
                   GamF,
                   &(Donnees.XObs.donnees[IObs]),
                   &(ResStat[0].Sedo.FSedo[IObs]),
                   &(ResStat[0].Sedo.DFSedo[IObs]),
                   &(ResStat[0].Ajustes.Valf.donnees[IObs]),
                   &(ResStat[0].FctSensib.DValf.donnees[IObs]),
                   &lee, &iee, ICourbe);

  if(RetCode !=OK)
    {
    *ie = iee + IObs;
    *le = lee;
    return;
    }

  IObs = IObs + Donnees.NbObsC.donnees[ICourbe];
  IParamT= IParamT + *pbase;
  } /* fin boucle sur les courbes */
 
*ie=0;
*le=0;
  

}
/* -------------- Fin fonction callOdesnls2 ----------------- */


/* ------------------- recupfdfnls2 ------------------------- */

void recupfdfnls2(k,pbase, Valf, DValf)
TFuncInt *k, *pbase;
/* argu de sortie */
double  *Valf, *DValf;
{
TShortInt j,l, indDValf;

indDValf=0;

  if (ResStat[0].Ajustes.Valf.nbele>0)
    {
    for(j=0;j<ResStat[0].Ajustes.Valf.nbele;j++)
      {
      Valf[j]=ResStat[0].Ajustes.Valf.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*k;j++)
      {
      Valf[j]=(double)0;
      }
    }

  if(ResStat[0].FctSensib.DValf.nblig>0)
    {
    for(j=0; j<ResStat[0].FctSensib.DValf.nblig;j++)
      {
      for (l=0; l<ResStat[0].FctSensib.DValf.nbcol; l++)
        {
        DValf[indDValf]=ResStat[0].FctSensib.DValf.donnees[j][l];
        indDValf=indDValf+1;
        }
      }
    }
  else
    {
    for(j=0; j<(*k * *pbase) ;j++)
      {
      DValf[j]=(double)0;
      }
    }

}
/* -------------- Fin fonction recupfdfnls2 ----------------- */


/* ---------------- delCalcnls2 ---------------- */
void delCalcnls2()
{
DetruDon(&Donnees);
DetruTrace();
}
/* -------------- fin fonction  delCalcnls2 ---------------- */

/* ---------------- delOdesnl2 ---------------- */
void delOdesnls2()
{
long NbCourbe;

DetruVect( &(ResStat[0].Ajustes.Valf));
DetruMatC( &(ResStat[0].FctSensib.DValf));
DetruSedo( Donnees.NbObs, &(ResStat[0].Sedo));
delCalcnls2();
NbCourbe= (long)Donnees.NbCourbe;
DetruCtxI(Donnees.NbCourbe);

}
/* -------------- fin fonction  delOdesnl2 ---------------- */


