
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"

/* pour l'appel de analder */
#include "dftypes.h" 


/*--------------- VARIABLES EXTERNES -------------*/
/* les arguments de NL: */
#include "nldcl.h"  

/*----------------FONCTIONS EXTERNES ------------*/
void create_vect_str();
/* 5/7/2001: je ne declare pas les arguments
car warning: argument #1 is incompatible with prototype:
si on le fait et ca ne marche pas si on essaie d'etre compatible.
Les argu sont dans utilnls2.c:
 char **val, TFuncInt nbele, TVectStr *Struct);
*/
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
TShortInt NL(TDonnees *Donnees, TModele *Modele, TCtxPuss *CtxPuss, TCtxNum CtxNum[],
             TContr CTheta[], TContr CBeta[], TParam Theta[], TParam Beta[],
	     TResNum ResNum[], TResStat ResStat[],
             TShortInt NbItSv[MAXETAP], TResNum ItNum[MAXETAP][MAXSVIT],
	     TResStat ItStat[MAXETAP][MAXSVIT], 
	     TVect ItTheta[MAXETAP][MAXSVIT], TVect ItBeta[MAXETAP][MAXSVIT], 
	     TVect ItDirec[MAXETAP][MAXSVIT], TDouble ItOmega[MAXETAP][MAXSVIT]);
TShortInt NLDebut(TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum CtxNum[]);

void initcrolenls2(TFuncInt *check, TFuncInt *warn);


/* les sorties de analDer */
 TRetModele RetModele;
 TRetInteg RetInteg;

/*--------------- Identification fonction ----------
| Nom de la fonction    : callNLnls2                |
| Role                  : appeler le programme     |
|                         d'estimation de NL       |
| Parametres d'entree   : neant                    |
| Parametres de sortie  :                          |
|   NbEtapes: nombre d'etapes demandees            |
|   NbCourbe: nombre de courbes                    |
|   k: nombre de tuples differents                 |
|   n: nombre d'observations                       |
|   NbObsLu: n+ nombre de poids nuls               |
|   pmult,qmult: nombre de parametres multiples    |
|   NbJ, NbEq: voir description de GNLCtxInteg dans| 
|              notice NL                           |
|   LgDSedo:3ieme dimension du tableau des derivees|
|            du sedo                               |
|   vouluit: ce qu'on veut sauvegarder a chaque    |
|            iteration                             |
|   nbitsv: nombre d'iterations sauvegardees a     |
|           chaque etape                           |
|   pact,qact: vecteurs du nombre de parametres    |
|            actifs a chaque etape                 |
|  nh: vecteur de la dimension des statistiques    |
|            exhaustives a chaque etape            |
|   RetCode: code de retour de NL                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  NL                       |
| Fonctions appelantes :  la fonction S: nls2      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void callNLnls2(
         NbEtapes, 
         NbCourbe,
         k, n,NbObsLu, pmult, qmult,
         NbJ, NbEq, LgDSedo,
         vouluit, nbitsv,
         pact, qact, nh,
         RetCode)

/* scalaire */
TFuncInt   *NbEtapes, * NbCourbe, *k, *n,*NbObsLu, *pmult, *qmult; 
TFuncInt *NbJ, *NbEq, *LgDSedo;
/* vecteur de 1 a MAXETAP elements */
TFuncInt *vouluit;

/* vecteurs autant que d'etapes */
TFuncInt  *nbitsv, *pact, *qact, *nh;
/* scalaire */
TFuncInt   *RetCode;
{
/*--------------- Fin identification fonction ----*/
TShortInt  i;


TShortInt NbCodesErr=11;
TShortInt CodesErr[11];

/* CodesErr: les codes de retour de NL pour lesquels les sorties sont non valides */
/* erreur fatale dans ces cas */
CodesErr[0]=NONFAIT;
CodesErr[1]=ERRTYPES;
CodesErr[2]=ERRTRACE;
CodesErr[3]=ERRVINIT;
CodesErr[4]=ERWT;
CodesErr[5]=ERWM;
CodesErr[6]=ERWI;
CodesErr[7]=ERWN;
CodesErr[8]=ERRCMU;
CodesErr[9]=EPBALLOC;
CodesErr[10]=ERRALLOC;


*RetCode= (TFuncInt)NL(&Donnees, &Modele, &CtxPuss, CtxNum,
           CTheta, CBeta, Theta, Beta, ResNum, ResStat,
           NbItSv, ItNum, ItStat, ItTheta, ItBeta, ItDirec, ItOmega);


if(*RetCode !=OK)
  {
  for (i=0; i<NbCodesErr; i++)
    {
    if (*RetCode == CodesErr[i])
      {
      fprintf(stderr ,"\nError in the execution of the estimation program NL \n");
      return;
      }
    }
  /* erreur qui n'engendre pas un stop */
  *RetCode=OK;
  }

*NbEtapes=(TFuncInt)CtxPuss.NbEtapes;
*NbCourbe=(TFuncInt)Donnees.NbObsC.nbele;
*k=Donnees.StatDon.Y1.nbele;
*NbObsLu=Donnees.ValY.nbele;
*n=Donnees.NbObsT;
*pmult=Donnees.NbCourbe * Modele.NomTheta.nbele;
*qmult=Donnees.NbCourbe * Modele.NomBeta.nbele;

if (Modele.CasSedo ==1)
  {
  *NbJ= GNLCtxInteg.NbJ;
  *NbEq= GNLCtxInteg.NbEq;
  *LgDSedo= GNLCtxInteg.LongSys -  GNLCtxInteg.NbEq;
  }
else
  {
  *NbJ=0;
  *NbEq=0;
  *LgDSedo=0;
  }

vouluit[0]=GNLControle.VouluIt.Ajustes;
vouluit[1]=GNLControle.VouluIt.EquN;
vouluit[2]=GNLControle.VouluIt.Estim;
vouluit[3]=GNLControle.VouluIt.FctSensib;
vouluit[4]=GNLControle.VouluIt.NbIter;
vouluit[5]=GNLControle.VouluIt.ResNum;
vouluit[6]=GNLControle.VouluIt.Sedo;

for (i=0; i<*NbEtapes; i++)
  {
  pact[i]=Theta[i].Act.nbele;
  qact[i]=Beta[i].Act.nbele;
  nh[i]= ResStat[i].EquN.ValEta.nbele;
  nbitsv[i]=NbItSv[i];
  }


return;

}
/* -------------- Fin fonction callNLnls2 ----------------- */

/*--------------- Identification fonction ----------
| Nom de la fonction    : initnls2                 |
| Role                  :                          |
|   appeler NLDebut pour positionner les arguments |
|   de NL aux valeurs par defaut et modifier ces   |
|   valeurs par defaut selon les demandes de       |
|   l'utilisateur                                  |
| Parametres d'entree   :                          |
|    check: 1 si l'option de S 'check' est TRUE    |
|    warn: valeur de l'option de S 'warn'          |
|    PTrace: 1 si il y a LgTrace dans le controle  |
| Parametres de sortie  :                          |
|    RetCode: code de retour de NLDebut            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  NLDebut                  |
| Fonctions appelantes :  la fonction S : nls2     |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void initnls2(check, warn, PTrace, RetCode)
TFuncInt *check, *warn, *PTrace, *RetCode;
/*--------------- Fin identification fonction ----*/

{

*RetCode = NLDebut(&Donnees, &Modele, &CtxPuss, CtxNum);
if(*RetCode !=OK)
  {
  fprintf(stderr ,"\n Error in the execution of the initialisation program: NLDebut\n");
  return;
  }

/* On change les actions par defaut de NL: */
/* --------------------------------------- */
/* Initialisation de la gestion des messages selon les options de la session S */
initcrolenls2(check, warn);

/* pas de trace si l'utilisateur n'a pas mis l'option check=T 
                ni de LgTrace  dans le contexte */
if ((*check == 0) && (*PTrace ==0))
  GNLControle.SortTrace=NULL;

return;

}
/* -------------- Fin fonction initnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : affectModnls2             |
| Role                  :                          |
|   Remplir la structure RetModele 
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  La fonction S: nls2                             |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void affectModnls2(NomTheta, NomBeta, NomGamF, NomGamV,
              NomValInt,NomLesF, NomLesDF,
             CasSedo, YaCalcV,
             NbTheta, NbBeta, NbGamF,NbGamV,
             NbJ, NbEq)

/* arguments d'entree */
char ***NomTheta, ***NomBeta, ***NomGamF, ***NomGamV;
char ***NomValInt, ***NomLesF, ***NomLesDF;

TFuncInt *CasSedo, *YaCalcV, *NbTheta, *NbBeta, *NbGamF, *NbGamV;
TFuncInt *NbJ, *NbEq;

/*--------------- Fin identification fonction ----*/

{


create_vect_str(NomTheta, *NbTheta,   &(RetModele.NomTheta));

if(*NbBeta>0) 
  {
  create_vect_str(NomBeta, *NbBeta,   &(RetModele.NomBeta));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(RetModele.NomBeta));
  }


if (*NbGamF>0)
  {
  create_vect_str(NomGamF, *NbGamF,   &(RetModele.NomGamF));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(RetModele.NomGamF));
  }

if (*NbGamV>0)
  {
   create_vect_str(NomGamV, *NbGamV,   &(RetModele.NomGamV));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(RetModele.NomGamV));
  }


if (*NbJ>0)
  {
   create_vect_str(NomValInt, *NbJ,   &(RetModele.NomValInt));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(RetModele.NomValInt));
  }

if (*NbEq>0)
  {
   create_vect_str(NomLesF, *NbEq,   &(RetModele.NomLesF));
   create_vect_str(NomLesDF, *NbEq,   &(RetModele.NomLesDF));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(RetModele.NomLesF));
  CreerVectStr((TShortInt)(0), &(RetModele.NomLesDF));
  }


RetModele.YaCalcV=(TLogic)*YaCalcV;

RetModele.CasSedo=(TShortInt)*CasSedo;


return;

}
/* -------------- Fin fonction affectModnls2 ----------------- */

