
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/
#include "nldcl.h"     /* les arguments de NL */

/*----------------FONCTIONS EXTERNES ------------*/
TShortInt CreerMat( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectShort(TShortInt nbele, TVectShort *pvect);
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
void create_mat(double *val, TFuncInt nblig, TFuncInt nbcol, TMat *Struct);
void create_vect(double *val, TFuncInt nbele, TVect *Struct);
void create_vect_int(TFuncInt *val, TFuncInt nbele, TVectShort *Struct);
void create_vect_long(TFuncInt *val, TFuncInt nbele, TVectLong *Struct);
void create_vect_str();
/* 5/7/2001: je ne declare pas les arguments
car warning: argument #1 is incompatible with prototype:
si on le fait et ca ne marche pas si on essaie d'etre compatible.
Les argu sont dans utilnls2.c:
 char **val, TFuncInt nbele, TVectStr *Struct);
*/



/*--------------- Identification fonction ----------
| Nom de la fonction    : crControlnls2           |
| Role                  :                          |
|     Remplir les composants de la structure       |
|     GNLControle dont on a ote la possibilite a   |
|     l'utilisateur de remplir                     |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  neant                    |
| Fonctions appelantes :  La fonction S: nls2      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crControlnls2()
/*--------------- Fin identification fonction ----*/

{

/* On force les calculs supplementaires */
GNLControle.Voulu.AsVar=VRAI;
GNLControle.Voulu.BVarZBP=VRAI;
GNLControle.Voulu.Corr=VRAI;
GNLControle.Voulu.ResNum=VRAI;
GNLControle.Voulu.Mu=VRAI;
GNLControle.Voulu.Residus=VRAI;
GNLControle.Voulu.ValW=VRAI;

if (GNLControle.FreqIp ==0)
  GNLControle.SortImp=NULL;
return;
}
/* -------------- Fin fonction crControlnls2 ----------------- */




/*--------------- Identification fonction ----------
| Nom de la fonction    : crStepItnls2           |
| Role                  :                          |
|     Remplir le composant de la structure       |
|     GNLControle EtapeIt
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  neant                    |
| Fonctions appelantes :  La fonction S: crControlnls2      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crStepItnls2(EtapeIt,n)
TFuncInt *EtapeIt, *n;
/*--------------- Fin identification fonction ----*/

{
TShortInt i;

for (i=0; i<*n ;i++)
  {
  GNLControle.EtapeIt[EtapeIt[i]-1]=VRAI;
  }

return;
}
/* -------------- Fin fonction crStepItnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : crEstimnls2              |
| Role                  :                          |
|   Remplir CtxNum par les estimateurs voulus      |
| Parametres d'entree   :                          |
|  estim: liste des codes numeriques des           |
|         estimateurs                              |
|  nbestim: leur nombre                            |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  neant                    |
| Fonctions appelantes :                           |
|     la fonction S: crCtxNumnls2                  | 
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crEstimnls2(estim, nbestim)

/* arguments d'entree */
TFuncInt *estim;
TFuncInt *nbestim;

/*--------------- Fin identification fonction ----*/

{
int i;
for(i=0;i<*nbestim;i++)
  {
  CtxNum[i].Estim= estim[i];
  }

return;
}
/* -------------- Fin fonction crEstimnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : crMyOwnnls2              |
| Role                  :                          |
|   Remplir CtxNum par NbZ,Effic,Sym,TypeCritStat  |
|  quand l'estimateur   est MYOWN                  |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  neant                    |
| Fonctions appelantes :                           |
|     la fonction S: crMyOwnnls2                  | 
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crMyOwnnls2(step, nbz, effic, typeW, typeFit)

/* arguments d'entree */
TFuncInt *step, *nbz, *effic, *typeW ,*typeFit;
/*--------------- Fin identification fonction ----*/

{
int i;
i=*step-1;
  CtxNum[i].TypeCritStat = *typeFit;
  CtxNum[i].NbZ= *nbz;
  CtxNum[i].Effic= *effic;
  CtxNum[i].Symm= *typeW;

return;
}
/* -------------- Fin fonction crMyOwnnls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : crDatanls2            |
| Role                  :                          |
|   Remplir la structure Donnees par les valeurs et|
|   les noms des variables explicatives et de la   |
|   variable reponse                               |
| Parametres d'entree   :                          |
|  XObsT, ValY,  NomX, NomY: voir notice NL        |
|  m: nombre de colonnes de XObsT                  |
|  n: nombre de lignes de XObsT                    |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  create_mat, create_vect, |
|                         create_vect_str          |
| Fonctions appelantes :                           |
|  La fonction S: crDatanls2                    |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crDatanls2(XObsT, ValY,  NomX, NomY, m,n)

/* arguments d'entree */
double *XObsT, *ValY;
char ***NomX, **NomY;
TFuncInt *m, *n;

/*--------------- Fin identification fonction ----*/

{

int lg;


create_mat(XObsT, *n, *m, &(Donnees.XObsT));
create_vect(ValY, *n,     &(Donnees.ValY));

/* AJOUT le 3/09/99 */
lg = strlen(*NomY) +1;
CREER_T1(Donnees.NomY, lg, char);
/* FIN AJOUT */

strcpy(Donnees.NomY,*NomY);
create_vect_str(NomX, *m,     &(Donnees.NomX));

return;

}
/* -------------- Fin fonction crDatanls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : crModelnls2             |
| Role                  :                          |
|   Remplir la structure Modele par les noms des   |
|   parametres, et remplir CasSedo et YaCalcV      |
| Parametres d'entree   :                          |
|  NomTheta, NomBeta, NomGamF, NomGamV,CasSedo,    |
|  YaCalcV: voir notice NL                         |
|  NbTheta, NbBeta: nombre de parametres de base   |
|  NbGamF,NbGamV: nombre de parametres de second   |
|                 niveau                           |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|                         create_vect_str          |
| Programmes NL appeles   :                        |
|                         CreerVectStr             |
| Fonctions appelantes :                           |
|  La fonction S: nls2                             |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void crModelnls2(NomTheta, NomBeta, NomGamF, NomGamV,
             CasSedo, YaCalcV,
             NbTheta, NbBeta, NbGamF,NbGamV)

/* arguments d'entree */
char ***NomTheta, ***NomBeta, ***NomGamF, ***NomGamV;
TFuncInt *CasSedo, *YaCalcV, *NbTheta, *NbBeta, *NbGamF, *NbGamV;

/*--------------- Fin identification fonction ----*/

{

create_vect_str(NomTheta, *NbTheta,   &(Modele.NomTheta));

if(*NbBeta>0) 
  {
  create_vect_str(NomBeta, *NbBeta,   &(Modele.NomBeta));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(Modele.NomBeta));
  }


if (*NbGamF>0)
  {
  create_vect_str(NomGamF, *NbGamF,   &(Modele.NomGamF));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(Modele.NomGamF));
  }

if (*NbGamV>0)
  {
   create_vect_str(NomGamV, *NbGamV,   &(Modele.NomGamV));
  }
else
  {
  CreerVectStr((TShortInt)(0), &(Modele.NomGamV));
  }


Modele.YaCalcV=(TLogic)*YaCalcV;

Modele.CasSedo=(TShortInt)*CasSedo;

return;

}
/* -------------- Fin fonction crModelnls2 ----------------- */




/*--------------- Identification fonction ----------
| Nom de la fonction    : crIntegnls2              |
| Role                  :                          |
|  Remplir le contexte d'integration               |
| Parametres d'entree   :                          |
|  voir notice NL                                  |
| Parametres de sortie  :                          |
|  Code: OK ou ERR                                 |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|   create_vect, create_vect_int,                  |
|   et le programme de NL: CreerVectShort          |
| Fonctions appelantes :                           |
|   la fonction S: crCtxIntegnls2                  |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crIntegnls2(NbCourbe, NbObsT, NbThetaSedo, NbEq, NbJ, 
            IndicCi, IndicX, PImpInteg, ImpInteg, Pjt,jt, Pitol,itol,
            NbIndicTj, NbT0T, NbTj, NbCondInit,
            Nbatol, Nbrtol, Nbiwork, Nbrwork,
            IndicTj, T0T, Tj, CondInit, 
            atol, rtol, iwork, rwork,
            Code)
/* scalaire */
TFuncInt *NbCourbe, *NbObsT, *NbThetaSedo, *NbEq, *NbJ, 
            *IndicCi, *IndicX, *PImpInteg, *Pjt, *Pitol,
            *ImpInteg, *jt, *itol,
            *NbIndicTj, *NbT0T, *NbTj, *NbCondInit,
            *Nbatol, *Nbrtol, *Nbiwork, *Nbrwork;

/* vecteur entier */
TFuncInt *IndicTj;

/* vecteurs ou matrices reels */
double *T0T, *Tj, *CondInit, *atol, *rtol;

/* vecteur entier */
TFuncInt *iwork;

/* vecteur reel */
double *rwork;

/* scalaire */
TFuncInt *Code;

/*--------------- Fin identification fonction ----*/

{
int i, j,l, longsys;


GNLCtxInteg.NbThetaSedo=(TShortInt)*NbThetaSedo;
GNLCtxInteg.NbEq=(TShortInt)*NbEq;
GNLCtxInteg.NbJ=(TShortInt)*NbJ;
GNLCtxInteg.IndicCi=(TShortInt)*IndicCi;
GNLCtxInteg.IndicX=(TShortInt)*IndicX;


if (*PImpInteg == 1 )
  GNLCtxInteg.ImpInteg=(TShortInt)*ImpInteg;
if (*Pjt==1)
  GNLCtxInteg.jt=(TShortInt)*jt;

if (*Pitol == 1)
  GNLCtxInteg.itol=(TShortInt)*itol;


if (*NbT0T == 1)
  GNLCtxInteg.T0Egal =1;
else
   GNLCtxInteg.T0Egal =0;

if ((*NbT0T !=1 ) && (*NbT0T != *NbCourbe) && (*NbT0T != *NbObsT))
  {
  fprintf(stderr,"The dimension of the 'start' component is wrong\n");
  *Code=ERR;
  return;
  }

create_vect(T0T, *NbT0T, &(GNLCtxInteg.T0T));

if (*NbIndicTj >0)
  {
  if (*NbIndicTj != (*NbJ))
    {
    fprintf(stderr,"error of compatibility: 'IndicTj' (see analDer) must have %d elements\n", (*NbJ));
    *Code=ERR;
    return;
    }
  create_vect_int(IndicTj, *NbIndicTj,   &(GNLCtxInteg.IndicTj));
  }
else
  {
  CreerVectShort((TShortInt)(1), &(GNLCtxInteg.IndicTj));
  GNLCtxInteg.IndicTj.donnees[0]=0;
  if (*NbTj == 0)
    { 
    fprintf(stderr,"Error of compatibility: integration values are missing\n");
    *Code=ERR;
    return;
    }
  if (*NbTj != ((*NbJ) * (*NbCourbe)))
    {
    fprintf(stderr,"Error of dimension: There must have %d integration values\n", ((*NbJ) * (*NbCourbe)));
    *Code=ERR;
    return;
    }

  GNLCtxInteg.Tj = (TMat *) calloc( *NbCourbe, sizeof(TMat));

  for ( i=0; i < *NbCourbe ; i++)
    {
    GNLCtxInteg.Tj[i].nblig=1;
    GNLCtxInteg.Tj[i].nbcol=GNLCtxInteg.NbJ;
    GNLCtxInteg.Tj[i].donnees=( TDouble ** )calloc( 1 , sizeof( TDouble));
    GNLCtxInteg.Tj[i].donnees[0]=( TDouble *)calloc(GNLCtxInteg.NbJ,sizeof(TDouble));
    }

  l=0;
  for ( i=0; i < *NbCourbe ; i++)
    {
    for ( j = 0 ; j < GNLCtxInteg.NbJ; j++)
      {
      GNLCtxInteg.Tj[i].donnees[0][j]= Tj[l];
      l=l+1;
      }
    }
  } /* fin du pas d'IndicTj */

if (*IndicCi == 0)
  {
  if (*NbCondInit == 0)
    {
    fprintf(stderr, "Initial conditions are missing\n");
    *Code=ERR;
    return;
    }

  if (*NbCondInit != ((*NbEq) * (*NbCourbe)))
    {
    fprintf(stderr, "There must have %d initial conditions\n", ((*NbEq) * (*NbCourbe)));
    *Code=ERR;
    return;
    }

  GNLCtxInteg.VectCi = ( TVect *) calloc( *NbCourbe, sizeof( TVect));
  for ( i = 0; i < *NbCourbe ; i++ )
    {
    GNLCtxInteg.VectCi[i].nbele=GNLCtxInteg.NbEq;
    GNLCtxInteg.VectCi[i].donnees=( TDouble *) calloc(GNLCtxInteg.NbEq, sizeof(TDouble));
    }

  l=0;
  for ( i = 0; i < *NbCourbe ; i++ )
    {
    for ( j=0; j < GNLCtxInteg.NbEq ; j++)
      {
      GNLCtxInteg.VectCi[i].donnees[j]=CondInit[l];
      l=l+1;
      }
    }
  longsys=GNLCtxInteg.NbEq+(GNLCtxInteg.NbEq*GNLCtxInteg.NbThetaSedo);
  } /* fin IndicCi == 0 */
else
  {
  /* cas ou IndicCi !=0 */
  longsys=GNLCtxInteg.NbEq+ GNLCtxInteg.NbEq*(GNLCtxInteg.NbEq+GNLCtxInteg.NbThetaSedo);
  }

if ((GNLCtxInteg.itol <0) || (GNLCtxInteg.itol > 4))
  {
  fprintf(stderr, "The value of 'itol' is wrong \n, ");
  *Code=ERR;
  return;
  }

if (*Pitol == 1)
  {
  if ( *Nbatol ==0)
    {
    fprintf(stderr,"'atol' is missing\n");
    *Code=ERR;
    return;
    }
  if (*Nbrtol ==0)
    {
    fprintf(stderr,"'rtol' is missing\n");
    *Code=ERR;
    return;
    }
  
  switch( GNLCtxInteg.itol)
    {
    case 1 :
      if (*Nbatol != 1)
        {
        fprintf(stderr,"When itol=1, 'atol' must have only 1 element\n");
        *Code=ERR;
        return;
        }
      if (*Nbrtol != 1)
        {
        fprintf(stderr,"When itol=1, 'rtol' must have only 1 element\n");
        *Code=ERR;
        return;
        }
      create_vect(atol, 1, &(GNLCtxInteg.atol));
      create_vect(rtol, 1, &(GNLCtxInteg.rtol));
      break;

    case 2 :
      if (*Nbatol != longsys)
        {
        fprintf(stderr,"When itol=2, 'atol' must have %d elements\n", longsys);
        *Code=ERR;
        return;
        }
      if (*Nbrtol != 1)
        {
        fprintf(stderr,"When itol=2, 'rtol' must have only 1 element\n");
        *Code=ERR;
        return;
        }
      create_vect(atol, longsys, &(GNLCtxInteg.atol));
      create_vect(rtol, 1, &(GNLCtxInteg.rtol));
      break;

    case 3 :
      if (*Nbatol != 1)
        {
        fprintf(stderr,"When itol=3, 'atol' must have only 1 element\n");
        *Code=ERR;
        return;
        }
      if (*Nbrtol != longsys)
        {
        fprintf(stderr,"When itol=3, 'rtol' must have %d elements\n", longsys);
        *Code=ERR;
        return;
        }
      create_vect(atol, 1, &(GNLCtxInteg.atol));
      create_vect(rtol, longsys, &(GNLCtxInteg.rtol));
      break;

    case 4 :
      if (*Nbatol != 1)
        {
        fprintf(stderr,"When itol=4, 'atol' must have %d elements\n", longsys);
        *Code=ERR;
        return;
        }
      if (*Nbrtol != 1)
        {
        fprintf(stderr,"When itol=4, 'rtol'  must have %d elements\n", longsys);
        *Code=ERR;
        return;
        }
      create_vect(atol, longsys, &(GNLCtxInteg.atol));
      create_vect(rtol, longsys, &(GNLCtxInteg.rtol));
      break;
    } /* fin du switch itol */
  } /* fin du GNLCtxInteg.itol != 0 */


if (*Nbiwork>0)
  {
  if (*Nbiwork !=9)
    {
    fprintf(stderr,"There must have 9 integer options\n");
    *Code=ERR;
    return;
    }
  GNLCtxInteg.iopt = 1;
  for(i=0;i<9;i++)
    GNLCtxInteg.proiwork[i]= iwork[i];
  }

if (*Nbrwork>0)
  {
  if (*Nbrwork != 7)
    {
    fprintf(stderr,"There must have 7 double options\n");
    *Code=ERR;
    return;
    }
  GNLCtxInteg.iopt = 1;
  for(i=0;i<7;i++)
    GNLCtxInteg.prorwork[i]= rwork[i];

  }

    
*Code=OK;

return;

}
/* -------------- Fin fonction crIntegnls2 ----------------- */

