
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
#include <stdio.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlglobal.h"
#include "nlchoix.h"
/*--------------- VARIABLES EXTERNES -------------*/
/* les arguments de NL: */
#include "nldcl.h"
/*----------------FONCTIONS EXTERNES ------------*/
short int calcf_(short int nbt, short int nbg, short int nbl, 
		 short int nbc, 
		 double *t, double *g, double **x, 
		 double *f, double **df, 
		 short int *le, short int *ie);


short int calcv_(short int nbt, short int nbb, short int nbg, short int nbl, 
		 short int nbc, 
		 double *t, double *b, double *g,
		 double *f, double **df, double **x, double *v, 
		 double **dtv, double **dbv, short int *le, short int *ie);

TShortInt AlloueSedo ( TLongInt NbObs,
                       TSedo *Sedo);
TShortInt CLv( TLongInt NbObsT,
	       TVectLong *NbRepet, TVect *Y1, TVect *Y2, TVect *Valf, TVect *VarY,
               TDouble *Lv);

TShortInt CreerMat( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectShort(TShortInt nbele, TVectShort *pvect);
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
TShortInt CVariance(TLogic YaCalcV, TShortInt Vari, TShortInt TypeSigma, 
		    TLongInt NbIter,
                    TLongInt NbObsT, 
		    TVectLong *NbRepet, TVect *Poids, TVect *Valf, 
		    TStatDon *StatDon, 
                    TDouble *Sigma, TVect *ValV, TMat *DValVT, TMat *DValVB,
		    TDouble *Scr);
TShortInt InitResNum(TDouble Sigma, TResNum *ResNum);
TShortInt InitResStat(TResStat *ResStat);
TShortInt ModSedo(TShortInt nbt,TShortInt nbg,TShortInt nbl,TShortInt nbc,
		  TDouble *theta, TDouble *gamf,TDouble **xobs,
		  TDouble ***FSedo,TDouble ***DFSedo,
		  TDouble *f, TDouble **df,
		  TShortInt *le,TShortInt *ie,
		  TShortInt indc);

void DetruSedo (TLongInt NbObs, TSedo *Sedo);
void DetruCtxI( TShortInt NbCourbe);
void DetruVect(TVect *pvect);
void DetruMatC(TMat *pmat);
void DetruDon(TDonnees *Donnees);
void  DetruMod(TModele *Modele);
void DetruTrace();

void generxnls2(double theta, double se, 
		double extends0, double extends1, 
		double bounds0, double bounds1, 
		TFuncInt nbpoints0, TFuncInt nbpoints1,double *x);

void initIsonls2(TFuncInt *TypeSigma, double *Sigma)
{
TLongInt   NbObs ;
TShortInt  i,j,NbTheta, NbBeta, varyn;
/* pointeurs sur des elements de structure pour ameliorer la performance */
TDouble *vary, **dvarytheta, *s2;


NbObs = Donnees.NbObs;

InitResStat(&(ResStat[0]));
InitResNum(*Sigma, &(ResNum[0]));
CtxPuss.TypeSigma = *TypeSigma;


/* allocation des ajustes et fctsensib */
/* ----------------------------------  */

NbTheta= Modele.NomTheta.nbele;
NbBeta= Modele.NomBeta.nbele;

/* Allocation des   Ajustes */
CreerVect((TShortInt)NbObs, &(ResStat[0].Ajustes.Valf));
CreerVect( (TShortInt)NbObs, &(ResStat[0].Ajustes.VarY));
/*  Allocation des FctSensib */
CreerMatC( (TShortInt)NbObs, NbTheta, &(ResStat[0].FctSensib.DValf));
CreerMatC( (TShortInt)NbObs, NbTheta, &(ResStat[0].FctSensib.DVarYTheta));
CreerMatC((TShortInt)NbObs,  NbBeta, &(ResStat[0].FctSensib.DVarYBeta));
/* si le nombre de beta=0, mettre a 0 le nombre de lignes, car c'est
equivalent a structure vide */
if (NbBeta ==0)
  {
  ResStat[0].FctSensib.DVarYBeta.nblig = 0;
  }

/* initialisation */
if(Modele.YaCalcV == FAUX)
  {
  s2 = Donnees.StatDon.S2.donnees;
  vary = ResStat[0].Ajustes.VarY.donnees;
  dvarytheta = ResStat[0].FctSensib.DVarYTheta.donnees;
  varyn = ResStat[0].Ajustes.VarY.nbele;
  NbTheta = ResStat[0].FctSensib.DVarYTheta.nbcol;

  for(i = 0; i < varyn; i++)
    {
    if (Modele.Vari == VI)
      {
      /* variance intra: V=S2 */
      vary[i] = s2[i];
      }
    else
      {
      vary[i] = (TDouble)1.0;
      }
    for (j=0; j < NbTheta; j ++)
      {
      dvarytheta[i][j] = (TDouble)ZERO;
      }
    }
}

if (Modele.CasSedo == VRAI)
  {
  /* allocation du sedo */
  /* ------------------ */
  AlloueSedo(Donnees.NbObs, &(ResStat[0].Sedo));
  }

/* allocation de Theta[0].Init: 
on y mettra les valeurs ou il faut calculer le critere */
NbTheta=NbTheta*Donnees.NbCourbe;
NbBeta=NbBeta*Donnees.NbCourbe;

CreerVect(NbTheta, &(Theta[0].Init));
CreerVect(NbBeta, &(Beta[0].Init));


return;
}
/* -------------- Fin fonction  initIsonls2 --------------- */

void delIsonls2()
{
long nbcourbes;

/*  ne pas detruire les parametres.Init: ce sont des pointeurs sur
  les parametres du modele */
if (Modele.CasSedo==VRAI)
  {
  DetruSedo(Donnees.NbObs, &(ResStat[0].Sedo));
  nbcourbes = (long) Donnees.NbCourbe;
  DetruCtxI(Donnees.NbCourbe);
  }
/* les ajustes */
DetruVect( &(ResStat[0].Ajustes.Valf));
DetruVect( &(ResStat[0].Ajustes.VarY));

/* les fctsensib */
DetruMatC( &(ResStat[0].FctSensib.DValf));
DetruMatC(  &(ResStat[0].FctSensib.DVarYTheta));

if (Modele.NomBeta.nbele >0)
    DetruMatC(&(ResStat[0].FctSensib.DVarYBeta));

DetruDon(&Donnees);
DetruMod(&Modele);
DetruTrace();

return;
}
/* -------------- Fin fonction  delIsonls2 --------------- */





/*--------------- Identification fonction ----------
| Nom de la fonction    : CMyModele                  |
| Role                  :  Calcul des valeurs du   |
|  modele                                          |
--------------------------------------------------*/

TShortInt CMyModele(NbTheta, NbBeta)
/* arguments d'entree */
TShortInt NbTheta, NbBeta; /* nombre de param de base */


/*--------------- Fin identification fonction ----*/

{
/* locals */
TShortInt IParamT, IParamB, IObs, ICourbe, i, nbele;
TShortInt IndErr, nbcourbe, nbvarex;


/* pointeurs sur des elements de structure pour ameliorer la performance */
TShortInt Code;
TDouble *VarY;

/* Ecriture de la trace */
ECRTRACE("CMyModele");

/* initialisations */
nbcourbe = Donnees.NbCourbe;
nbvarex = Donnees.XObs.nbcol;
Code=OK;

/* initialisation de la boucle sur les courbes */
IParamT = 0;
IParamB = 0;
IObs = 0;

for (ICourbe = 0 ; ICourbe < nbcourbe; ICourbe++)
  {
  if (Modele.CasSedo == VRAI)
    {
    Code = ModSedo(NbTheta, 
                   Modele.GamF.nbele, 
                   Donnees.NbObsC.donnees[ICourbe],
                   nbvarex,
                   &(Theta[0].Init.donnees[IParamT]), 
                   &(Modele.GamF.donnees[0]),
                   &(Donnees.XObs.donnees[IObs]),
                   &(ResStat[0].Sedo.FSedo[IObs]),
                   &(ResStat[0].Sedo.DFSedo[IObs]),
                   &(ResStat[0].Ajustes.Valf.donnees[IObs]), 
                   &(ResStat[0].FctSensib.DValf.donnees[IObs]),
                   &(ResNum[0].InfoModErr.LieuErr), &IndErr, ICourbe);

    }
  else
    {
    Code =calcf_(NbTheta, 
                   Modele.GamF.nbele, 
                   Donnees.NbObsC.donnees[ICourbe],
                   nbvarex,
                   &(Theta[0].Init.donnees[IParamT]), 
                   &(Modele.GamF.donnees[0]),
                   &(Donnees.XObs.donnees[IObs]),
                   &(ResStat[0].Ajustes.Valf.donnees[IObs]), 
                   &(ResStat[0].FctSensib.DValf.donnees[IObs]),
                   &(ResNum[0].InfoModErr.LieuErr), &IndErr);
    }

  if (Code != OK)
    {
    /* Une erreur est decelee dans le calcul de f ou df */
    fprintf(stderr, "Error when computing the regression function at the observation %d of the curve %d\n",
      IndErr, ICourbe);
    return(Code);
    }

  if(Modele.YaCalcV == VRAI)
    {
    Code =
           calcv_(NbTheta, NbBeta, Modele.GamV.nbele, 
                 Donnees.NbObsC.donnees[ICourbe],
                 nbvarex,
                 &(Theta[0].Init.donnees[IParamT]), 
                 &(Beta[0].Init.donnees[IParamB]),
                 &(Modele.GamV.donnees[0]),
                 &(ResStat[0].Ajustes.Valf.donnees[IObs]),
                 &(ResStat[0].FctSensib.DValf.donnees[IObs]),
                 &(Donnees.XObs.donnees[IObs]),
                 &(ResStat[0].Ajustes.VarY.donnees[IObs]),
                 &(ResStat[0].FctSensib.DVarYTheta.donnees[IObs]),
                 &(ResStat[0].FctSensib.DVarYBeta.donnees[IObs]),
                 &(ResNum[0].InfoModErr.LieuErr), &IndErr);

    if (Code != OK)
      {
      /* Une erreur est decelee dans le calcul de v ou dv */
      fprintf(stderr, "Error when computing the variance function at the observation %d of the curve %d\n",
      IndErr, ICourbe);
      return(Code);
      }
    } /* fin YaCalcV */

  /* incrementation des indices de boucle */
  IParamT = IParamT + NbTheta;
  IParamB = IParamB + NbBeta;
  IObs = IObs + Donnees.NbObsC.donnees[ICourbe];
  } /* fin boucle sur les courbes */


/* calcul de la variance de Y si necessaire */
if (Modele.Vari != VI)
  {
  if (Modele.YaCalcV == FAUX)
    {
    VarY = ResStat[0].Ajustes.VarY.donnees;
    nbele = ResStat[0].Ajustes.VarY.nbele;
    /* initialiser VarY car CVariance considera sinon
    les anciennes valeurs 
     pas la peine de reinitialiser ses derivees car elles
     sont deja initialisees a 0 et CVariance les divisera mais
     ca ne changera pas leur valeur */
    for (i=0; i<nbele; i++)
      {
      VarY[i]=(TDouble)1.0;
      }
    } /* fin de YaCalc FAUX */
  
    Code=CVariance(Modele.YaCalcV, Modele.Vari, CtxPuss.TypeSigma, 
                    ResNum[0].NbIter,
                    Donnees.NbObsT,
                    &(Donnees.NbRepet), 
                    &(Donnees.Poids), 
                    &(ResStat[0].Ajustes.Valf), 
                    &(Donnees.StatDon),
                    &(ResNum[0].Sigma), 
                    &(ResStat[0].Ajustes.VarY), 
                    &(ResStat[0].FctSensib.DVarYTheta),
                    &(ResStat[0].FctSensib.DVarYBeta),
                    &(ResNum[0].Scr));

    } /* fin du  Modele.Vari != VI */


return(Code);
}

void
calclognls2(theta, beta, extends, bounds, nbpoints, istheta, axe1, axe2, se1, se2, 
            x,y,loglik, code)
/* arguments d'entree */
/* vectors */
double *theta, *beta, *extends, *bounds;
TFuncInt *nbpoints;
/* scalaires */
TFuncInt *istheta, *axe1, *axe2;
double *se1, *se2;

/* argu de sortie */
double *x, *y, *loglik;
TFuncInt *code;

{
/* Computing the likelihood criterion on given parameters values */
int i, l;
int NbTheta,NbBeta, NbThetaMult, NbBetaMult;
int ix, iy, nbx, nby;
int noaxe1, noaxe2;
/* en C: l'indice commence a 0 */
noaxe1= (int)*axe1 - 1;
noaxe2= (int)*axe2 - 1;

/* generation des coordonnees des points */

generxnls2(theta[noaxe1], *se1, extends[0], extends[1], 
            bounds[0], bounds[1],nbpoints[0], nbpoints[1], x);

generxnls2(theta[noaxe2], *se2, extends[2], extends[3], 
            bounds[2], bounds[3], nbpoints[2], nbpoints[3], y);

NbTheta=Modele.NomTheta.nbele;
NbBeta=Modele.NomBeta.nbele;
NbThetaMult=NbTheta * Donnees.NbCourbe;
NbBetaMult=NbBeta * Donnees.NbCourbe;

/* on met les valeurs courantes dans Theta[0].Init:
car deja en global: pas besoin de le reallouer a chaque fois */

for (i=0; i< NbThetaMult; i++)
  {
  Theta[0].Init.donnees[i]=theta[i];
  }
for (i=0; i<NbBetaMult; i++)
  { 
  Beta[0].Init.donnees[i]=beta[i];
  }

nbx= nbpoints[0]+ nbpoints[1];
nby= nbpoints[2]+ nbpoints[3];

l=0;
for (ix=0; ix< nbx; ix++)
  {
  if (*istheta==1) 
    {
    Theta[0].Init.donnees[noaxe1]=x[ix];
    }
  else
    {
    Beta[0].Init.donnees[noaxe1]=x[ix];
    }
  for (iy=0; iy<nby; iy++)
      {
      if (*istheta==1)
        {
        Theta[0].Init.donnees[noaxe2]=y[iy];
        }
      else
        {
        Beta[0].Init.donnees[noaxe2]=y[iy];
        }

    /* Calcul des valeurs ajustees du modele */

    *code=(TFuncInt)CMyModele(NbTheta, NbBeta);

    if(*code == OK)
      { 
      /* calcul du critere stat */
      *code=(TFuncInt)CLv(Donnees.NbObsT, &(Donnees.NbRepet),
                  &(Donnees.StatDon.Y1), &(Donnees.StatDon.Y2),
                  &(ResStat[0].Ajustes.Valf),  &(ResStat[0].Ajustes.VarY),
                  &(loglik[l]));
      l=l+1;
      }
    } /* fin boucle sur iy */
  } /* fin boucle sur ix */

return;
}

/* -------------- fin fonction  calclognls2 ---------------- */


